/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.mobile.reports;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileParamType;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReport;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReportType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class PaymentsTableMobileReport
extends MobileReport {
    private List<String> titles = null;

    @Override
    public MobileReportType getReportType(Connection con) {
        ArrayList<MobileParamType> list = new ArrayList<MobileParamType>();
        Calendar cal1 = Calendar.getInstance();
        cal1.add(6, -20);
        list.add(new MobileParamType("Date1", 1, "\u041e\u0442 \u0434\u0430\u0442\u044b", TimeUtils.format((Calendar)cal1, (String)"dd.MM.yyyy")));
        list.add(new MobileParamType("Date2", 1, "\u0414\u043e \u0434\u0430\u0442\u044b", TimeUtils.format((Calendar)Calendar.getInstance(), (String)"dd.MM.yyyy")));
        LinkedHashMap<Integer, String> fields = new LinkedHashMap<Integer, String>();
        fields.put(1, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440");
        fields.put(2, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        fields.put(3, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
        fields.put(4, "\u0421\u0443\u043c\u043c\u0430");
        fields.put(5, "\u0414\u0430\u0442\u0430");
        fields.put(6, "\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
        fields.put(7, "\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435");
        list.add(new MobileParamType("fields", 4, "\u041f\u043e\u043b\u044f", "1,2,3,4,5,6", fields));
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(10, "10");
        map.put(100, "100");
        map.put(1000, "1000");
        list.add(new MobileParamType("limit", 2, "\u041c\u0430\u043a\u0441. \u0440\u0430\u0437\u043c\u0435\u0440 \u0442\u0430\u0431\u043b.", "100", map));
        return new MobileReportType("\u041f\u0440\u0438\u0445\u043e\u0434\u044b( \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u044b\u0439 )", list);
    }

    @Override
    public List<Object> getData() throws BGIllegalArgumentException {
        this.grafType = 4;
        ArrayList<Object> list = null;
        try {
            Map usersMap = new UserManager(this.con).getUsersMap();
            Date date1 = TimeUtils.convertDateToSqlDate((java.util.Date)TimeUtils.parseDate((String)this.getParameter("Date1"), (String)"dd.MM.yyyy"));
            Date date2 = TimeUtils.convertDateToSqlDate((java.util.Date)TimeUtils.parseDate((String)this.getParameter("Date2"), (String)"dd.MM.yyyy"));
            String types = "";
            String groups = "";
            String mask = "";
            String groupMode = "";
            String users = "";
            String sort1 = this.getParameter("sort1");
            String sort2 = this.getParameter("sort2");
            String sort3 = this.getParameter("sort3");
            StringBuilder order = new StringBuilder();
            this.addOrder(order, sort1);
            this.addOrder(order, sort2);
            this.addOrder(order, sort3);
            int limit = Utils.parseInt((String)this.getParameter("limit"), (int)-1);
            if (date1 != null && date2 != null && types != null && groups != null) {
                int i;
                long groupMask = Utils.enumToMask((String)groups);
                this.titles = new ArrayList<String>();
                List visList = Utils.toIntegerList((String)this.getParameter("fields", "1,2,3,4,5,6"));
                String query = "SELECT " + this.getFields(visList) + " FROM contract AS t1, contract_payment AS t2, contract_payment_types AS t3  WHERE t1.id=t2.cid AND t3.id = t2.pt AND ( t2.dt >= ? OR ISNULL( ? ) ) AND ( t2.dt <= ? OR ISNULL( ? ) ) ";
                if (groupMask != 0L && Utils.notEmptyString((String)groupMode)) {
                    query = groupMode.equals("or") ? query + " AND t1.gr & " + groupMask + " > 0 " : query + " AND t1.gr & " + groupMask + "=" + groupMask + " ";
                }
                if (Utils.notEmptyString((String)types)) {
                    query = query + "AND t2.pt IN ( " + types + " ) ";
                }
                if (Utils.notEmptyString((String)users)) {
                    query = query + "AND t2.uid IN ( " + users + " ) ";
                }
                if (Utils.notEmptyString((String)mask)) {
                    query = query + "AND t1.title REGEXP '" + mask + "' ";
                }
                if (order.length() > 0) {
                    query = query + order.toString();
                }
                query = query + " LIMIT 0," + limit;
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setDate(1, date1);
                ps.setDate(2, date1);
                ps.setDate(3, date2);
                ps.setDate(4, date2);
                ResultSet rs = ps.executeQuery();
                list = new ArrayList<Object>();
                BigDecimal sum = BigDecimal.ZERO;
                int iU = visList.indexOf(3) + 1;
                int iS = visList.indexOf(4) + 1;
                while (rs.next()) {
                    String summa;
                    ArrayList<String> rowList = new ArrayList<String>();
                    for (i = 1; i < this.titles.size() + 1; ++i) {
                        if (i == iU) {
                            User user = (User)usersMap.get(rs.getInt(i));
                            rowList.add(user != null ? user.getName() : "???");
                            continue;
                        }
                        rowList.add(rs.getString(i));
                    }
                    if (iS > 0 && (summa = rs.getString(iS)) != null) {
                        sum = sum.add(Utils.parseBigDecimal((String)summa, (BigDecimal)BigDecimal.ZERO));
                    }
                    list.add(rowList);
                }
                if (sum.compareTo(BigDecimal.ZERO) == 1) {
                    String[] s = new String[this.titles.size()];
                    for (i = 0; i < this.titles.size(); ++i) {
                        s[i] = "";
                    }
                    s[iS - 1] = "\u0412\u0441\u0435\u0433\u043e:" + sum.toPlainString();
                    list.add(s);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    @Override
    public Map<String, Object> getOptions() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("titles", this.titles);
        return map;
    }

    private String getFields(List<Integer> visList) {
        StringBuilder fd = new StringBuilder();
        if (visList.size() > 0) {
            for (Integer el : visList) {
                int i = el;
                switch (i) {
                    case 1: {
                        fd.append("t1.title AS c1,");
                        this.titles.add("\u0414\u043e\u0433\u043e\u0432\u043e\u0440");
                        break;
                    }
                    case 2: {
                        fd.append("t2.comment AS c6,");
                        this.titles.add("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
                        break;
                    }
                    case 3: {
                        fd.append("t2.uid AS c7,");
                        this.titles.add("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
                        break;
                    }
                    case 4: {
                        fd.append("t2.summa AS c3,");
                        this.titles.add("\u0421\u0443\u043c\u043c\u0430");
                        break;
                    }
                    case 5: {
                        fd.append("t2.dt AS c4,");
                        this.titles.add("\u0414\u0430\u0442\u0430");
                        break;
                    }
                    case 6: {
                        fd.append("t3.title AS c5,");
                        this.titles.add("\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                        break;
                    }
                    case 7: {
                        fd.append("t1.comment AS c2,");
                        this.titles.add("\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435");
                    }
                }
            }
            fd.deleteCharAt(fd.length() - 1);
        } else {
            fd.append("t2.summa AS c3");
            this.titles.add("\u0421\u0443\u043c\u043c\u0430");
        }
        return fd.toString();
    }

    private void addOrder(StringBuilder order, String sort) {
        if (Utils.notBlankString((String)sort)) {
            if (order.length() == 0) {
                order.append(" ORDER BY ");
                order.append(sort);
            } else {
                order.append(",");
                order.append(sort);
            }
        }
    }
}

