/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rfiec.server;

import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.rfiec.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.rfiec.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.rfiec.server.event.RFIeCommerceAutopaymentEvent;
import ru.bitel.common.Utils;

public class Module
extends ModuleBase {
    private static final Logger log = LogManager.getLogger();

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.rfiec.server"};
    }

    public void start(Connection con, final BGModule module) throws BGException {
        EventProcessor.getInstance().addListener((EventListener)new EventListener<RFIeCommerceAutopaymentEvent>(){

            public void notify(RFIeCommerceAutopaymentEvent event, EventListenerContext ctx) throws BGException {
                Autopayment autopayment;
                int moduleId = module.getId();
                int contractId = event.getContractId();
                Connection con = ctx.getConnection();
                try (AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);){
                    autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                }
                if (autopayment == null || autopayment.getMode().getCode() != event.getMode()) {
                    return;
                }
                if (Utils.isBlankString((String)autopayment.getAccessToken())) {
                    log.error("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0434\u043b\u044f cid=" + contractId + ", \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d bindingId");
                    return;
                }
                BigDecimal sum = event.getSum();
                if (sum == null) {
                    sum = autopayment.getSum();
                }
                ContractDao contractDao = new ContractDao(con, 0);
                Contract contract = (Contract)contractDao.get(contractId);
                contractDao.close();
                if (contract != null) {
                    String customerAddress = "";
                    try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(con, 0);){
                        customerAddress = contractModuleConfigDao.get(contractId, "payment.email");
                    }
                    if (Utils.isBlankString((String)customerAddress)) {
                        contractModuleConfigDao = new ContractModuleConfigDao(con, moduleId);
                        try {
                            customerAddress = contractModuleConfigDao.get(contractId, "customerEmail");
                        }
                        finally {
                            contractModuleConfigDao.close();
                        }
                    }
                    try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                        transactionManager.doAutopaymentRequest(contractId, contract.getTitle(), customerAddress, autopayment.getAccessToken(), sum);
                    }
                }
            }
        }, RFIeCommerceAutopaymentEvent.class, module.getId(), null);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "rfiec", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

