/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rfiec.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.service.PaymentServiceProvider;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.rfiec.common.bean.Transaction;
import ru.bitel.bgbilling.modules.rfiec.common.service.RFIeCommerceService;
import ru.bitel.bgbilling.modules.rfiec.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.rfiec.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.rfiec.server.event.RFIeCommerceAutopaymentEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.function.ThrowingFunction;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.rfiec.common.service.RFIeCommerceService")
public class RFIeCommerceServiceImpl
extends AbstractService
implements RFIeCommerceService,
PaymentServiceProvider {
    private static final Logger logger = LogManager.getLogger();
    @Resource
    private ContractAutopaymentService contractAutopaymentService;
    private TransactionManager manager;

    @PostConstruct
    private void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(int contractId, String contractTitle, String status, Period period, String[] sort, Page page) throws BGException {
        SearchResult transactionSearchResult = new SearchResult(period, page, sort);
        this.manager.searchTransaction(transactionSearchResult, contractId, contractTitle, status);
        return transactionSearchResult;
    }

    public void checkTransactions(int contractId) throws BGException {
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> outerParamsHolder) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        this.beginAutopaymentTransaction(contractId, amount, url, mode, outerParamsHolder, null);
    }

    public void beginAutopaymentTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder, ContractAutopaymentMode autopaymentMode) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        HashMap<String, Object> dataMap;
        block27: {
            String customerAddress2;
            if (mode != null) {
                mode.value = "post";
            }
            if (amount == null) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
            }
            if ((amount = amount.setScale(2, RoundingMode.HALF_EVEN)).compareTo(BigDecimal.ZERO) <= 0) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
            }
            if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
                throw new BGException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
            }
            BigDecimal sum = amount;
            if (autopaymentMode == null) {
                BigDecimal sumMin = this.getModuleSetup().getBigDecimal("rfiec.sum.min", new BigDecimal(100));
                BigDecimal sumMax = this.getModuleSetup().getBigDecimal("rfiec.sum.max", new BigDecimal(5000));
                if (sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                    throw new BGException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
                }
            }
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(contractId));
            String contractTitle = contractRuntime.getContractTitle();
            Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
            String customerAddress = (String)params.get("email");
            if (Utils.isBlankString((String)customerAddress)) {
                customerAddress = (String)params.get("receiptTo");
            }
            if (Utils.isBlankString((String)(customerAddress2 = (String)params.get("phone"))) || customerAddress2.equals(customerAddress)) {
                customerAddress2 = null;
            }
            dataMap = new HashMap<String, Object>();
            if (autopaymentMode != null) {
                if (autopaymentMode != null && autopaymentMode.getMode() != AutopaymentMode.OFF) {
                    this.contractAutopaymentService.contractAutopaymentModeCheck(contractId, autopaymentMode);
                }
                if (customerAddress == null || !customerAddress.contains("@")) {
                    throw new BGMessageException("\u0414\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c email.", "autopayment.email.required");
                }
                try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
                     AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);){
                    String customerAddressF = customerAddress;
                    String customerAddress2F = customerAddress2;
                    ThrowingFunction registerOrder = registerSum -> transactionManager.registerOrder(contractId, contractTitle, customerAddressF, customerAddress2F, (BigDecimal)registerSum, (Map<String, Object>)dataMap, true);
                    autopaymentManager.registerAutopayment(contractId, autopaymentMode, (Function)registerOrder);
                    break block27;
                }
            }
            try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
                String customerAddressF = customerAddress;
                String customerAddress2F = customerAddress2;
                transactionManager.registerOrder(contractId, contractRuntime.getContractTitle(), customerAddressF, customerAddress2F, sum, dataMap, false);
            }
        }
        if (paramsHolder != null) {
            paramsHolder.value = new MapHolder(dataMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> String.valueOf(e.getValue()))));
        }
        url.value = this.getModuleSetup().get("rfiec.url.gate", "https://partner.rficb.ru/alba/input/");
    }

    public Autopayment autopaymentGet(int contractId) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
        autopaymentManager.close();
        return autopayment;
    }

    public void autopaymentDeactivate(int contractId) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        ContractAutopaymentMode.ContractAutopaymentModePeriodic autopaymentMode = new ContractAutopaymentMode.ContractAutopaymentModePeriodic();
        autopaymentMode.setMode(AutopaymentMode.OFF);
        try (AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);){
            autopaymentManager.registerAutopayment(contractId, (ContractAutopaymentMode)autopaymentMode, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransactionOld(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> outerParamsHolder) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        if (mode != null) {
            mode.value = "post";
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
            throw new BGException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = amount.setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.getModuleSetup().getBigDecimal("rfiec.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.getModuleSetup().getBigDecimal("rfiec.sum.max", new BigDecimal(5000));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            throw new BGException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
        }
        try (TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);){
            String name = "";
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(contractId));
            name = this.getModuleSetup().get("rfiec.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractRuntime.getContractTitle());
            Transaction transaction = new Transaction();
            transaction.setSum(sum);
            transaction.setContractId(contractId);
            transaction.setCreateDate(new Date());
            transactionManager.update(transaction);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("service_id", this.getModuleSetup().get("rfiec.service.id", ""));
            dataMap.put("order_id", String.valueOf(transaction.getId()));
            dataMap.put("cost", new DecimalFormat("###########0.00").format(sum).replace(",", "."));
            dataMap.put("name", name);
            try {
                dataMap.put("check", TransactionManager.signVer2("POST", this.getModuleSetup().get("rfiec.url.gate", "https://partner.rficb.ru/alba/input/"), dataMap, this.getModuleSetup().get("rfiec.secret.key", "")));
            }
            catch (UnsupportedEncodingException | URISyntaxException | InvalidKeyException | NoSuchAlgorithmException e) {
                dataMap.put("check", e.getMessage());
            }
            if (outerParamsHolder != null) {
                outerParamsHolder.value = new MapHolder(dataMap);
            }
            url.value = this.getModuleSetup().get("rfiec.url.gate", "https://partner.rficb.ru/alba/input/");
            if (logger.isDebugEnabled()) {
                logger.debug("key: " + (String)dataMap.get("key"));
                logger.debug("name: " + (String)dataMap.get("name"));
                logger.debug("cost: " + (String)dataMap.get("cost"));
                logger.debug("order_id: " + (String)dataMap.get("order_id"));
            }
        }
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
        autopaymentManager.close();
        return autopayment;
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        autopaymentManager.close();
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
        if (contractId > 0) {
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
            autopaymentManager.close();
            if (autopayment != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
                try {
                    EventProcessor.getInstance().publish((Event)new RFIeCommerceAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
                }
                catch (BGException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

