<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<script type="text/javascript">
<!--

function doPay( form )
{
	jQuery.get( webexecuter, { action: '${action}', operation: 'getOrderId', module: '${module}', mid: ${mid}, contractId: contractId, ct: 'json', sum: form.sum.value.replace(',','.'), customerAddress: getFormValue( form, 'customerAddress' ) }, 
		function( data )
		{
			var form = jQuery( "#rfiecGateForm" )[0];
			form.service_id.value = data.service_id;
			form.order_id.value = data.order_id;
			form.cost.value = data.cost;
			form.name.value = data.name;
			form.check.value = data.check;
			form.submit();
		}
	);
	return false;
}

function doAutopayment()
{
	var form = jQuery('form.autopayment')[0];
	jQuery.get( webexecuter, { action: '${action}', operation: 'autopayment', module: '${module}', mid: ${mid}, contractId: contractId, ct: 'json', mode: form.mode.value,
		        dayOfWeek: getFormValue( form, 'dayOfWeek' ), weekSum: getFormValue( form, 'weekSum' ), 
		        dayOfMonth: getFormValue( form, 'dayOfMonth' ), monthSum: getFormValue( form, 'monthSum' ),
				maxDaySum: getFormValue( form, 'maxDaySum' ), maxWeekSum: getFormValue( form, 'maxWeekSum' ), maxMonthSum: getFormValue( form, 'maxMonthSum' ), 
				customerEmail: getFormValue( form, 'customerEmail' ) }, 
			function( data )
			{
				if ( data.mode > 0 )
				{
					var form = jQuery( "#rfiecGateForm" )[0];
					form.service_id.value = data.service_id;
					form.order_id.value = data.order_id;
					form.cost.value = data.cost;
					form.name.value = data.name;
					if ( 'recurrent_type' in data )
					{
						addInputHidden( form, "email", data.email );
						addInputHidden( form, "payment_type", data.payment_type );
						addInputHidden( form, "recurrent_type", data.recurrent_type );
						addInputHidden( form, "recurrent_comment", data.recurrent_comment );
						addInputHidden( form, "recurrent_url", data.recurrent_url );
						addInputHidden( form, "recurrent_period", data.recurrent_period );
					}
					form.check.value = data.check;
					form.submit();
				}
				else ( data.mode == 0 )
				{
					jQuery("#autopaymentDialog").dialog("destroy");
				}
			}
		);
		return false;
}
-->
</script>

<form action="${dataMap['gateUrl']}" method="POST" id="rfiecGateForm" accept-charset="UTF-8">
<input type="hidden" name="version" value="2.0" />
<input type="hidden" name="service_id" value="" />
<input type="hidden" name="cost" value="" />
<input type="hidden" name="name" value=""/>
<input type="hidden" name="order_id" value="" />
<input type="hidden" name="check" value="" />
</form>

<%@include file="../include/error.jsp" %>

<table class="tableFont tableWidth">
  <tr>
    <td style="padding: 0px;">
		<c:set var="paymentName" value="rfiec" scope="request" />
		<c:set var="paymentPayText" scope="request">Платежный сервис РФИ Банка</c:set>
		<jsp:include page="../include/payment_tabs.jsp"/>
		<jsp:include page="../include/payment_pay.jsp"/>
		<jsp:include page="../include/payment_auto.jsp"/>
	</td>
	<td style="width: 20px;">&nbsp;</td>
    <td style="vertical-align: top; text-align: right; padding: 0;"><div class="bgBalanceInformerWidget"></div></td>
  </tr>
</table>

<div style="margin-top: 20px;">
	<form method="GET" action="" id="rfiecListForm" >
		<input type="hidden" name="action" value="${action}">
		<input type="hidden" name="module" value="${module}">
		<input type="hidden" name="mid" value="${mid}">
		<input type="hidden" name="status" value="${dataMap['status']}">
		<input type="hidden" name="month" value="${dataMap['month']}">
		<input type="hidden" name="year" value="${dataMap['year']}">
		<input type="hidden" name="pageIndex" value="${dataMap['page'].pageIndex}" />
		<input type="hidden" name="pageSize" value="${dataMap['page'].pageSize}" />
	</form>

	<table class="tableFont tableWidth1024">
	  <tr>
		<td><div class="bgMonthAndYearWidget" formId="rfiecListForm" month="${dataMap['period'].monthFrom}" year="${dataMap['period'].yearFrom}"></div></td>
		<td style="text-align: right;"><div class="bgPagesWidget" formId="rfiecListForm" recordCount="${dataMap['page'].recordCount}" pageIndex="${dataMap['page'].pageIndex}" pageSize="${dataMap['page'].pageSize}" pageCount="${dataMap['page'].pageCount}" /></td>
	  </tr>
	  <tr>
	  	<td><div style="display: none;">Статус: <select onchange="jQuery('#rfiecListForm')[0].status.value=this.value;jQuery('#rfiecListForm')[0].submit();">
	  	<c:forEach var="item" items="${dataMap['statusList']}">
	  	<c:set var="selected"><c:if test="${item.code eq dataMap['status']}">selected="1"</c:if> </c:set>
	  	<option value="${item.code}" ${selected}>${item.title}</option>
	  	</c:forEach>
	  	</select></div></td>
	  	<td style="text-align: right;"><div>[<a href="#" onclick="jQuery(this).parent().hide().next().show().parent().prev().children().show();">показать допол. фильтры</a>]</div><div style="display: none;">[<a href="#" onclick="jQuery(this).parent().hide().prev().show().parent().prev().children().hide();">скрыть допол. фильтры</a>]</div></td>
	  </tr>
	</table>

	<table class="table tableFont tableWidth1024" style="border-radius: 20px;">
		<thead>
			<tr>
				<td width="50">№</td>
				<td width="150">Дата/Время оплаты</td>
				<td>Статус</td>
				<td width="150">Сумма</td>
			</tr>
		</thead>
		<tbody>
		<c:choose>
		<c:when test="${not empty dataMap['transactions']}">
			<c:forEach var="item" items="${dataMap['transactions']}">
				<tr>
					<td>${item.id}</td>
					<c:choose>
						<c:when test="${not empty item.transactionDate}"><td><fmt:formatDate value="${item.transactionDate}" type="both" dateStyle="MEDIUM" timeStyle="MEDIUM" /></td></c:when>
						<c:otherwise><td><fmt:formatDate value="${item.createDate}" type="both" dateStyle="MEDIUM" timeStyle="MEDIUM" /></td></c:otherwise>
					</c:choose>
					<td><c:forEach var="statusItem" items="${dataMap['statusList']}"><c:if test="${item.status eq statusItem.code}">${statusItem.title}</c:if></c:forEach></td>
					<td><fmt:formatNumber value="${item.sum}" minFractionDigits="2" /></td>
				</tr>
			</c:forEach>
		</c:when>
		<c:otherwise>
			<tr><td colspan="5" style="text-align: center;">Записи не найдены.</td></tr>
		</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
