/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGControlPanelMonth;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ServiceService;
import ru.bitel.bgbilling.modules.rscm.client.RSCMUtils;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallment;
import ru.bitel.bgbilling.modules.rscm.common.service.RSCMService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ServicePropertiesServices
extends BGUPanel {
    private BGUTable serviceTable = null;
    private BGUTable installmentTable = null;
    private RSCMService rscmService = null;
    private JLabel recordsLabel = new JLabel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelMonth periodPanel = new BGControlPanelMonth();
    private ContractServiceTableModel serviceTableModel = new ContractServiceTableModel();
    private ContractServiceInstallmentTableModel installmentTableModel = new ContractServiceInstallmentTableModel();
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            LocalDate calendar = ServicePropertiesServices.this.periodPanel.getLocalDate().withDayOfMonth(1);
            Period period = new Period(calendar, calendar.plusMonths(1L).minusDays(1L));
            SearchResult searchResult = ServicePropertiesServices.this.getRSCMService().searchRSCMContractService(((ClientContext)ServicePropertiesServices.this.getContext()).getContractId(), period, ServicePropertiesServices.this.serviceTable.getSort(), ServicePropertiesServices.this.pagePanel.getPage());
            ServicePropertiesServices.this.serviceTableModel.setData(searchResult.getList(), true);
            ServicePropertiesServices.this.pagePanel.setPage(searchResult.getPage());
            ServicePropertiesServices.this.recordsLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            ServicePropertiesServices.this.loadInstallmentAction.perform();
        }
    };
    AbstractBGUPanel.DefaultAction loadInstallmentAction = new AbstractBGUPanel.DefaultAction("loadInstallment", "\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            SearchResult searchResult = ServicePropertiesServices.this.getRSCMService().searchRSCMContractServiceInstallment(((ClientContext)ServicePropertiesServices.this.getContext()).getContractId(), ServicePropertiesServices.this.installmentTable.getSort(), null);
            ServicePropertiesServices.this.installmentTableModel.setServices(((ServiceService)((ClientContext)ServicePropertiesServices.this.getContext()).getPort(ServiceService.class, 0)).serviceList(((ClientContext)ServicePropertiesServices.this.getContext()).getModuleId()));
            ServicePropertiesServices.this.installmentTableModel.setData(searchResult.getList(), true);
        }
    };
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u0430\u044f"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            new EditorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", new RSCMContractService()).getDialog().setVisible(true);
        }
    };
    AbstractBGUPanel.DefaultAction editAction = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            RSCMContractService rscmContractService = (RSCMContractService)ServicePropertiesServices.this.serviceTableModel.getSelectedRow();
            if (rscmContractService != null) {
                if (rscmContractService.getInstallmentId() > 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e");
                    return;
                }
                new EditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", rscmContractService).getDialog().setVisible(true);
            }
        }
    };
    AbstractBGUPanel.DefaultAction deleteAction = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            RSCMContractService rscmContractService = (RSCMContractService)ServicePropertiesServices.this.serviceTableModel.getSelectedRow();
            if (rscmContractService != null) {
                if (rscmContractService.getInstallmentId() > 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e");
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    try {
                        ServicePropertiesServices.this.getRSCMService().deleteRSCMContractService(rscmContractService.getId(), ((ClientContext)ServicePropertiesServices.this.getContext()).getContractId(), rscmContractService.getDate());
                        EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)ServicePropertiesServices.this.getContext()).getContractId()));
                        ServicePropertiesServices.this.performAction("refresh");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        }
    };

    protected void jbInit() throws Exception {
        this.serviceTable = new BGUTable((TableModel)((Object)this.serviceTableModel));
        this.serviceTable.setSelectionMode(0);
        this.serviceTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServicePropertiesServices.this.performAction("edit");
                }
            }
        });
        this.periodPanel.setDate();
        this.periodPanel.addPropertyChangeListener(evt -> {
            if ("date".equals(evt.getPropertyName())) {
                this.pagePanel.setPageIndex(1);
                this.performAction("refresh");
            }
        });
        this.pagePanel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().startsWith("to")) {
                this.performAction("refresh");
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.serviceTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.getInstallmentPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.periodPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.recordsLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getInstallmentPanel() {
        JMenuItem suspendMenuItem = new JMenuItem("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        suspendMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().suspendRSCMContractServiceInstallment(installment.getId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        JMenuItem resumeMenuItem = new JMenuItem("\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
        resumeMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().resumeRSCMContractServiceInstallment(installment.getId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        JMenuItem cancelMenuItem = new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438");
        cancelMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().cancelRSCMContractServiceInstallment(installment.getId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        JMenuItem infoMenuItem = new JMenuItem("\u0414\u0430\u043d\u043d\u044b\u0435 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438");
        infoMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                JTextArea info = new JTextArea(20, 70);
                info.setMargin(new Insets(3, 3, 3, 3));
                info.setText(new JSONObject(((RSCMContractServiceInstallment)rows.get(0)).getInstallment()).toString(3));
                JScrollPane scrollPane = new JScrollPane(info);
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, "\u0414\u0430\u043d\u043d\u044b\u0435 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438", 1);
            }
        });
        JMenuItem deleteMenuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        deleteMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().deleteRSCMContractServiceInstallment(installment.getId(), ((ClientContext)this.getContext()).getContractId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        this.installmentTable = new BGUTable((TableModel)((Object)this.installmentTableModel));
        this.installmentTable.setSelectionMode(0);
        this.installmentTable.getPopupMenu().add(suspendMenuItem);
        this.installmentTable.getPopupMenu().add(resumeMenuItem);
        this.installmentTable.getPopupMenu().add(cancelMenuItem);
        this.installmentTable.getPopupMenu().add(infoMenuItem);
        this.installmentTable.getPopupMenu().add(deleteMenuItem);
        Dimension dimension = new Dimension(200, 200);
        JScrollPane scrollPane = new JScrollPane((Component)this.installmentTable);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 3, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private RSCMService getRSCMService() {
        if (this.rscmService == null) {
            this.rscmService = (RSCMService)((ClientContext)this.getContext()).getPort(RSCMService.class);
        }
        return this.rscmService;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.periodPanel.setEnabled(enabled);
        this.serviceTable.setEnabled(enabled);
    }

    class ContractServiceTableModel
    extends AbstractTransactionTableModel<RSCMContractService> {
        public ContractServiceTableModel() {
            super(ContractServiceTableModel.class.getName(), RSCMContractService.class);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 100, 100, "date", true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 100, 100, -1, "serviceTitle", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430", Boolean.class, 100, 100, 100, "installment", true);
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 100, 100, 100, "amount", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f", 110, 110, 110, "unit", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.RIGHT);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        public Object getValue(RSCMContractService rscmContractService, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("installment".equals(identifier)) {
                return rscmContractService.getInstallmentId() > 0;
            }
            return super.getValue((Object)rscmContractService, column);
        }
    }

    class ContractServiceInstallmentTableModel
    extends BGTableModel<RSCMContractServiceInstallment> {
        private Map<Integer, String> serviceMap;

        public ContractServiceInstallmentTableModel() {
            super(ContractServiceInstallmentTableModel.class.getName());
            this.serviceMap = new HashMap<Integer, String>();
        }

        public void setServices(List<Service> list) {
            HashMap<Integer, String> serviceMap = new HashMap<Integer, String>();
            if (list != null && !list.isEmpty()) {
                for (Service service : list) {
                    serviceMap.put(service.getId(), service.getGuiTitle());
                }
            }
            this.serviceMap = serviceMap;
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", 130, 130, 130, "dateFrom", true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043b\u0435\u0434. \u043f\u043b\u0430\u0442\u0435\u0436\u0430", 150, 150, 150, "dateNext", true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 100, 100, -1, "serviceId", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 150, 150, "status", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 70, 70, 70, "amount", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041f\u043b\u0430\u0442\u0435\u0436\u0438", 100, 100, 100, "paymentCount", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e %", 100, 100, 100, "paymentSum", true).setTableCellRenderer(DecimalTableCellRenderer.DEFAULT);
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", 100, 100, -1, "installment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        public Object getValue(RSCMContractServiceInstallment installment, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("serviceId".equals(identifier)) {
                return this.serviceMap.getOrDefault(installment.getServiceId(), "#" + installment.getServiceId());
            }
            if ("paymentCount".equals(identifier)) {
                JSONObject json = new JSONObject(installment.getInstallment());
                JSONArray payments = json.optJSONArray("paymentsArray");
                return installment.getPaymentCount() + " \u0438\u0437 " + (payments == null ? 0 : payments.length());
            }
            if ("status".equals(identifier)) {
                return installment.getStatus().getTitle();
            }
            if ("installment".equals(identifier)) {
                return RSCMUtils.getInstallmentDescription(new JSONObject(installment.getInstallment()));
            }
            if ("paymentSum".equals(identifier)) {
                BigDecimal sum = BigDecimal.ZERO;
                JSONObject json = new JSONObject(installment.getInstallment());
                JSONArray paymentsArray = json.optJSONArray("paymentsArray");
                if (paymentsArray != null) {
                    for (int index = 0; index < installment.getPaymentCount(); ++index) {
                        sum = sum.add(paymentsArray.getBigDecimal(index));
                    }
                }
                return sum;
            }
            return super.getValue((Object)installment, column);
        }
    }

    class EditorDialog
    extends BGEditorDialog<RSCMContractService> {
        private JTextArea comment;
        private JTextField amount;
        private BGUList<IdTitle> service;
        private BGControlPanelDateNoB date;

        public EditorDialog(String title, RSCMContractService data) {
            super(title, (Object)data);
            this.comment = new JTextArea(5, 15);
            this.amount = new JTextField(5);
            this.service = new BGUList();
            this.date = new BGControlPanelDateNoB();
        }

        public void doDialogPanel() {
            this.amount.setHorizontalAlignment(0);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.comment.setLineWrap(true);
            this.comment.setWrapStyleWord(true);
            this.date.setButtonNow(true);
            this.service.setSelectionMode(0);
            this.service.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            Dimension dimension = new Dimension(600, 200);
            JScrollPane serviceComboPane = new JScrollPane((Component)this.service);
            serviceComboPane.setMinimumSize(dimension);
            serviceComboPane.setPreferredSize(dimension);
            this.panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.panel.add((Component)serviceComboPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.panel.add((Component)this.getLeftEditPanel(), new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 17, 1, new Insets(0, 5, 3, 0), 0, 0));
            try {
                List list = ServicePropertiesServices.this.getRSCMService().getRSCMContractServiceList(false);
                this.service.setData(list);
                if (((RSCMContractService)this.data).getId() > 0) {
                    list.stream().filter(i -> i.getId() == ((RSCMContractService)this.data).getServiceId()).forEach(i -> this.service.setSelectedValue(i, true));
                    this.date.setLocalDate(((RSCMContractService)this.data).getDate());
                    this.amount.setText(String.valueOf(((RSCMContractService)this.data).getAmount()).replace('.', ','));
                    this.comment.setText(((RSCMContractService)this.data).getComment());
                } else {
                    this.date.setLocalDate(null);
                    this.amount.setText("");
                    this.comment.setText("");
                }
                this.date.setEnabled(((RSCMContractService)this.data).getId() == 0);
                this.date.setButtonNow(((RSCMContractService)this.data).getId() == 0);
                this.amount.setEnabled(((RSCMContractService)this.data).getId() == 0 || ((RSCMContractService)this.data).getInstallmentId() < 1);
                this.service.setEnabled(((RSCMContractService)this.data).getId() == 0 || ((RSCMContractService)this.data).getInstallmentId() < 1 && ClientSetup.getInstance().getBoolean("dbinfo.rscm.service.list.enabled", false));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        private JPanel getLeftEditPanel() {
            int gridy = 0;
            JPanel editPanel = new JPanel(new GridBagLayout());
            editPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            editPanel.add((Component)this.date, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            editPanel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            editPanel.add((Component)this.amount, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            editPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 3, 0), 0, 0));
            editPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return editPanel;
        }

        public boolean doApply() throws Exception {
            if (this.date.getDateCalendar() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430!");
                return false;
            }
            if (Utils.isEmptyString((String)this.amount.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
                return false;
            }
            if (!this.amount.getText().matches("^\\d+,?\\d*$")) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430!");
                return false;
            }
            IdTitle idTitle = (IdTitle)this.service.getSelectedValue();
            if (idTitle == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443!");
                return false;
            }
            int serviceId = idTitle.getId();
            ((RSCMContractService)this.data).setDate(this.date.getLocalDate());
            ((RSCMContractService)this.data).setContractId(((ClientContext)ServicePropertiesServices.this.getContext()).getContractId());
            ((RSCMContractService)this.data).setServiceId(serviceId);
            ((RSCMContractService)this.data).setAmount(new BigDecimal(this.amount.getText().replace(',', '.')));
            ((RSCMContractService)this.data).setComment(this.comment.getText());
            try {
                ServicePropertiesServices.this.getRSCMService().updateRSCMContractService((RSCMContractService)this.data);
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)ServicePropertiesServices.this.getContext()).getContractId()));
                ServicePropertiesServices.this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }
}

