/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server;

import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMContractServiceManager;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMRecalculator;
import ru.bitel.bgbilling.modules.rscm.server.event.RSCMContractServiceUpdateEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.rscm.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        if (event instanceof ContractWrapEvent) {
            ContractWrapEvent cwEvent = (ContractWrapEvent)event;
            Connection con = serverContext.getConnection();
            if (!cwEvent.isCheck()) {
                this.wrapAmount(con, moduleId, cwEvent);
            }
        } else if (event instanceof ContractCreateEvent) {
            Element currentServices;
            Document dataDoc;
            ContractCreateEvent ccEvent = (ContractCreateEvent)event;
            Connection con = serverContext.getConnection();
            if (!ccEvent.isCheck() && (dataDoc = ccEvent.getPattern().getData()) != null && (currentServices = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/rscm[@mid=" + moduleId + "]/currentServices"))) != null) {
                int cid = ccEvent.getContractId();
                LocalDate now = LocalDate.now();
                NodeList nodes = currentServices.getChildNodes();
                boolean balanceChanged = false;
                try (RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(con, moduleId);){
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node n = nodes.item(i);
                        if (!"addCalculatedService".equals(n.getNodeName())) continue;
                        Element addCalculatedService = (Element)n;
                        int serviceId = Utils.parseInt((String)addCalculatedService.getAttribute("id"));
                        String comment = addCalculatedService.getAttribute("comment");
                        RSCMContractService contractService = new RSCMContractService();
                        contractService.setContractId(cid);
                        contractService.setDate(now);
                        contractService.setAmount(new BigDecimal(addCalculatedService.getAttribute("amount")));
                        contractService.setServiceId(serviceId);
                        contractService.setComment(comment);
                        contractServiceManager.updateContractService(contractService);
                        balanceChanged = true;
                        serverContext.publishAfterCommit((Event)new RSCMContractServiceUpdateEvent(ccEvent.getUserId(), moduleId, cid, contractService));
                    }
                }
                if (balanceChanged) {
                    BalanceUtils bu = new BalanceUtils(con);
                    bu.updateBalance(new Date(), cid);
                    bu.close();
                }
            }
        } else if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            Connection con = serverContext.getConnection();
            if (!cdEvent.isCheck()) {
                String cidStr = String.valueOf(event.getContractId());
                ServerUtils.deleteRowsFromTable((Connection)con, (String)("rscm_service_account_" + moduleId), (String)"cid", (String)cidStr, (String)"id");
            }
        }
    }

    private void wrapAmount(Connection con, int mid, ContractWrapEvent cwEvent) throws Exception {
        Calendar dateOpen = TimeUtils.convertDateToCalendar((Date)cwEvent.getDateOpen());
        GregorianCalendar now = new GregorianCalendar();
        String cids = cwEvent.getContractId() + "," + cwEvent.getToContractId();
        while (TimeUtils.monthsDelta((Calendar)dateOpen, (Calendar)now) >= 0) {
            String query = "UPDATE rscm_service_account_" + mid + " SET cid=? WHERE cid=? AND date>=?";
            PreparedStatement psUpdate = con.prepareStatement(query);
            psUpdate.setInt(1, cwEvent.getToContractId());
            psUpdate.setInt(2, cwEvent.getContractId());
            psUpdate.setDate(3, TimeUtils.convertDateToSqlDate((Date)cwEvent.getDateOpen()));
            psUpdate.executeUpdate();
            psUpdate.close();
            new RunTaskDataManager(con).addTask((RunTask)new RSCMRecalculator(mid, dateOpen, null, cids));
            dateOpen.add(2, 1);
        }
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        if (!onlyCurrent) {
            String cidStr = String.valueOf(cid);
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("rscm_service_account_" + mid), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        }
    }
}

