/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.bean;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.List;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMTariffRequestResult;

public class RSCMCalculatorUtils {
    public static RSCMTariffRequestResult processTariffRequest(ServiceCostCache costCache, List<TariffTreeSet.TariffSetEntry> treeList, int domainId, int contractId, int serviceId, BigDecimal amount, Calendar time, Logger log) {
        RSCMTariffRequestResult result = new RSCMTariffRequestResult();
        TariffRequest tariffRequest = null;
        for (TariffTreeSet.TariffSetEntry tree : treeList) {
            tariffRequest = new TariffRequest();
            tariffRequest.setRequestParam("sid", (Object)serviceId);
            tariffRequest.setRequestParam("time", (Object)time);
            tariffRequest.setRequestParam("cid", (Object)contractId);
            tariffRequest.setRequestParam("tree_id", (Object)tree.getTree().getTreeId());
            tariffRequest.setRequestParam("domainId", (Object)domainId);
            tree.getTree().processRequest(tariffRequest);
            result.tariffRequestString = tariffRequest.toString();
            BigDecimal cost = (BigDecimal)tariffRequest.getResponseParam("cost");
            BigDecimal divisor = (BigDecimal)tariffRequest.getResponseParam("divisor");
            if (tariffRequest.wasAccepted() && cost != null && divisor != null && divisor.longValue() > 0L) {
                result.accepted = true;
                costCache.addAmount(new CostSum(contractId, serviceId, cost.multiply(amount.divide(divisor, MathContext.DECIMAL128)).setScale(2, RoundingMode.HALF_UP)));
            }
            if (tariffRequest.getErrors().length() > 0) {
                log.error(tariffRequest.getErrors());
            }
            if (!result.accepted) continue;
            break;
        }
        return result;
    }
}

