/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;

public class RunTelContractTariffDao
extends AbstractIdDao<RunTelContractTariff> {
    public RunTelContractTariffDao(Connection con, int moduleId) {
        super(con, moduleId, "runtel_tariff_contract");
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(LocalDateTime date) throws BGException {
        Timestamp timestamp = Timestamp.valueOf(date);
        return this.list("((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{timestamp, timestamp});
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(Period period) throws BGException {
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate((Date)period.getDateFrom());
        if (period.getDateTo() == null) {
            return this.list("( `date_to` IS NULL OR `date_to` >= ? )", "id", new Object[]{sqlDateFrom});
        }
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate((Date)period.getDateTo());
        return this.list("((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{sqlDateTo, sqlDateFrom});
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(int contractId, PeriodWithTime period) throws BGException {
        if (period == null) {
            period = new PeriodWithTime();
        }
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate((Date)period.getDateFrom());
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate((Date)period.getDateTo());
        if (period.getDateFrom() == null && period.getDateTo() == null) {
            return this.list("contract_id=?", "date_from", new Object[]{contractId});
        }
        if (period.getDateTo() == null) {
            return this.list("contract_id=? AND ( `date_to` IS NULL OR `date_to` >= ? )", "date_from", new Object[]{contractId, sqlDateFrom});
        }
        if (period.getDateFrom() == null) {
            return this.list("contract_id=? AND ( `date_from` IS NULL OR `date_from` <= ? )", "date_from", new Object[]{contractId, sqlDateTo});
        }
        return this.list("contract_id=? AND ((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "date_from", new Object[]{contractId, sqlDateTo, sqlDateFrom});
    }

    public LocalDateTime getOnDate(int contractId) throws BGException {
        LocalDateTime dateTime = null;
        List contractTariffs = this.list("contract_id=? AND ( `date_to` IS NULL OR `date_to` >= CURDATE() )", "date_from", new Object[]{contractId});
        if (!contractTariffs.isEmpty()) {
            dateTime = ((RunTelContractTariff)contractTariffs.get(0)).getPeriod().getLocalDateTimeFrom();
        } else {
            contractTariffs = this.list("contract_id=?", "date_from", new Object[]{contractId});
            if (!contractTariffs.isEmpty()) {
                dateTime = ((RunTelContractTariff)contractTariffs.get(contractTariffs.size() - 1)).getPeriod().getLocalDateTimeFrom();
            }
        }
        return dateTime;
    }

    public RunTelContractTariff get(int contractId, LocalDate date) throws BGException {
        try {
            java.sql.Date sqlDate = java.sql.Date.valueOf(date);
            List list = this.list("contract_id=? AND  ((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{contractId, sqlDate, sqlDate});
            return list.isEmpty() ? null : (RunTelContractTariff)list.get(0);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        return super.delete("id=? AND date_from > CURDATE()", new Object[]{id});
    }

    protected RunTelContractTariff getFromRS(ResultSet rs) throws SQLException, BGException {
        RunTelContractTariff runTelContractTariff = new RunTelContractTariff();
        runTelContractTariff.setId(rs.getInt("id"));
        runTelContractTariff.setContractId(rs.getInt("contract_id"));
        runTelContractTariff.setTariffId(rs.getInt("tariff_id"));
        runTelContractTariff.setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        runTelContractTariff.setConfig(rs.getString("config"));
        return runTelContractTariff;
    }

    protected void updateImpl(RunTelContractTariff runTelContractTariff) throws BGException, SQLException {
        boolean insert = runTelContractTariff.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET contract_id=?, tariff_id=?, date_from=?, date_to=?, config=?" + (insert ? "" : " WHERE id=?");
        int parameterIndex = 1;
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        ps.setInt(parameterIndex++, runTelContractTariff.getContractId());
        ps.setInt(parameterIndex++, runTelContractTariff.getTariffId());
        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)runTelContractTariff.getPeriod().getDateFrom()));
        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)runTelContractTariff.getPeriod().getDateTo()));
        ps.setString(parameterIndex++, runTelContractTariff.getConfig());
        if (!insert) {
            ps.setInt(parameterIndex++, runTelContractTariff.getId());
        }
        ps.executeUpdate();
        if (insert) {
            runTelContractTariff.setId(ServerUtils.lastInsertId((Connection)this.con));
        }
        ps.close();
    }

    public void updateDateTo(int contractTariffId, LocalDateTime dateTo) throws BGException, SQLException {
        int parameterIndex = 1;
        PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET date_to=?  WHERE id=?");
        ps.setTimestamp(parameterIndex++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)dateTo));
        ps.setInt(parameterIndex++, contractTariffId);
        ps.executeUpdate();
        ps.close();
    }
}

