/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sbpilot.common.clientlocal;

import java.io.IOException;
import ru.bitel.bgbilling.apps.cashcheck.frk.common.CmdProtocolClient;
import ru.bitel.bgbilling.common.BGException;

public class CashcheckClientWrapper {
    private String connector;
    private String serveraddres;
    private int serverport;
    private String oppass;

    public CashcheckClientWrapper(String connector, String oppass) throws BGException {
        try {
            this.connector = connector;
            String[] params = connector.split(":");
            this.serveraddres = params[0];
            this.serverport = Integer.parseInt(params[1]);
            this.oppass = oppass;
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 cashcheckserver", (Throwable)e);
        }
    }

    public void print(String text, boolean endcut, String charcut) throws BGException {
        try (CmdProtocolClient client = new CmdProtocolClient(this.serveraddres, this.serverport);){
            if (charcut != null) {
                text = ((String)text).replaceAll(charcut, "\n!CUT%)\n");
            }
            if (endcut) {
                text = (String)text + "\n!CUT%)";
            }
            client.connect();
            boolean result = client.send("printtext", new Object[]{this.oppass, text});
            if (!result) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430! \u0441\u0435\u0440\u0432\u0435\u0440 \u043f\u0435\u0447\u0430\u0442\u0438 (" + this.serveraddres + ":" + this.serverport + ") \u0441\u043a\u0430\u0437\u0430\u043b: " + client.getReply());
            }
        }
        catch (IOException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u043f\u0435\u0447\u0430\u0442\u0438 \u041a\u041a\u041c (" + this.serveraddres + ":" + this.serverport + "):\n" + e.getMessage(), (Throwable)e);
        }
    }

    public String getConnector() {
        return this.connector;
    }
}

