/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostMaster;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostObject;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostProtocol;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostPtzType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRecordType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRtspTransport;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUtils;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseCameraModelsAndBrands;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostAccountDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostCameraBrandDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostCameraDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostCameraModelDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostMasterDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostObjectDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostProtocolDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostPtzTypeDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostRecordTypeDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostRtspTransportDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostUserDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService")
public class ForpostServiceImpl
extends AbstractService
implements ForpostService {
    public SearchResult<ForpostMaster> forpostMasterSearch(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setSort(sort);
        try (ForpostMasterDao forpostMasterDao = new ForpostMasterDao(this.getConnection(), this.moduleId);){
            forpostMasterDao.searchForpostMasters((SearchResult<ForpostMaster>)searchResult);
        }
        return searchResult;
    }

    public void forpostMasterSync() throws BGException {
        try (ForpostMasterDao forpostMasterDao = new ForpostMasterDao(this.getConnection(), this.moduleId);){
            forpostMasterDao.doSync(new ForpostManager(this.moduleId).getMasters());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ForpostMaster> forpostMasterList() throws BGException {
        try (ForpostMasterDao forpostMasterDao = new ForpostMasterDao(this.getConnection(), this.moduleId);){
            List<ForpostMaster> list = forpostMasterDao.list();
            return list;
        }
    }

    public SearchResult<ForpostProtocol> forpostProtocolSearch(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setSort(sort);
        try (ForpostProtocolDao forpostProtocolDao = new ForpostProtocolDao(this.getConnection(), this.moduleId);){
            forpostProtocolDao.searchForpostProtocols((SearchResult<ForpostProtocol>)searchResult);
        }
        return searchResult;
    }

    public void forpostProtocolSync() throws BGException {
        try (ForpostProtocolDao forpostProtocolDao = new ForpostProtocolDao(this.getConnection(), this.moduleId);){
            forpostProtocolDao.doSync(new ForpostManager(this.moduleId).getProtocols());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ForpostProtocol> forpostProtocolList() throws BGException {
        try (ForpostProtocolDao forpostProtocolDao = new ForpostProtocolDao(this.getConnection(), this.moduleId);){
            List<ForpostProtocol> list = forpostProtocolDao.list();
            return list;
        }
    }

    public SearchResult<ForpostPtzType> forpostPtzTypeSearch(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setSort(sort);
        try (ForpostPtzTypeDao forpostPtzTypeDao = new ForpostPtzTypeDao(this.getConnection(), this.moduleId);){
            forpostPtzTypeDao.searchForpostPtzTypes((SearchResult<ForpostPtzType>)searchResult);
        }
        return searchResult;
    }

    public void forpostPtzTypeSync() throws BGException {
        try (ForpostPtzTypeDao forpostPtzTypeDao = new ForpostPtzTypeDao(this.getConnection(), this.moduleId);){
            forpostPtzTypeDao.doSync(new ForpostManager(this.moduleId).getPtzTypes());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ForpostPtzType> forpostPtzTypeList() throws BGException {
        try (ForpostPtzTypeDao forpostProtocolDao = new ForpostPtzTypeDao(this.getConnection(), this.moduleId);){
            List<ForpostPtzType> list = forpostProtocolDao.list();
            return list;
        }
    }

    public SearchResult<ForpostRecordType> forpostRecordTypeSearch(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setSort(sort);
        try (ForpostRecordTypeDao forpostRecordTypeDao = new ForpostRecordTypeDao(this.getConnection(), this.moduleId);){
            forpostRecordTypeDao.searchForpostRecordTypes((SearchResult<ForpostRecordType>)searchResult);
        }
        return searchResult;
    }

    public void forpostRecordTypeSync() throws BGException {
        try (ForpostRecordTypeDao forpostRecordTypeDao = new ForpostRecordTypeDao(this.getConnection(), this.moduleId);){
            forpostRecordTypeDao.doSync(new ForpostManager(this.moduleId).getRecordTypes());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ForpostRecordType> forpostRecordTypeList() throws BGException {
        try (ForpostRecordTypeDao forpostRecordTypeDao = new ForpostRecordTypeDao(this.getConnection(), this.moduleId);){
            List<ForpostRecordType> list = forpostRecordTypeDao.list();
            return list;
        }
    }

    public SearchResult<ForpostRtspTransport> forpostRtspTransportSearch(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setSort(sort);
        try (ForpostRtspTransportDao forpostRtspTransportDao = new ForpostRtspTransportDao(this.getConnection(), this.moduleId);){
            forpostRtspTransportDao.searchForpostRtspTransports((SearchResult<ForpostRtspTransport>)searchResult);
        }
        return searchResult;
    }

    public void forpostRtspTransportSync() throws BGException {
        try (ForpostRtspTransportDao forpostRtspTransportDao = new ForpostRtspTransportDao(this.getConnection(), this.moduleId);){
            forpostRtspTransportDao.doSync(new ForpostManager(this.moduleId).getRtspTransports());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ForpostRtspTransport> forpostRtspTransportList() throws BGException {
        try (ForpostRtspTransportDao forpostProtocolDao = new ForpostRtspTransportDao(this.getConnection(), this.moduleId);){
            List<ForpostRtspTransport> list = forpostProtocolDao.list();
            return list;
        }
    }

    public SearchResult<ForpostCameraBrand> forpostCameraBrandSearch(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setSort(sort);
        try (ForpostCameraBrandDao forpostCameraBrandDao = new ForpostCameraBrandDao(this.getConnection(), this.moduleId);){
            forpostCameraBrandDao.searchForpostCameraBrands((SearchResult<ForpostCameraBrand>)searchResult);
        }
        return searchResult;
    }

    public void forpostCameraBrandSync() throws BGException {
        try (ForpostCameraBrandDao forpostCameraBrandDao = new ForpostCameraBrandDao(this.getConnection(), this.moduleId);){
            forpostCameraBrandDao.doSync(new ForpostManager(this.moduleId).getCameraBrands());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ForpostCameraBrand> forpostCameraBrandList() throws BGException {
        try (ForpostCameraBrandDao forpostCameraBrandDao = new ForpostCameraBrandDao(this.getConnection(), this.moduleId);){
            List<ForpostCameraBrand> list = forpostCameraBrandDao.list();
            return list;
        }
    }

    public SearchResult<ForpostCameraModel> forpostCameraModelSearch(int brandId, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        try (ForpostCameraModelDao forpostCameraModelDao = new ForpostCameraModelDao(this.getConnection(), this.moduleId);){
            forpostCameraModelDao.searchForpostCameraModels((SearchResult<ForpostCameraModel>)searchResult, brandId);
        }
        return searchResult;
    }

    public void forpostCameraModelSync() throws BGException {
        try (ForpostCameraModelDao forpostCameraModelDao = new ForpostCameraModelDao(this.getConnection(), this.moduleId);
             ForpostCameraBrandDao forpostCameraBrandDao = new ForpostCameraBrandDao(this.getConnection(), this.moduleId);){
            ResponseCameraModelsAndBrands cameraModelsAndBrands = new ForpostManager(this.moduleId).getCameraModelsAndBrands();
            forpostCameraBrandDao.doSync(cameraModelsAndBrands.getBrands());
            forpostCameraModelDao.doSync(cameraModelsAndBrands.getModels());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ForpostCameraModel> forpostCameraModelList() throws BGException {
        try (ForpostCameraModelDao forpostCameraModelDao = new ForpostCameraModelDao(this.getConnection(), this.moduleId);){
            List<ForpostCameraModel> list;
            try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
                Map<Integer, Integer> cameraModelStats = forpostCameraDao.getForpostCameraModelStat();
                List<ForpostCameraModel> cameraModels = forpostCameraModelDao.list();
                cameraModels.forEach(e -> e.setUseCount(cameraModelStats.getOrDefault(e.getId(), 0).intValue()));
                list = cameraModels;
            }
            return list;
        }
    }

    public ForpostCameraModel forpostCameraModelGet(int id) throws BGException {
        try (ForpostCameraModelDao forpostCameraModelDao = new ForpostCameraModelDao(this.getConnection(), this.moduleId);){
            ForpostCameraModel forpostCameraModel = (ForpostCameraModel)forpostCameraModelDao.get(id);
            return forpostCameraModel;
        }
    }

    public SearchResult<ForpostCameraType> forpostCameraTypeSearch(String[] sort, Page page) throws BGException {
        return null;
    }

    public void forpostCameraTypeSync() throws BGException {
    }

    public List<ForpostCameraType> forpostCameraTypelList() throws BGException {
        return null;
    }

    public ForpostCameraType forpostCameraTypeGet(int id) throws BGException {
        return null;
    }

    public SearchResult<ForpostTMCAO<ForpostUser>> forpostUsersSearch(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            forpostUserDao.searchForpostUsers((SearchResult<ForpostTMCAO<ForpostUser>>)searchResult);
        }
        return searchResult;
    }

    public SearchResult<ForpostUser> forpostAccountUserSearch(int accountId) throws BGException {
        SearchResult searchResult = new SearchResult();
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            forpostUserDao.searchForpostAccountUsers((SearchResult<ForpostUser>)searchResult, accountId);
        }
        return searchResult;
    }

    public void forpostUserSync() throws BGException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            for (int accountId : forpostAccountDao.getIds()) {
                forpostUserDao.doSync(accountId, forpostManager.getAccountUsers(accountId, 0));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void forpostUsersSync(int accountId) throws BGException {
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            forpostUserDao.doSync(accountId, new ForpostManager(this.moduleId).getAccountUsers(accountId, 0));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostUser forpostUserDefaultGet() throws BGException {
        ForpostUser forpostUser = new ForpostUser();
        return forpostUser;
    }

    public int forpostUserAdd(ForpostUser forpostUser) throws BGException, BGMessageException {
        int n;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Login", forpostUser.getLogin());
        params.put("AccountID", String.valueOf(forpostUser.getAccountId()));
        params.put("Password", forpostUser.getPassword());
        params.put("Email", String.valueOf(forpostUser.get("Email")));
        ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);
        try {
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseId responseId = forpostManager.addUser(params);
            if (responseId.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
            }
            int userId = responseId.getId();
            forpostUser.setId(userId);
            forpostUserDao.update(forpostUser);
            forpostUserDao.doSync(forpostUser.getAccountId(), forpostManager.getAccountUsers(forpostUser.getAccountId(), 0));
            n = userId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    forpostUserDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        forpostUserDao.close();
        return n;
    }

    public void forpostUserUpdate(ForpostUser forpostUser) throws BGException, BGMessageException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(forpostUser.getId()));
        ForpostUtils.putParams(params, (String)"Login", (String)forpostUser.getLogin());
        ForpostUtils.putParams(params, (String)"Password", (String)forpostUser.getPassword());
        ForpostUtils.putParams(params, (String)"Email", (String)forpostUser.getString("Email"));
        ForpostUtils.putParams(params, (String)"Phone", (String)forpostUser.getString("Phone"));
        ForpostUtils.putParams(params, (String)"FIO", (String)forpostUser.getString("FIO"));
        ForpostUtils.putParams(params, (String)"IsReadOnly", (String)forpostUser.getString("IsReadOnly"));
        ForpostUtils.putParams(params, (String)"CanChangeOwnInfo", (String)forpostUser.getString("CanChangeOwnInfo"));
        ForpostUtils.putParams(params, (String)"ChangePasswordAtNextLogin", (String)forpostUser.getString("ChangePasswordAtNextLogin"));
        ForpostUtils.putParams(params, (String)"AuthProviderID", (String)forpostUser.getString("AuthProviderID"));
        ForpostUtils.putParams(params, (String)"IsActive", (String)String.valueOf(forpostUser.getIsActive()));
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editUser(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostUserDao.update(forpostUser);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostUserParamUpdate(int forpostUserId, String name, String value) throws BGException, BGMessageException {
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostUser forpostUser = forpostUserDao.getForpostUser(forpostUserId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ID", String.valueOf(forpostUser.getId()));
            params.put(name, value);
            switch (name) {
                case "Login": {
                    forpostUser.setLogin(value);
                    break;
                }
                case "Password": {
                    forpostUser.setPassword(value);
                    break;
                }
                case "IsActive": {
                    forpostUser.setIsActive(Utils.parseInt((String)value));
                    break;
                }
                default: {
                    forpostUser.put(name, (Object)value);
                }
            }
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editUser(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostUserDao.update(forpostUser);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostUserDelete(int id) throws BGException {
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseStatus responseStatus = forpostManager.deleteUser(id);
            if (responseStatus.getErrorCode() > 0) {
                if (responseStatus.getErrorCode() == 1) {
                    // empty if block
                }
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
            }
            forpostUserDao.deleteForpostUser(id);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void forpostAccountUsersDelete(int accountId) throws BGException, BGMessageException {
        try (ForpostUserDao forpostUserDao = new ForpostUserDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            SearchResult searchResult = new SearchResult();
            forpostUserDao.searchForpostAccountUsers((SearchResult<ForpostUser>)searchResult, accountId);
            for (ForpostUser forpostUser : searchResult.getList()) {
                ResponseStatus responseStatus = forpostManager.deleteUser(forpostUser.getId());
                if (responseStatus.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
                }
                forpostUserDao.deleteForpostUser(forpostUser.getId());
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<KeyValue> forpostCameraList() throws BGException {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        list.add(new KeyValue("0", "\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430"));
        try {
            ServerContext serverContext = (ServerContext)ServerContext.get();
            Directory directory = serverContext.getDirectory(ForpostCameraBrand.class, this.moduleId);
            List cameraModels = ((ForpostService)serverContext.getService(ForpostService.class, this.moduleId)).forpostCameraModelList();
            Iterator iterator = cameraModels.iterator();
            while (iterator.hasNext()) {
                ForpostCameraModel cameraModel;
                ForpostCameraBrand cameraBrand = (ForpostCameraBrand)directory.get((cameraModel = (ForpostCameraModel)iterator.next()).getBrandId());
                cameraModel.setName((String)(cameraBrand != null ? cameraBrand.getName() + " " : "") + cameraModel.getName() + (String)(cameraModel.getUseCount() > 0 ? " [" + cameraModel.getUseCount() + "]" : ""));
            }
            cameraModels.sort(new Comparator<ForpostCameraModel>(){

                @Override
                public int compare(ForpostCameraModel o1, ForpostCameraModel o2) {
                    int result = o2.getUseCount() - o1.getUseCount();
                    if (result == 0) {
                        result = o1.getName().compareTo(o2.getName());
                    }
                    return result;
                }
            });
            cameraModels.forEach(i -> list.add(new KeyValue(String.valueOf(i.getId()), i.getName())));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return list;
    }

    public SearchResult<ForpostTMCAO<ForpostObject>> forpostObjectSearch(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            forpostObjectDao.searchForpostObjects((SearchResult<ForpostTMCAO<ForpostObject>>)searchResult);
        }
        return searchResult;
    }

    public SearchResult<ForpostObject> forpostAccountObjectSearch(int accountId) throws BGException {
        SearchResult searchResult = new SearchResult();
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            forpostObjectDao.searchForpostAccountObjects((SearchResult<ForpostObject>)searchResult, accountId);
        }
        return searchResult;
    }

    public void forpostObjectSync() throws BGException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            for (int accountId : forpostAccountDao.getIds()) {
                forpostObjectDao.doSync(accountId, forpostManager.getObjects(accountId, 0));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void forpostObjectsSync(int accountId) throws BGException {
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            forpostObjectDao.doSync(accountId, new ForpostManager(this.moduleId).getObjects(accountId, 0));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostObject forpostObjectDefaultGet() throws BGException {
        ForpostObject forpostObject = new ForpostObject();
        return forpostObject;
    }

    public int forpostObjectAdd(ForpostObject forpostObject) throws BGException, BGMessageException {
        int n;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Name", forpostObject.getName());
        params.put("AccountID", String.valueOf(forpostObject.getAccountId()));
        if (Utils.notBlankString((String)forpostObject.getAddress())) {
            params.put("Address", forpostObject.getAddress());
        }
        ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);
        try {
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseId responseId = forpostManager.addObject(params);
            if (responseId.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
            }
            int objectId = responseId.getId();
            forpostObject.setId(objectId);
            forpostObjectDao.update(forpostObject);
            forpostObjectDao.doSync(forpostObject.getAccountId(), new ForpostManager(this.moduleId).getObjects(forpostObject.getAccountId(), 0));
            n = objectId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    forpostObjectDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        forpostObjectDao.close();
        return n;
    }

    public void forpostObjectUpdate(ForpostObject forpostObject) throws BGException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(forpostObject.getId()));
        ForpostUtils.putParams(params, (String)"Name", (String)forpostObject.getName());
        ForpostUtils.putParams(params, (String)"Address", (String)forpostObject.getAddress());
        ForpostUtils.putParams(params, (String)"Lat", (String)forpostObject.getString("Lat"));
        ForpostUtils.putParams(params, (String)"Lon", (String)forpostObject.getString("Lon"));
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editObject(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostObjectDao.update(forpostObject);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostObjectParamUpdate(int forpostObjectId, String name, String value) throws BGException, BGMessageException {
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostObject forpostObject = forpostObjectDao.getForpostObject(forpostObjectId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ID", String.valueOf(forpostObject.getId()));
            params.put(name, value);
            switch (name) {
                case "Name": {
                    forpostObject.setName(value);
                    break;
                }
                case "Address": {
                    forpostObject.setAddress(value);
                    break;
                }
                default: {
                    forpostObject.put(name, (Object)value);
                }
            }
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editObject(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostObjectDao.update(forpostObject);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void forpostObjectDelete(int id) throws BGException {
        try (ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseStatus responseStatus = forpostManager.deleteObject(id);
            if (responseStatus.getErrorCode() > 0) {
                if (responseStatus.getErrorCode() == 1) {
                    forpostObjectDao.deleteForpostObject(id);
                }
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
            }
            forpostObjectDao.deleteForpostObject(id);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void forpostAccountObjectDelete(int accountId) throws BGException, BGMessageException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostObjectDao forpostObjectDao = new ForpostObjectDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            SearchResult searchResult = new SearchResult();
            forpostObjectDao.searchForpostAccountObjects((SearchResult<ForpostObject>)searchResult, accountId);
            for (ForpostObject forpostObject : searchResult.getList()) {
                ResponseStatus responseStatus = forpostManager.deleteObject(forpostObject.getId());
                if (responseStatus.getErrorCode() > 0) {
                    if (responseStatus.getErrorCode() == 1) {
                        forpostObjectDao.deleteForpostObject(forpostObject.getId());
                    }
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
                }
                forpostObjectDao.deleteForpostObject(forpostObject.getId());
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

