/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.subscription.common.bean.Subscription;
import ru.bitel.bgbilling.modules.subscription.server.bean.CostSumTime;
import ru.bitel.bgbilling.modules.subscription.server.event.SubscriptionUpdateEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.PeriodWithTime;

public class SubscriptionDao
extends AbstractIdDao<Subscription> {
    private static final String SUBSCRIPTION_TABLE = "subscription";
    private static String SUBSCRIPTION_DETAIL_TABLE;
    protected final int userId;

    public SubscriptionDao(Connection con, int moduleId, int userId) {
        super(con, moduleId, SUBSCRIPTION_TABLE);
        SUBSCRIPTION_DETAIL_TABLE = this.getTableName("subscription_detail", moduleId, new Date());
        this.userId = userId;
    }

    protected Subscription getFromRS(ResultSet rs) throws SQLException, BGException {
        Subscription result = new Subscription();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("contract_id"));
        result.setTypeId(rs.getInt("type_id"));
        result.setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        result.setRegistrationPeriodId(rs.getInt("registration_period_id"));
        result.setAvtoCommit(rs.getBoolean("avto_commit"));
        result.setJobId(rs.getLong("job_id"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    protected void updateImpl(Subscription subscription) throws BGException, SQLException {
        PreparedStatement ps = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" SET ");
        buf.append("contract_id=?, type_id=?, date_from=?, date_to=?, avto_commit=?, comment=?");
        boolean isUpdated = false;
        if (subscription.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + buf.toString(), 1);
        } else {
            isUpdated = true;
            ps = this.con.prepareStatement("UPDATE " + this.tableName + buf.toString() + " WHERE id=?");
        }
        int index = 1;
        ps.setInt(index++, subscription.getContractId());
        ps.setInt(index++, subscription.getTypeId());
        PeriodWithTime period = subscription.getPeriod();
        ps.setTimestamp(index++, period != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()) : null);
        ps.setTimestamp(index++, period != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateTo()) : null);
        ps.setBoolean(index++, subscription.isAvtoCommit());
        ps.setString(index++, subscription.getComment());
        if (subscription.getId() > 0) {
            ps.setInt(index++, subscription.getId());
        }
        ps.executeUpdate();
        if (subscription.getId() < 1) {
            subscription.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
        this.con.commit();
        EventProcessor.getInstance().publish((Event)new SubscriptionUpdateEvent(this.moduleId, subscription.getContractId(), this.userId, subscription.getId(), isUpdated));
    }

    public void updateRegistrationPeriodId(int subscriptionId, int registrationPeriodId) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(this.tableName);
            query.append(" SET ");
            query.append("registration_period_id=?");
            query.append(" WHERE ");
            query.append("id=?");
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, registrationPeriodId);
            ps.setInt(index++, subscriptionId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    public void updateSubscriptionJobId(int subscriptionId, long subscriptionJobId) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(this.tableName);
            query.append(" SET ");
            query.append("job_id=?");
            query.append(" WHERE ");
            query.append("id=?");
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setLong(index++, subscriptionJobId);
            ps.setInt(index++, subscriptionId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    public List<Subscription> list(int contractId) throws BGException {
        return super.list("contract_id=?", "id", new Object[]{contractId});
    }

    public void addDetail(CostSumTime costSumTime, int registrationPeriodId) throws BGException {
        String detailTableCreateQuery = "CREATE TABLE " + SUBSCRIPTION_DETAIL_TABLE + "( `id` INT  NOT NULL AUTO_INCREMENT, `cid` INT NOT NULL,`sid` INT NOT NULL,`sum` DECIMAL(10,2) NULL,`datetime` DATETIME NULL,`registration_period_id` INT NOT NULL,PRIMARY KEY (`id`),KEY `dt` (`datetime`) )";
        Setup.getSetup().checkAndCreatePeriodicTableName(this.con, SUBSCRIPTION_DETAIL_TABLE, detailTableCreateQuery);
        String query = "INSERT INTO " + SUBSCRIPTION_DETAIL_TABLE + " SET cid=?, sid=?, sum=?, datetime=?, registration_period_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, costSumTime.contractId);
            ps.setInt(index++, costSumTime.serviceId);
            ps.setBigDecimal(index++, costSumTime.cost);
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)costSumTime.getDateTime()));
            ps.setInt(index++, registrationPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    public List<CostSumTime> getAmountDetail(int contractId, PeriodWithTime period) throws BGException {
        ArrayList<CostSumTime> result = new ArrayList<CostSumTime>();
        String tableName1 = this.getTableName("subscription_detail", this.moduleId, period.getDateFrom() != null ? period.getDateFrom() : new Date());
        String tableName2 = this.getTableName("subscription_detail", this.moduleId, period.getDateTo() != null ? period.getDateTo() : new Date());
        StringBuilder query = null;
        if (!tableName1.equals(tableName2) && ServerUtils.tableExists((Connection)this.con, (String)tableName1) && ServerUtils.tableExists((Connection)this.con, (String)tableName2)) {
            query = new StringBuilder("SELECT * FROM " + tableName1 + " WHERE cid=?");
            if (period.getDateFrom() != null) {
                query.append(" AND datetime>=?");
            }
            query.append(" UNION ");
            query.append("SELECT * FROM " + tableName2 + " WHERE cid=?");
            if (period.getDateTo() != null) {
                query.append(" AND datetime<=?");
            }
        } else if (ServerUtils.tableExists((Connection)this.con, (String)tableName1)) {
            query = new StringBuilder("SELECT * FROM " + tableName1 + " WHERE cid=?");
            if (period.getDateFrom() != null) {
                query.append(" AND datetime>=?");
            }
            if (period.getDateTo() != null) {
                query.append(" AND datetime<=?");
            }
        }
        query.append(" ORDER BY datetime");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            if (!tableName1.equals(tableName2) && ServerUtils.tableExists((Connection)this.con, (String)tableName1) && ServerUtils.tableExists((Connection)this.con, (String)tableName2)) {
                ps.setInt(index++, contractId);
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                ps.setInt(index++, contractId);
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                }
            } else if (ServerUtils.tableExists((Connection)this.con, (String)tableName1)) {
                ps.setInt(index++, contractId);
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new CostSumTime(rs.getInt("id"), rs.getInt("cid"), rs.getInt("sid"), rs.getBigDecimal("sum"), TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("datetime"))));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

