/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.client;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.tinkoff.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.tinkoff.common.service.TinkoffService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    private TinkoffService tinkoffService = null;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            String contractTitle = TransactionPanel.this.contractTitleField.getText();
            AbstractTransactionStatus status = (AbstractTransactionStatus)TransactionPanel.this.statusComboBox.getSelectedItem();
            SearchResult searchResult = TransactionPanel.this.getTinkoffService().searchTransactionList(TransactionPanel.this.getContractId(), contractTitle, status.getCode(), TransactionPanel.this.periodPanel.getPeriod(), TransactionPanel.this.getTable().getSort(), TransactionPanel.this.pagePanel.getPage());
            ((TransactionTableModel)TransactionPanel.this.transactionModel).setData(searchResult.getList());
            TransactionPanel.this.pagePanel.setPage(searchResult.getPage());
            TransactionPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            TransactionPanel.this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        }
    };

    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected TinkoffService getTinkoffService() {
        if (this.tinkoffService == null) {
            this.tinkoffService = (TinkoffService)((ClientContext)this.getContext()).getPort(TinkoffService.class);
        }
        return this.tinkoffService;
    }

    protected BGButton getCheckButton() {
        BGButton button = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c...");
        button.setToolTipText("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0432\u0441\u0435\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0445 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    TransactionPanel.this.getTinkoffService().checkTransactions(TransactionPanel.this.getContractId());
                    TransactionPanel.this.performAction("refresh");
                }
                catch (BGException ex) {
                    ex.printStackTrace();
                }
            }
        });
        return button;
    }

    protected JMenuItem getTransactionDataMenuItem() {
        return new JMenuItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedTransaction = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedTransaction != null && selectedTransaction instanceof Transaction) {
                        Transaction transaction = (Transaction)selectedTransaction;
                        JTextArea textArea = new JTextArea(transaction.getParameters(), 20, 50);
                        textArea.setMargin(new Insets(5, 5, 5, 5));
                        textArea.setEditable(false);
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), new JScrollPane(textArea), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", 1);
                    }
                });
            }
        };
    }

    protected JMenuItem getCancelMenuItem() {
        return new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Transaction transaction;
                    Object selectedPayment = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedPayment != null && selectedPayment instanceof Transaction && (transaction = (Transaction)selectedPayment).getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                        try {
                            TransactionPanel.this.getTinkoffService().cancelTarnsaction(transaction.getId());
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                });
            }
        };
    }
}

