/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.common.IntTextField;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoType;
import ru.bitel.bgbilling.modules.trayinfo.common.service.TrayInfoService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class TrayInfoTypeManager
extends BGUPanel {
    private JPanel editorPanel = new JPanel();
    private JTextField title_TF = new JTextField();
    private FloatTextField cost_TF = new FloatTextField();
    private BGUComboBox<IdTitle> chargeType_CB = new BGUComboBox();
    private BGUTable table;
    private BGTableModel<TrayInfoType> model;
    private BGControlPanelPeriodNoB periodEdit_P = new BGControlPanelPeriodNoB();
    private IntTextField days_TF = new IntTextField();
    private BGComboBox<ComboBoxItem> timeCombo = new BGComboBox();
    private JPanel timePanel = new JPanel(new GridBagLayout());
    protected TrayInfoType current;

    public TrayInfoTypeManager() {
        this.build();
    }

    protected void jbInit() {
        this.model = new BGTableModel<TrayInfoType>("trayInfoType"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, -1, -1, "title", true);
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, -1, -1, "period", true);
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, -1, -1, "cost", true);
            }

            public Object getValue(TrayInfoType val, int column) throws BGException {
                if (column == 2) {
                    return TimeUtils.formatPeriod((Date)val.getDate1(), (Date)val.getDate2());
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.setLayout(new GridBagLayout());
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editorPanel.setLayout(new GridBagLayout());
        this.title_TF.setMinimumSize(new Dimension(100, 24));
        this.title_TF.setPreferredSize(new Dimension(100, 24));
        this.title_TF.setEditable(true);
        this.title_TF.setText("");
        this.cost_TF.setMinimumSize(new Dimension(100, 24));
        this.cost_TF.setPreferredSize(new Dimension(100, 24));
        this.cost_TF.setText("");
        BGButtonPanelOkCancel bGControlPanel_021 = new BGButtonPanelOkCancel();
        bGControlPanel_021.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("ok".equals(e.getActionCommand())) {
                    try {
                        TrayInfoTypeManager.this.stopEdit();
                    }
                    catch (BGException e1) {
                        e1.printStackTrace();
                    }
                } else if ("cancel".equals(e.getActionCommand())) {
                    TrayInfoTypeManager.this.editorPanel.setVisible(false);
                }
            }
        });
        this.days_TF.setMinimumSize(new Dimension(20, 24));
        this.days_TF.setPreferredSize(new Dimension(20, 24));
        this.days_TF.setText("intTextField1");
        this.timeCombo.addItem((Object)new ComboBoxItem(0, "\u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e"));
        this.timeCombo.addItem((Object)new ComboBoxItem(1, "\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e"));
        this.timeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGSwingUtilites.setEnabled((Component)TrayInfoTypeManager.this.timePanel, (boolean)"1".equals(TrayInfoTypeManager.this.timeCombo.getSelectedId()));
            }
        });
        BGSwingUtilites.setEnabled((Component)this.timePanel, (boolean)"1".equals(this.timeCombo.getSelectedId()));
        this.add(this.editorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(-5, 0, 5, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, -6, 0, 11), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.title_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)bGControlPanel_021, new GridBagConstraints(1, 2, 7, 1, 1.0, 0.0, 13, 2, new Insets(15, 0, 5, 5), 0, 0));
        this.editorPanel.add((Component)this.periodEdit_P, new GridBagConstraints(2, 0, 6, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.chargeType_CB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.cost_TF, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f:"), new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.timeCombo, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.timePanel, new GridBagConstraints(6, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.timePanel.add((Component)this.days_TF, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.timePanel.add((Component)new JLabel("\u0434\u043d\u0435\u0439"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        ClientUtils.addOpenAction((Component)this.table, (AWTEventListener)new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                TrayInfoTypeManager.this.performAction("edit");
            }
        });
        this.fillChargesList();
    }

    private void fillChargesList() {
        try {
            List charges = ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).getChargesList();
            this.chargeType_CB.setData(charges);
        }
        catch (BGException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0442\u0438\u043f\u043e\u0432 \u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432");
        }
    }

    private void stopEdit() throws BGException {
        Date date1 = this.periodEdit_P.getDateFrom();
        Date date2 = this.periodEdit_P.getDateTo();
        if (date1 == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
            return;
        }
        this.current.setDate1(date1);
        this.current.setDate2(date2);
        this.current.setDays(this.timeCombo.getSelectedId().equals("0") ? 0 : Integer.valueOf(this.days_TF.getText()));
        this.current.setTitle(this.title_TF.getText());
        this.current.setCost(new BigDecimal(this.cost_TF.getText()));
        this.current.setChargeType(((IdTitle)this.chargeType_CB.getSelectedItem()).getId());
        ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).updateLoginType(this.current);
        this.editorPanel.setVisible(false);
        this.performAction("refresh");
    }

    private void startEdit() throws BGException {
        if (this.current.getId() > 0) {
            this.current = ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).getLoginType(this.current.getId());
            this.title_TF.setText(this.current.getTitle());
            this.cost_TF.setText(this.current.getCost().toPlainString());
            this.periodEdit_P.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)this.current.getDate1()));
            this.periodEdit_P.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)this.current.getDate2()));
            int days = this.current.getDays();
            this.timeCombo.setSelectedId(days == 0 ? "0" : "1");
            this.days_TF.setText(String.valueOf(days));
            this.chargeType_CB.setSelectedItem((Object)this.current.getChargeType());
        } else {
            this.title_TF.setText("");
            this.cost_TF.setText("0.00");
            this.periodEdit_P.setDateCalendar1(null);
            this.periodEdit_P.setDateCalendar2(null);
            this.days_TF.setText("0");
        }
        BGSwingUtilites.setEnabled((Component)this.timePanel, (boolean)"1".equals(this.timeCombo.getSelectedId()));
        this.editorPanel.setVisible(true);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TrayInfoTypeManager.this.editorPanel.setVisible(false);
                List logins = ((TrayInfoService)((ClientContext)TrayInfoTypeManager.this.getContext()).getPort(TrayInfoService.class)).getLoginTypes();
                TrayInfoTypeManager.this.model.setData(logins);
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TrayInfoType current = (TrayInfoType)TrayInfoTypeManager.this.model.getSelectedRow();
                if (current != null && ClientUtils.confirmDelete((Object)("\u0442\u0438\u043f \u043b\u043e\u0433\u0438\u043d\u0430: " + current.getTitle()))) {
                    ((TrayInfoService)((ClientContext)TrayInfoTypeManager.this.getContext()).getPort(TrayInfoService.class)).deleteLoginType(current.getId());
                    TrayInfoTypeManager.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TrayInfoTypeManager.this.current = (TrayInfoType)TrayInfoTypeManager.this.model.getSelectedRow();
                if (TrayInfoTypeManager.this.current != null) {
                    TrayInfoTypeManager.this.startEdit();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TrayInfoTypeManager.this.current = new TrayInfoType();
                if (TrayInfoTypeManager.this.current != null) {
                    TrayInfoTypeManager.this.startEdit();
                }
            }
        };
    }
}

