/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import ru.bitel.common.Utils;
import ru.bitel.common.model.AbstractTreeNode;
import ru.bitel.common.model.TreeNode;

public class TvAccount
extends AbstractTreeNode<TvAccount>
implements TreeNode<TvAccount>,
Cloneable {
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_CLOSED = 1;
    public static final int STATUS_LOCKED = 2;
    public static final short STATE_NULL = -1000;
    public static final short STATE_DELETED = -1;
    public static final short STATE_DISABLE = 0;
    public static final short STATE_ENABLE = 1;
    private int contractId;
    private String contractTitle;
    private String contractComment;
    private int specId;
    private String specTitle;
    private String login;
    private String password;
    private String pin;
    private int deviceId;
    private String deviceTitle;
    private int interfaceId = -1;
    private String interfaceTitle;
    private int vlan = -1;
    private String identifier;
    private List<byte[]> macAddressList;
    private Date dateFrom;
    private Date dateTo;
    private int status;
    private String comment;
    private volatile String deviceAccountId;
    private volatile short deviceState;
    private volatile Set<Integer> deviceOptionIds;
    private String accessCodeTitle;
    private int accessCode;
    private String config;
    private static final Pattern macClearPattern = Pattern.compile("[\\s\\.:\\-]+");

    @XmlAttribute(name="cid")
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute
    public String getContractTitle() {
        return this.contractTitle;
    }

    public void setContractTitle(String contractTitle) {
        this.contractTitle = contractTitle;
    }

    @XmlAttribute
    public String getContractComment() {
        return this.contractComment;
    }

    public void setContractComment(String contractComment) {
        this.contractComment = contractComment;
    }

    @XmlAttribute(name="specId")
    public int getSpecId() {
        return this.specId;
    }

    public void setSpecId(int specId) {
        this.specId = specId;
    }

    @XmlAttribute
    public String getSpecTitle() {
        return this.specTitle;
    }

    public void setSpecTitle(String servTypeTitle) {
        this.specTitle = servTypeTitle;
    }

    @XmlAttribute(name="did")
    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    @XmlAttribute
    public String getDeviceTitle() {
        return this.deviceTitle;
    }

    public void setDeviceTitle(String deviceTitle) {
        this.deviceTitle = deviceTitle;
    }

    @XmlAttribute(name="ifaceId")
    public int getInterfaceId() {
        return this.interfaceId;
    }

    public void setInterfaceId(int portId) {
        this.interfaceId = portId;
    }

    @XmlAttribute
    public String getInterfaceTitle() {
        return this.interfaceTitle;
    }

    public void setInterfaceTitle(String interfaceTitle) {
        this.interfaceTitle = interfaceTitle;
    }

    @XmlAttribute
    public int getVlan() {
        return this.vlan;
    }

    public void setVlan(int vlanId) {
        this.vlan = vlanId;
    }

    @XmlAttribute
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @XmlElementWrapper(name="macList")
    @XmlElements(value={@XmlElement(name="mac")})
    public List<byte[]> getMacAddressList() {
        return this.macAddressList;
    }

    public void setMacAddressList(List<byte[]> macAddress) {
        this.macAddressList = macAddress;
    }

    @XmlTransient
    public byte[] getMacAddressListBytes() {
        if (this.macAddressList == null) {
            return null;
        }
        int size = this.macAddressList.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.macAddressList.get(0);
            }
        }
        int length = this.macAddressList.get(0).length;
        byte[] result = new byte[length * size];
        for (int i = 0; i < size; ++i) {
            byte[] mac = this.macAddressList.get(i);
            System.arraycopy(mac, 0, result, i * length, length);
        }
        return result;
    }

    public void setMacAddressListBytes(byte[] macAddressListBytes) {
        if (macAddressListBytes == null) {
            this.setMacAddressList(Collections.emptyList());
            return;
        }
        if (macAddressListBytes.length <= 8) {
            this.setMacAddressList(Collections.singletonList(macAddressListBytes));
            return;
        }
        if (macAddressListBytes.length % 6 == 0) {
            int size = macAddressListBytes.length / 6;
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                byte[] mac = new byte[6];
                System.arraycopy(macAddressListBytes, i * 6, mac, 0, 6);
                macAddressList.add(mac);
            }
            this.setMacAddressList(macAddressList);
            return;
        }
        if (macAddressListBytes.length % 8 == 0) {
            int size = macAddressListBytes.length / 8;
            ArrayList<byte[]> macAddressList = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                byte[] mac = new byte[8];
                System.arraycopy(macAddressListBytes, i * 8, mac, 0, 8);
                macAddressList.add(mac);
            }
            this.setMacAddressList(macAddressList);
            return;
        }
        this.setMacAddressList(Collections.singletonList(macAddressListBytes));
    }

    @XmlAttribute(name="uname")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @XmlAttribute(name="pin")
    public String getPin() {
        return this.pin;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    @XmlAttribute(name="pswd")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    @XmlAttribute
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @XmlAttribute(name="devAccountId")
    public String getDeviceAccountId() {
        return this.deviceAccountId;
    }

    public void setDeviceAccountId(String deviceAccountId) {
        this.deviceAccountId = deviceAccountId;
    }

    @XmlAttribute(name="devState")
    public short getDeviceState() {
        return this.deviceState;
    }

    public void setDeviceState(short currentState) {
        this.deviceState = currentState;
    }

    public String getAccessCodeTitle() {
        return this.accessCodeTitle;
    }

    public void setAccessCodeTitle(String deviceStateTitle) {
        this.accessCodeTitle = deviceStateTitle;
    }

    @XmlAttribute(name="devOptions")
    public Set<Integer> getDeviceOptionIds() {
        return this.deviceOptionIds;
    }

    public void setDeviceOptionIds(Set<Integer> deviceServiceIds) {
        this.deviceOptionIds = deviceServiceIds;
    }

    @XmlAttribute
    public int getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(int accessCode) {
        this.accessCode = accessCode;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public TvAccount clone() {
        try {
            return (TvAccount)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return this.title != null ? this.title : String.valueOf(this.id);
    }

    public static String toString(TvAccount val) {
        StringBuilder data = new StringBuilder();
        if (Utils.notBlankString((String)val.getLogin())) {
            data.append("\u041b\u043e\u0433\u0438\u043d: ");
            data.append(val.getLogin());
        }
        if (Utils.notBlankString((String)val.getInterfaceTitle())) {
            if (data.length() > 0) {
                data.append("; ");
            }
            data.append("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441: ");
            data.append(val.getInterfaceTitle());
        }
        return data.toString();
    }

    public static byte[] parseMacAddress(String macAddress) {
        if (Utils.isBlankString((String)macAddress)) {
            return null;
        }
        macAddress = macClearPattern.matcher(macAddress).replaceAll("");
        return TvAccount.toBytes(macAddress);
    }

    public static String macAddressToString(byte[] macAddress) {
        if (macAddress == null || macAddress.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(macAddress.length * 3);
        int size = macAddress.length;
        for (int i = 0; i < size; ++i) {
            sb.append(Utils.HEX[(macAddress[i] & 0xF0) >> 4]);
            sb.append(Utils.HEX[macAddress[i] & 0xF]);
            sb.append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static byte[] toBytes(String s) {
        byte[] result;
        int i;
        int j;
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        if (size % 2 == 0) {
            j = 0;
            i = 0;
            result = new byte[size / 2];
        } else {
            j = 1;
            i = 1;
            result = new byte[size / 2 + 1];
            int digit2 = Character.digit(s.charAt(0), 16);
            result[0] = (byte)digit2;
        }
        while (i < size) {
            int digit1 = Character.digit(s.charAt(i++), 16);
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }
}

