/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vepay.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.vepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vepay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.vepay.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.vepay.server.bean.Constants;
import ru.bitel.bgbilling.modules.vepay.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.vepay.server.event.VepaySumEvent;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Vepay")
public class ActionDoTransaction
extends AbstractAction {
    private static final Logger logger = LogManager.getLogger();
    private final String moduleName = "vepay";

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        boolean fiscalization = this.moduleSetup.getBoolean("vepay.fiscalization.enable", false);
        String gateUrl = fiscalization ? this.moduleSetup.get("vepay.fiscalization.url.gate", "https://fpay.vepay.ru/v2/") : this.moduleSetup.get("vepay.url.gate", "https://test.vepay.online");
        this.setResultParam("gateUrl", gateUrl + "pay");
        this.paymentForm("vepay", Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction(searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws BGException {
        this.execute();
    }

    public void fail() throws BGException {
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        if (this.context.getRequest().getParameter("contentType") == null) {
            this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.json);
        }
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        VepaySumEvent event = new VepaySumEvent(this.moduleId, this.contractId, sum);
        BigDecimal newSum = ((VepaySumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
        if (newSum != null) {
            sum = newSum;
        }
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("vepay.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("vepay.sum.max", new BigDecimal(5000));
        ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        this.doRedirect(sum, 0);
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        int mode;
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        boolean autopaymentEnable = this.moduleSetup.getBoolean("vepay.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = new Autopayment();
                autopayment.setContractId(this.contractId);
                autopayment.setModeData("");
            }
            TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                int autopaymentWeekDay = this.moduleSetup.getInt("vepay.autopayment.mode.week.day.default", 1);
                modeDataMap.set("autopayment.mode.week.day", String.valueOf(this.req.getInt("dayOfWeek", autopaymentWeekDay)));
                BigDecimal autopaymentWeekSum = this.moduleSetup.getBigDecimal("vepay.autopayment.mode.week.sum.default", new BigDecimal(50));
                autopaymentWeekSum = this.req.getBigDecimal("weekSum", autopaymentWeekSum);
                modeDataMap.set("autopayment.mode.week.sum", String.valueOf(autopaymentWeekSum));
                autopayment.setSum(autopaymentWeekSum);
                autopayment.setMode(AutopaymentMode.WEEK);
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                int autopaymentMonthDay = this.moduleSetup.getInt("vepay.autopayment.mode.month.day.default", 1);
                modeDataMap.set("autopayment.mode.month.day", String.valueOf(this.req.getInt("dayOfMonth", autopaymentMonthDay)));
                BigDecimal autopaymentMonthSum = this.moduleSetup.getBigDecimal("vepay.autopayment.mode.month.sum.default", new BigDecimal(50));
                autopaymentMonthSum = this.req.getBigDecimal("monthSum", autopaymentMonthSum);
                modeDataMap.set("autopayment.mode.month.sum", String.valueOf(autopaymentMonthSum));
                autopayment.setSum(autopaymentMonthSum);
                autopayment.setMode(AutopaymentMode.MONTH);
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                BigDecimal autopaymentAutoMaxDaySum = this.moduleSetup.getBigDecimal("vepay.autopayment.mode.auto.day.sum.default", new BigDecimal(500));
                autopaymentAutoMaxDaySum = this.req.getBigDecimal("maxDaySum", autopaymentAutoMaxDaySum);
                modeDataMap.set("autopayment.mode.auto.day.sum", String.valueOf(autopaymentAutoMaxDaySum));
                BigDecimal autopaymentAutoMaxWeekSum = this.moduleSetup.getBigDecimal("vepay.autopayment.mode.auto.week.sum.default", new BigDecimal(1000));
                autopaymentAutoMaxWeekSum = this.req.getBigDecimal("maxWeekSum", autopaymentAutoMaxWeekSum);
                modeDataMap.set("autopayment.mode.auto.week.sum", String.valueOf(autopaymentAutoMaxWeekSum));
                BigDecimal autopaymentAutoMaxMonthSum = this.moduleSetup.getBigDecimal("vepay.autopayment.mode.auto.month.sum.default", new BigDecimal(3000));
                autopaymentAutoMaxMonthSum = this.req.getBigDecimal("maxMonthSum", autopaymentAutoMaxMonthSum);
                modeDataMap.set("autopayment.mode.auto.month.sum", String.valueOf(autopaymentAutoMaxMonthSum));
                autopayment.setSum(autopaymentAutoMaxDaySum);
                autopayment.setMode(AutopaymentMode.AUTO);
            }
            transactionManager.close();
            this.setResultParam("mode", autopayment.getMode().getCode());
            autopaymentManager.updateAutopayment(autopayment);
            if (autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode()) {
                this.doRedirect(autopayment.getSum(), autopayment.getId());
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            autopaymentManager.close();
            if (autopayment.getMode().getCode() == AutopaymentMode.OFF.getCode()) {
                this.execute();
            }
        }
    }

    private void doRedirect(BigDecimal sum, int autopaymentId) throws BGException {
        block9: {
            try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
                String description = "";
                Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
                description = this.moduleSetup.get("vepay.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
                Transaction transaction = new Transaction();
                transaction.setSum(sum);
                transaction.setContractId(this.contractId);
                transaction.setCreateDate(new Date());
                if (autopaymentId > 0) {
                    transaction.setParameters("autopaymentId=" + autopaymentId);
                }
                transactionManager.update(transaction);
                String redirectUrl = transactionManager.doPaymentRequest(transaction, sum, description, this.moduleSetup.get("vepay.url.success", ""), this.moduleSetup.get("vepay.url.fail", ""), autopaymentId > 0);
                if (redirectUrl == null) break block9;
                try {
                    this.context.getResponse().sendRedirect(redirectUrl);
                    return;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
    }
}

