/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;

public class VoiceAccountNumberEditorDialog
extends BGEditorDialog<VoiceAccount> {
    private ClientContext context = null;
    private PhoneResourceService phoneResourceService = null;
    private PhoneCategoryTreeModel treeModel = new PhoneCategoryTreeModel();
    private BGUTreeTable treeTable = new BGUTreeTable((BGTreeTableModel)this.treeModel);
    private IntTextField fromNumber = new IntTextField(16);
    private IntTextField toNumber = new IntTextField(16);
    private IntTextField maxField = new IntTextField(6);
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private BGUList<IdTitle> result = new BGUList();

    public VoiceAccountNumberEditorDialog(String title, VoiceAccount data, ClientContext context) {
        super(title, (Object)data);
        this.context = context;
    }

    public void doDialogPanel() {
        this.panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getLeftPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getResultPanel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.date.setLocalDate(LocalDate.now());
        this.maxField.setValue((long)ClientSetup.getInstance().getUserConfig().getInt("voice.resource.ip.free.max", 100));
        try {
            this.treeModel.setData(this.getPhoneResourceService().phoneCategoryRoot());
            this.treeModel.setSelectedRow(0);
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((String)e.getMessage());
        }
    }

    public boolean doApply() throws Exception {
        IdTitle idTitle = (IdTitle)this.result.getSelectedValue();
        if (idTitle != null) {
            ((VoiceAccount)this.data).setNumber(Long.valueOf(idTitle.getTitle()).longValue());
        }
        return true;
    }

    private JPanel getLeftPanel() {
        Dimension dimension = new Dimension(350, 400);
        JScrollPane scrollPane = new JScrollPane((Component)this.treeTable);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 13, 1, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        JButton goButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        goButton.addActionListener(e -> {
            PhoneCategory category = (PhoneCategory)this.treeModel.getSelectedRow();
            if (category == null || category.getId() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
                return;
            }
            if (this.date.getDateCalendar() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0430\u0442\u0443");
                return;
            }
            try {
                this.result.setData(this.getPhoneResourceService().phoneFreeList(Integer.valueOf(category.getId()), this.date.getDate(), Long.valueOf(this.fromNumber.getValue()), Long.valueOf(this.toNumber.getValue()), (int)this.maxField.getValue()).stream().map(t -> new IdTitle(0, String.valueOf(t))).collect(Collectors.toList()));
            }
            catch (BGException e1) {
                ClientUtils.showErrorMessageDialog((String)e1.getMessage());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.fromNumber, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u041e:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.toNumber, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.date, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.maxField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)goButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getResultPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.result), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        return panel;
    }

    private PhoneResourceService getPhoneResourceService() {
        if (this.phoneResourceService == null) {
            this.phoneResourceService = (PhoneResourceService)this.context.getPort(PhoneResourceService.class);
        }
        return this.phoneResourceService;
    }

    class PhoneCategoryTreeModel
    extends BGTreeTableModel<PhoneCategory> {
        public PhoneCategoryTreeModel() {
            super(PhoneCategoryTreeModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", PhoneCategory.class, -1, 300, -1, "title", false);
            this.addColumnId();
        }
    }
}

