/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.MediatorAdapter;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.common.mediation.Mediator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public abstract class AbstractMediator
extends MediatorAdapter
implements Mediator {
    private static final Logger logger = LogManager.getLogger();
    private NumberConverter[] callingStationE164Converter;
    private NumberConverter[] calledStationE164Converter;

    public Object init(Setup setup, int moduleId, VoiceDevice device, VoiceDeviceType deviceType, ParameterMap config) throws Exception {
        ArrayList<NumberConverter> callingStationE164Converter = new ArrayList<NumberConverter>();
        ArrayList<NumberConverter> calledStationE164Converter = new ArrayList<NumberConverter>();
        if (config != null) {
            String[] pattern;
            String patternString;
            for (ParameterMap e : config.subIndexed("mediator.callingStationE164.convert").values()) {
                if (logger.isDebugEnabled()) {
                    // empty if block
                }
                if (Utils.isBlankString((String)(patternString = e.get("", null)))) continue;
                pattern = patternString.split("=>");
                callingStationE164Converter.add(new NumberConverter(Pattern.compile(pattern[0]), pattern[1]));
            }
            for (ParameterMap e : config.subIndexed("mediator.calledStationE164.convert").values()) {
                patternString = e.get("", null);
                if (Utils.isBlankString((String)patternString)) continue;
                pattern = patternString.split("=>");
                calledStationE164Converter.add(new NumberConverter(Pattern.compile(pattern[0]), pattern[1]));
            }
        }
        return null;
    }

    private static String toE164(NumberConverter[] converters, String number) {
        if (converters != null) {
            for (NumberConverter c : converters) {
                Matcher m = c.pattern.matcher(number);
                if (!m.find()) continue;
                StringBuffer sb = new StringBuffer(number.length() + 10);
                m.appendReplacement(sb, c.replacement);
                m.appendTail(sb);
                return sb.toString();
            }
        }
        return number;
    }

    public String callingStationIdToE164(String callingStationId) {
        return AbstractMediator.toE164(this.callingStationE164Converter, callingStationId);
    }

    public String calledStationIdToE164(String calledStationId) {
        return AbstractMediator.toE164(this.calledStationE164Converter, calledStationId);
    }

    public static void main(String[] args) {
        System.out.println("81073472".replaceAll("^810(\\d+)$", "$1"));
        System.out.println("89174".replaceAll("^8(\\d+)$", "7$1"));
    }

    static class NumberConverter {
        final Pattern pattern;
        final String replacement;

        public NumberConverter(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }
    }
}

