/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.ErrorTask;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceHourSessionProcessor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceErrorDao;
import ru.bitel.bgbilling.modules.voice.server.event.LogProcessInterrupted;
import ru.bitel.common.sql.ConnectionSet;

public class VoiceErrorFlusher
implements Callable<Object> {
    private static final Logger logger = LogManager.getLogger();
    private final VoiceHourSessionProcessor sessionProcessor;

    public VoiceErrorFlusher(VoiceHourSessionProcessor sessionProcessor) {
        this.sessionProcessor = sessionProcessor;
    }

    @Override
    public Object call() throws Exception {
        ServerContext context = (ServerContext)ServerContext.get();
        int moduleId = context.getModuleId();
        ConnectionSet conSet = context.getConnectionSet();
        try (VoiceErrorDao voiceErrorDao = new VoiceErrorDao(conSet, moduleId, this.sessionProcessor.getHour());){
            ErrorTask task;
            VoiceErrorDao.checkTables(conSet.getConnection(), moduleId, this.sessionProcessor.getHour());
            voiceErrorDao.deleteErrors(this.sessionProcessor.getDeviceId(), this.sessionProcessor.getHour());
            while ((task = this.sessionProcessor.getNextErrorTask()) != null) {
                voiceErrorDao.insertErrors(task.getErrors());
            }
        }
        catch (InterruptedException ex) {
            logger.error(this.getClass().getName() + " was interrupted", (Throwable)ex);
        }
        catch (Exception e) {
            logger.error("fatal error in " + this.getClass().getName(), (Throwable)e);
            EventProcessor.getInstance().request((QueueEvent)new LogProcessInterrupted(moduleId, 0));
        }
        return null;
    }
}

