/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.event;

import java.util.Date;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.common.SerialUtils;

@XmlRootElement
public class RequestLogInfoEvent
extends QueueEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(RequestLogInfoEvent.class);
    private Date month;
    @XmlAttribute
    private int deviceId;
    private int[] logs = new int[31];

    protected RequestLogInfoEvent() {
    }

    public RequestLogInfoEvent(int moduleId, Date month, int deviceId) {
        super(moduleId, CONTRACT_GLOBAL, 0);
        this.month = month;
        this.deviceId = deviceId;
    }

    public int[] getLogs() {
        return this.logs;
    }

    public void addLogs(int[] logs) {
        if (this.logs == null) {
            this.logs = logs;
        } else {
            for (int i = 0; i < 31; ++i) {
                int n = i;
                this.logs[n] = this.logs[n] | logs[i];
            }
        }
    }

    public Date getMonth() {
        return this.month;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }
}

