/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceOperAccountModifiedEvent;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceOperAccountDao;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.CopyOnWriteListMap;
import ru.bitel.common.util.CopyOnWriteRangeListMap;
import ru.bitel.common.util.Ranger;

public class VoiceOperAccountRuntimeMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private Date dateFrom;
    private Map<Integer, VoiceOperAccountRuntime> accountMap = new HashMap<Integer, VoiceOperAccountRuntime>();
    private final CopyOnWriteListMap<Integer, VoiceOperAccountRuntime> contractMap = new CopyOnWriteListMap(128, 4);
    private static VoiceOperAccountRuntimeMap intance = null;
    private VoiceApplication application;
    private final Ranger<VoiceOperAccountRuntime, Long> periodRanger = new Ranger<VoiceOperAccountRuntime, Long>(){

        public Long getMinValue(VoiceOperAccountRuntime r) {
            return r.getDateFromMillis() > 0L ? Long.valueOf(r.getDateFromMillis()) : null;
        }

        public Long getMaxValue(VoiceOperAccountRuntime r) {
            return r.getDateToMillis() > 0L ? Long.valueOf(r.getDateToMillis()) : null;
        }
    };
    private final CopyOnWriteRangeListMap<Integer, VoiceOperAccountRuntime, Long> deviceMap = new CopyOnWriteRangeListMap(this.periodRanger, 128, 1);

    public static VoiceOperAccountRuntimeMap getInstance(ConnectionSet connectionSet, VoiceApplication application) throws BGException {
        return VoiceOperAccountRuntimeMap.getInstance(connectionSet, application, TimeUtils.getStartMonth((Date)new Date()));
    }

    public static VoiceOperAccountRuntimeMap getInstance(ConnectionSet connectionSet, VoiceApplication application, Date month) throws BGException {
        return VoiceOperAccountRuntimeMap.getInstance(connectionSet.getConnection(), application, month);
    }

    public static VoiceOperAccountRuntimeMap getInstance(Connection connection, VoiceApplication application, Date month) throws BGException {
        if (intance == null) {
            intance = new VoiceOperAccountRuntimeMap(application);
            intance.load(connection, month);
        }
        return intance;
    }

    protected VoiceOperAccountRuntimeMap(VoiceApplication application) throws BGException {
        this.application = application;
        EventProcessor ep = EventProcessor.getInstance();
        ep.addListener((EventListener)this, VoiceOperAccountModifiedEvent.class, application.getModuleId(), null);
        ep.addListener((EventListener)this, ContractTariffChangedEvent.class);
    }

    public void load(Connection con, Date dateFrom) throws BGException {
        logger.info("loading accounts");
        this.dateFrom = dateFrom;
        this.accountMap.clear();
        this.deviceMap.clear();
        this.contractMap.clear();
        EventProcessor ep = EventProcessor.getInstance();
        try (VoiceOperAccountDao accountDao = new VoiceOperAccountDao(con, this.application.getModuleId());
             TariffModuleTreeSetDao tariffModuleTreeDao = new TariffModuleTreeSetDao(con);){
            List<VoiceOperAccount> list = accountDao.list();
            for (VoiceOperAccount account : list) {
                VoiceOperAccountRuntime runtime = this.createRuntimeInternal(tariffModuleTreeDao, account);
                this.addRuntimeInternal(runtime);
            }
        }
    }

    private VoiceOperAccountRuntime createRuntimeInternal(TariffModuleTreeSetDao tariffModuleTreeDao, VoiceOperAccount account) throws BGException {
        VoiceOperAccountRuntime accountRuntime = new VoiceOperAccountRuntime(account);
        accountRuntime.setTariffTreeSet(tariffModuleTreeDao.getRealtimeTariffTreeSet(account.getContractId(), this.dateFrom, "voice", this.application.getModuleId(), -1, account.getId()));
        return accountRuntime;
    }

    private void addRuntimeInternal(VoiceOperAccountRuntime accountRuntime) throws BGException {
        this.accountMap.put(((VoiceOperAccount)accountRuntime.getAccount()).getId(), accountRuntime);
        this.contractMap.add((Object)((VoiceOperAccount)accountRuntime.getAccount()).getContractId(), (Object)accountRuntime);
        this.deviceMap.add((Object)((VoiceOperAccount)accountRuntime.getAccount()).getDeviceId(), (Object)accountRuntime);
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public VoiceOperAccountRuntime findById(int id) {
        return this.accountMap.get(id);
    }

    public List<VoiceOperAccountRuntime> find(int deviceId, Date date, String fromNumber, String toNumber, String fromPort, String toPort) {
        List<VoiceOperAccountRuntime> result = this.deviceMap.list((Object)deviceId, (Comparable)Long.valueOf(date.getTime())).stream().filter(a -> a.isMatches(fromNumber, toNumber, fromPort, toPort)).collect(Collectors.toList());
        return result;
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof VoiceOperAccountModifiedEvent) {
            VoiceOperAccountModifiedEvent modEvent = (VoiceOperAccountModifiedEvent)e;
            if (modEvent.getNewAccount() != null) {
                this.onAccountModified(ctx.getConnection(), modEvent.getNewAccount());
            } else {
                this.removeRuntime(modEvent.getOldAccount().getId());
            }
        } else if (e instanceof ContractTariffChangedEvent) {
            this.onTariffListChanged(ctx.getConnection(), (ContractTariffChangedEvent)e);
        }
    }

    private void onTariffListChanged(Connection connection, ContractTariffChangedEvent e) {
        List accountList = this.contractMap.get((Object)e.getContractId());
        if (accountList != null) {
            Date now = new Date();
            try (TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(connection);){
                for (VoiceOperAccountRuntime account : accountList) {
                    account.setTariffTreeSet(treeSetDao.getRealtimeTariffTreeSet(((VoiceOperAccount)account.getAccount()).getContractId(), now, "voice", this.application.getModuleId(), -1, ((VoiceOperAccount)account.getAccount()).getId()));
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void onAccountModified(Connection con, VoiceOperAccount account) throws BGException {
        if (!this.application.getDeviceIds().contains(account.getDeviceId())) {
            logger.info("remove runtime from not existing device: " + account.getId());
            this.removeRuntime(account.getId());
            return;
        }
        VoiceOperAccountRuntime runtime = this.accountMap.get(account.getId());
        if (runtime == null) {
            logger.info("Adding new accountRuntime: " + account.getId());
            try (TariffModuleTreeSetDao dao = new TariffModuleTreeSetDao(con);){
                runtime = this.createRuntimeInternal(dao, account);
            }
            this.addRuntimeInternal(runtime);
        } else {
            logger.info("Reload accountRuntime: " + account.getId());
            this.removeRuntime(account.getId());
            runtime.setAccount(account);
            this.addRuntimeInternal(runtime);
        }
    }

    public VoiceOperAccountRuntime removeRuntime(int accountId) {
        VoiceOperAccountRuntime old = this.accountMap.remove(accountId);
        if (old == null) {
            logger.warn("accountRuntime is null for " + accountId);
            return null;
        }
        this.contractMap.remove((Object)old.getContractId(), (Object)old);
        this.deviceMap.remove((Object)((VoiceOperAccount)old.getAccount()).getDeviceId(), (Object)old);
        return old;
    }
}

