/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.beans.ConstructorProperties;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.export.RadiusExport;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceSessionFinishDeviceEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceSessionFinishEvent;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNas;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNasConnection;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusProcessor;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntimeMap;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;

public class VoiceRadius
extends VoiceApplication {
    private static final Logger logger = LogManager.getLogger();
    protected VoiceSessionRuntimeMap voiceSessionRuntimeMap;

    @ConstructorProperties(value={"setup"})
    public VoiceRadius(Setup setup) throws BGException {
        super(setup, true);
    }

    public VoiceRadius(Setup setup, boolean runtime) throws BGException {
        super(setup, runtime);
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.voiceSessionRuntimeMap = new VoiceSessionRuntimeMap(this.moduleId);
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
            if (this.runtime) {
                this.loadSessionMap(connectionSet);
            }
        }
    }

    @Override
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof VoiceSessionFinishEvent) {
            VoiceSessionFinishEvent finishEvent = (VoiceSessionFinishEvent)e;
            this.finishSession(finishEvent.getSessionId());
        } else if (e instanceof VoiceSessionFinishDeviceEvent) {
            VoiceSessionFinishDeviceEvent finishEvent = (VoiceSessionFinishDeviceEvent)e;
            this.finishSessionsOnDevice(finishEvent.getDeviceId());
        } else {
            super.notify(e, ctx);
        }
    }

    @Override
    public String executeCommand(String cmd, String param) {
        try {
            if (cmd.equals("radiusAccountExport")) {
                VoiceRadiusProcessor proc = this.getProcessor();
                new RadiusExport(proc, this.setup).export(param);
                return "OK";
            }
            return super.executeCommand(cmd, param);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            return null;
        }
    }

    private void finishSessionsOnDevice(int deviceId) throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        VoiceRadiusProcessor processor = this.getProcessor();
        VoiceNas nas = processor.getNas(deviceId);
        if (nas == null) {
            throw new BGException("Nas is null for deviceId " + deviceId);
        }
        nas.stopConnections(context.getConnectionSet());
    }

    private void finishSession(long sessionId) throws BGException {
        ServerContext context = (ServerContext)ServerContext.get();
        VoiceSessionRuntime sessionRuntime = this.voiceSessionRuntimeMap.getBySessionId(sessionId);
        if (sessionRuntime == null) {
            throw new BGException("sessionRuntime is null for sessionId=" + sessionId);
        }
        VoiceRadiusProcessor processor = this.getProcessor();
        VoiceNas nas = processor.getNas(sessionRuntime.getSession().getDeviceId());
        if (nas == null) {
            throw new BGException("Nas is null for sessionId=" + sessionId + " deviceId " + sessionRuntime.getSession().getDeviceId());
        }
        try {
            nas.stopConnection(context.getConnectionSet(), sessionRuntime.getSession().getIdentifier());
        }
        catch (BGException ex) {
            throw new BGException("Erorr for sessionId=" + sessionId + " deviceId " + sessionRuntime.getSession().getDeviceId() + " Identifier " + sessionRuntime.getSession().getIdentifier() + ":" + ex.getMessage());
        }
    }

    public VoiceRadiusProcessor getProcessor() throws BGException {
        try {
            VoiceRadiusProcessor processor = (VoiceRadiusProcessor)((Object)Setup.getEnvironment().lookup("radiusProcessor"));
            return processor;
        }
        catch (NamingException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void loadSessionMap(ConnectionSet connectionSet) throws BGException {
        VoiceRadiusProcessor processor = this.getProcessor();
        this.voiceSessionRuntimeMap.load(connectionSet, this.voiceAccountRuntimeMap, (NasList<VoiceNasConnection, VoiceNas>)processor.getNasList());
    }

    public void addSesionRuntime(VoiceSessionRuntime sessionRuntime) {
        this.voiceSessionRuntimeMap.add(sessionRuntime);
    }

    public void removeSessionRuntime(VoiceSessionRuntime sessionRuntime) {
        this.voiceSessionRuntimeMap.removeSession(sessionRuntime);
    }

    public Set<VoiceSessionRuntime> getSessionsByAccountId(int accountId) {
        return this.voiceSessionRuntimeMap.getByAccountId(accountId);
    }
}

