/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime.geocode;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;

class GeoNode<I> {
    protected VoiceGeographicCode code;
    private Map<Integer, GeoNode<I>> childs = new HashMap<Integer, GeoNode<I>>(10, 1.0f);
    protected I item;

    GeoNode() {
    }

    public void addItem(I item, VoiceGeographicCode code) {
        GeoNode<I> node = this.addCode(code, code.getCode());
        if (node != null) {
            node.item = item;
        }
    }

    public I getItem() {
        return this.item;
    }

    public void addCode(VoiceGeographicCode code) {
        this.addCode(code, code.getCode());
    }

    protected GeoNode<I> addCode(VoiceGeographicCode code, String codeStr) {
        int digit = Integer.valueOf(codeStr.substring(0, 1));
        GeoNode<I> child = this.childs.get(digit);
        if (child == null) {
            child = new GeoNode<I>();
            this.childs.put(digit, child);
        }
        if (codeStr.length() > 1) {
            String suffix = codeStr.substring(1, codeStr.length());
            return child.addCode(code, suffix);
        }
        child.code = code;
        return child;
    }

    public VoiceGeographicCode findCode(String number, boolean useLevel) {
        return this.findCode(number, null, useLevel);
    }

    public GeoNode<I> findNode(String number, boolean useLevel) {
        return this.findNode(number, null, useLevel);
    }

    protected VoiceGeographicCode findCode(String number, VoiceGeographicCode code, boolean useLevel) {
        VoiceGeographicCode resultCode = code;
        if (this.code != null) {
            if (useLevel) {
                int stoplevel;
                int startlevel;
                int n = this.code.getStartLevel() > 0 ? this.code.getStartLevel() : (startlevel = code != null ? code.getStartLevel() : 0);
                int n2 = this.code.getStopLevel() > 0 ? this.code.getStopLevel() : (stoplevel = code != null ? code.getStopLevel() : 0);
                if (!(startlevel != 0 && this.code.getLevel() < startlevel || stoplevel != 0 && this.code.getLevel() > stoplevel)) {
                    resultCode = this.code;
                }
            } else {
                resultCode = this.code;
            }
        }
        if (number.length() == 0) {
            return resultCode;
        }
        int digit = Integer.valueOf(number.substring(0, 1));
        GeoNode<I> child = this.childs.get(digit);
        if (child != null && number.length() > 0) {
            String suffix = number.substring(1, number.length());
            return child.findCode(suffix, resultCode, useLevel);
        }
        return resultCode;
    }

    protected GeoNode<I> findNode(String number, GeoNode<I> node, boolean useLevel) {
        GeoNode resultNode = node;
        if (this.code != null) {
            if (useLevel) {
                int stoplevel;
                int startlevel;
                int n = this.code.getStartLevel() > 0 ? this.code.getStartLevel() : (startlevel = node != null ? node.code.getStartLevel() : 0);
                int n2 = this.code.getStopLevel() > 0 ? this.code.getStopLevel() : (stoplevel = node != null ? node.code.getStopLevel() : 0);
                if (!(startlevel != 0 && this.code.getLevel() < startlevel || stoplevel != 0 && this.code.getLevel() > stoplevel)) {
                    resultNode = this;
                }
            } else {
                resultNode = this;
            }
        }
        if (number.length() == 0) {
            return resultNode;
        }
        int digit = Integer.valueOf(number.substring(0, 1));
        GeoNode<I> child = this.childs.get(digit);
        if (child != null && number.length() > 0) {
            String suffix = number.substring(1, number.length());
            return child.findNode(suffix, resultNode, useLevel);
        }
        return resultNode;
    }
}

