/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceProcessLog;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceLogManagementService;
import ru.bitel.bgbilling.modules.voice.server.bean.DataProccessRecordDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceProcessLogDao;
import ru.bitel.bgbilling.modules.voice.server.event.RequestLogInfoEvent;
import ru.bitel.bgbilling.modules.voice.server.event.RequestRadiusLogInfoEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceLogManagementService")
public class VoiceLogManagementServiceImpl
extends AbstractService
implements VoiceLogManagementService {
    DataProccessRecordDao dataProcessRecordDao;
    VoiceProcessLogDao voiceProcessLogDao;

    @PostConstruct
    void init() throws BGException {
        this.dataProcessRecordDao = new DataProccessRecordDao(this.getConnection(), this.moduleId);
        this.voiceProcessLogDao = new VoiceProcessLogDao(this.getConnection(), this.moduleId);
    }

    public Result<?> voiceLogExist(Integer deviceId, Date month) throws BGException {
        Result result = new Result();
        int[] exists = this.getLogExists(deviceId, month);
        if (exists != null) {
            result.setAttribute("logExists", (Object)exists);
        }
        return result;
    }

    public Result<?> voiceRadiusLogExist(Integer deviceId, Date month) throws BGException {
        Result result = new Result();
        int[] exists = this.getRadisLogExists(deviceId, month);
        if (exists != null) {
            result.setAttribute("logExists", (Object)exists);
        }
        return result;
    }

    public List<DataProcessRecord> voiceLogLoading(Integer deviceId, Date month) throws BGException {
        Calendar cal = new GregorianCalendar();
        cal.setTime(month);
        cal = TimeUtils.getStartMonth((Calendar)cal);
        cal.set(5, 1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
        Date dateFrom = TimeUtils.convertCalendarToDate((Calendar)cal);
        cal.add(2, 1);
        Date dateTo = TimeUtils.convertCalendarToDate((Calendar)cal);
        return this.dataProcessRecordDao.list(deviceId, dateFrom, dateTo);
    }

    public List<VoiceProcessLog> voiceLogLoaded(Integer deviceId, Date month) throws BGException {
        Calendar cal = new GregorianCalendar();
        cal.setTime(month);
        cal = TimeUtils.getStartMonth((Calendar)cal);
        cal.set(5, 1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
        Date dateFrom = TimeUtils.convertCalendarToDate((Calendar)cal);
        cal.add(2, 1);
        Date dateTo = TimeUtils.convertCalendarToDate((Calendar)cal);
        return this.voiceProcessLogDao.list(deviceId, dateFrom, dateTo);
    }

    protected int[] getLogExists(Integer deviceId, Date month) throws BGException {
        int[] exists = null;
        RequestLogInfoEvent event = new RequestLogInfoEvent(this.moduleId, month, deviceId);
        event = (RequestLogInfoEvent)EventProcessor.getInstance().request((Event)event, 5000L);
        if (event != null) {
            exists = event.getLogs();
        }
        return exists;
    }

    protected int[] getRadisLogExists(Integer deviceId, Date month) throws BGException {
        int[] exists = null;
        RequestLogInfoEvent event = new RequestRadiusLogInfoEvent(this.moduleId, month, deviceId);
        event = (RequestLogInfoEvent)EventProcessor.getInstance().request((Event)event, 5000L);
        if (event != null) {
            exists = event.getLogs();
        }
        return exists;
    }

    public void voiceAddProcessLogs(Integer deviceId, List<Date> days) throws BGException {
        this.addTasks(deviceId, days, false);
    }

    public void voiceAddRadiusProcessLogs(Integer deviceId, List<Date> days) throws BGException {
        this.addTasks(deviceId, days, true);
    }

    public void addTasks(Integer deviceId, List<Date> days, boolean isRadius) throws BGException {
        List<DataProcessRecord> list = this.dataProcessRecordDao.list(isRadius);
        for (Date day : days) {
            boolean found = false;
            for (DataProcessRecord record : list) {
                if (record.getDeviceId() != deviceId.intValue() || !record.getDay().equals(day)) continue;
                found = true;
                break;
            }
            if (found) continue;
            DataProcessRecord record = new DataProcessRecord();
            record.setDeviceId(deviceId.intValue());
            record.setDay(day);
            record.setRadius(isRadius);
            this.dataProcessRecordDao.update(record);
        }
    }

    public void voiceDeleteProcessLogs(Integer deviceId, List<Date> hours) throws BGException {
        this.dataProcessRecordDao.delete(deviceId, hours);
    }
}

