/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import bitel.billing.server.util.MailMsg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletContext;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import ru.bitel.bgbilling.apps.voice.accounting.bean.SessionAccountAmount;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionFilter;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionAccountReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDestinationReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetail;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetailReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionServiceReportItem;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDestinationService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceSessionService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionExporter;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceSessionFinishEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceSessionService")
public class VoiceSessionServiceImpl
extends AbstractService
implements VoiceSessionService {
    @Resource
    private WebServiceContext wsc;
    @Resource
    private VoiceDestinationService destinationService;

    @PostConstruct
    private void init() {
    }

    public Result<VoiceSession> voiceSessionContractList(VoiceSessionFilter filter, Page page) throws BGException {
        Result result;
        try (VoiceSessionDao sessionDao = new VoiceSessionDao(this.getConnection(), this.moduleId);){
            List<VoiceSession> sessionList = sessionDao.list(filter, page, true);
            result = new Result(sessionList, page);
            this.addTotals(result, page, sessionDao, filter);
        }
        return result;
    }

    private void addTotals(Result<?> result, Page page, VoiceSessionLogDao sessionDao, VoiceSessionFilter filter) throws BGException {
        result.setAttribute("totalCount", (Object)page.getRecordCount());
        SessionAccountAmount accAmount = sessionDao.getContractSums(filter);
        result.setAttribute("totalTime", (Object)accAmount.getAmount());
        result.setAttribute("totalTimeRound", (Object)accAmount.getAmountRound());
        result.setAttribute("totalSum", (Object)accAmount.getAccount());
    }

    public Result<VoiceSession> voiceSessionLogContractList(VoiceSessionFilter filter, Page page) throws BGException {
        Result result;
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<VoiceSession> sessionList = sessionDao.list(filter, page, true);
            result = new Result(sessionList, page);
            this.addTotals(result, page, sessionDao, filter);
        }
        return result;
    }

    public Result<VoiceSession> voiceSessionLogList(VoiceSessionFilter filter, Page page) throws BGException {
        List<Object> sessionList = new ArrayList();
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getDateFrom());){
            sessionList = sessionDao.list(filter, page, false);
        }
        return new Result(sessionList, page);
    }

    public Result<VoiceSession> voiceSessionList(VoiceSessionFilter filter, Page page) throws BGException {
        List<Object> sessionList = new ArrayList();
        try (VoiceSessionDao sessionDao = new VoiceSessionDao(this.getConnection(), this.moduleId);){
            sessionList = sessionDao.list(filter, page, false);
        }
        return new Result(sessionList, page);
    }

    public void sessionFinish(long sessionId) throws BGException {
        VoiceSessionFinishEvent event = (VoiceSessionFinishEvent)EventProcessor.getInstance().request((QueueEvent)new VoiceSessionFinishEvent(this.moduleId, this.userId, sessionId));
        if (event == null) {
            throw new BGMessageException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e Accounting \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
        }
    }

    public List<SessionAccountReportItem> voiceSessionReportGroupByAccount(VoiceSessionFilter filter) throws BGException {
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<SessionAccountReportItem> list = sessionDao.getSessionsGroupedByAccount(filter);
            return list;
        }
    }

    public List<SessionDestinationReportItem> voiceSessionReportGroupByAccountAndDestination(VoiceSessionFilter filter) throws BGException {
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<SessionDestinationReportItem> list = sessionDao.getSessionsGroupedByAccountAndDestination(filter);
            return list;
        }
    }

    public List<SessionServiceReportItem> voiceSessionReportGroupByAccountAndService(VoiceSessionFilter filter) throws BGException {
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<SessionServiceReportItem> list = sessionDao.getSessionsGroupedByAccountAndService(filter);
            return list;
        }
    }

    public Result<SessionDetail<SessionDetail<SessionDetailReportItem>>> voiceSessionDetailReport(VoiceSessionFilter filter, Page page) throws BGException {
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
            List<SessionDetail<SessionDetail<SessionDetailReportItem>>> detailList = sessionDao.getSessionsDetail(filter, page);
            Result result = new Result();
            result.setList(detailList);
            result.setPage(page);
            Map<String, SessionDetail> resultMap = sessionDao.getDetailSumValues(filter);
            for (SessionDetail<SessionDetail<SessionDetailReportItem>> det : detailList) {
                int serviceId = det.getServiceId();
                SessionDetail serviceDetail = resultMap.get(serviceId + "_0");
                det.copyInfoFrom(serviceDetail);
                SessionDetailReportItem itemService = new SessionDetailReportItem();
                for (SessionDetail det2 : det.getResult()) {
                    int accountId = det2.getAccountId();
                    SessionDetail accountDetail = resultMap.get(serviceId + "_" + accountId);
                    det2.copyInfoFrom(accountDetail);
                }
            }
            this.addTotals(result, page, sessionDao, filter);
            Result result2 = result;
            return result2;
        }
    }

    @XmlMimeType(value="application/octet-stream")
    public DataHandler voiceSessionContractLogExport(VoiceSessionFilter filter, String format, Page page) throws BGException {
        try {
            Result<VoiceSession> result = this.voiceSessionLogContractList(filter, page);
            Holder destinations = new Holder();
            this.destinationService.voiceDestinationList(VoiceOperator.OPERTOR_ALL_ID, null, new Holder((Object)page), destinations);
            Map destinationsMap = VoiceDestination.getDestinationMap((List)((List)VoiceCommonUtils.readFromHolder((Holder)destinations)));
            InputStream exportDataStream = null;
            if (format.equals("csv")) {
                char separator = this.getModuleSetup().get("csv.separator", ";").charAt(0);
                exportDataStream = new VoiceSessionExporter().csvExport(result, separator, destinationsMap);
            } else {
                try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                    Contract contract = (Contract)contractDao.get(((Integer)filter.getContractIds().toArray()[0]).intValue());
                    ServletContext context = (ServletContext)this.wsc.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
                    exportDataStream = new VoiceSessionExporter().htmlSessionExport(contract, new Period(filter.getHourFrom(), filter.getHourTo()), result, context, destinationsMap);
                }
            }
            return this.createDataHandler("text/plain", exportDataStream);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private DataHandler createDataHandler(final String contentType, final InputStream exportDataStream) {
        return new DataHandler(new DataSource(){

            public String getContentType() {
                return contentType;
            }

            public InputStream getInputStream() throws IOException {
                return exportDataStream;
            }

            public String getName() {
                return "sessions.html";
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
    }

    public DataHandler voiceSessionDetailExport(VoiceSessionFilter filter, String format) throws BGException {
        try {
            InputStream exportDataStream;
            String contentType = "text/plain";
            Page page = new Page(1, Integer.MAX_VALUE);
            Result<SessionDetail<SessionDetail<SessionDetailReportItem>>> result = this.voiceSessionDetailReport(filter, page);
            try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(this.getConnection(), this.moduleId, filter.getHourFrom());){
                this.addTotals(result, page, sessionDao, filter);
            }
            if (format.equals("csv")) {
                char separator = this.getModuleSetup().get("csv.separator", ";").charAt(0);
                exportDataStream = new VoiceSessionExporter().csvDetailExport(result, separator);
            } else if (format.equals("html")) {
                try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                    Contract contract = (Contract)contractDao.get(((Integer)filter.getContractIds().toArray()[0]).intValue());
                    ServletContext context = (ServletContext)this.wsc.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
                    exportDataStream = new VoiceSessionExporter().htmlDetailExport(contract, new Period(filter.getHourFrom(), filter.getHourTo()), result, context);
                }
            } else {
                throw new BGException("Unknowm format");
            }
            DataHandler handler = this.createDataHandler(contentType, exportDataStream);
            return handler;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void voiceSessionDetailEmail(VoiceSessionFilter filter, List<String> emails) throws BGException {
        try {
            DataHandler data = this.voiceSessionDetailExport(filter, "html");
            String subjectPrefix = "\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0439";
            Period period = new Period(filter.getHourFrom(), filter.getHourTo());
            this.sendReport(emails, data, subjectPrefix, period);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void sendReport(List<String> emails, DataHandler data, String subjectPrefix, Period period) throws IOException, MessagingException, BGException {
        MimeMultipart multipart = new MimeMultipart();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        data.writeTo((OutputStream)baos);
        MimeBodyPart attach = new MimeBodyPart();
        attach.setFileName(MimeUtility.encodeText((String)data.getName(), (String)"utf-8", (String)"B"));
        attach.setContent((Object)baos.toByteArray(), "application/html");
        multipart.addBodyPart((BodyPart)attach);
        MailMsg msg = new MailMsg((Preferences)Setup.getSetup());
        for (String email : emails) {
            msg.sendMessage(email, subjectPrefix + " ( " + TimeUtils.formatPeriod((Period)period) + " )", (Multipart)multipart);
        }
    }

    public void voiceSessionEmail(VoiceSessionFilter filter, List<String> emails, Page page) throws BGException {
        try {
            DataHandler data = this.voiceSessionContractLogExport(filter, "html ", page);
            Period period = new Period(filter.getHourFrom(), filter.getHourTo());
            String subjectPrefix = "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c";
            this.sendReport(emails, data, subjectPrefix, period);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

