/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.task;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class VoiceBalanceTask
extends TaskBase {
    private static Logger log = LogManager.getLogger();
    private Set<Integer> contracts = new HashSet<Integer>();

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        LocalDate month = TimeUtils.convertDateToLocalDate((Date)this.getOperatingTime().getTime());
        month = month.minusDays(this.taskSetup.getInt("minus.days", 0));
        try (Connection con = this.setup.getDBConnectionFromPool();){
            String sessionTable = ServerUtils.getModuleMonthTableName((String)"voice_session_account_log", (LocalDate)month, (int)this.moduleId);
            if (!ServerUtils.tableExists((Connection)con, (String)sessionTable)) {
                return;
            }
            String query = "SELECT contractId, serviceId, SUM(account) FROM " + sessionTable;
            if (this.contracts.size() > 0) {
                query = query + " WHERE contractId IN (" + Utils.toString(this.contracts) + ")";
            }
            query = query + " GROUP BY contractId, serviceId";
            ServiceCostCache costCache = new ServiceCostCache();
            try (PreparedStatement ps = con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    costCache.addAmount(new CostSum(rs.getInt(1), rs.getInt(2), rs.getBigDecimal(3)));
                }
            }
            String sids = ModuleCache.getInstance().getModuleServicesString(Integer.valueOf(this.moduleId).intValue());
            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(TimeUtils.convertLocalDateToDate((LocalDate)month));
                balanceUtils.setAccount(con, log, (Calendar)cal, costCache, sids, Utils.toString(this.contracts), null);
            }
        }
        catch (Exception ex) {
            log.error("error while executing \"" + this.getDescription() + "\"" + ex.getMessage(), (Throwable)ex);
        }
    }

    public String getDescription() {
        return null;
    }

    protected Set<Integer> getContracts() {
        return this.contracts;
    }

    protected void setContracts(Set<Integer> contracts) {
        this.contracts = contracts;
    }
}

