/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.radius;

import bitel.billing.server.processor.voiceip.VoiceIpSessionRealtime;
import java.sql.Connection;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.network.radius.AccountingSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLogin;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpSessionUtils;
import ru.bitel.bgbilling.modules.voiceip.server.event.radius.SessionCreatingEvent;
import ru.bitel.bgbilling.modules.voiceip.server.radius.VoiceIpNas;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class VoiceIpNasConnection
extends NasConnection<VoiceIpSessionRealtime> {
    private final Object mutex = new Object();
    protected volatile String key;
    protected int moduleId = 0;

    public VoiceIpNasConnection(VoiceIpSessionRealtime session, Setup setup, int moduleId, NasList<? extends NasConnection<?>, ? extends Nas<? extends NasConnection<?>, ?, ?>> nasList, int nasId) {
        super((AccountingSession)session, (DefaultServerSetup)setup, nasList, nasId);
        this.moduleId = moduleId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConnection(VoiceIpNas nas, RadiusPacket request, Connection con) {
        Object object = this.mutex;
        synchronized (object) {
            this.stopConnectionImpl(nas, request, con);
        }
    }

    private void stopConnectionImpl(VoiceIpNas nas, RadiusPacket request, Connection con) {
        try {
            this.setStatus(NasConnection.Status.stopped);
            VoiceIpSessionRealtime session = (VoiceIpSessionRealtime)this.getSession();
            String ignoreDC = this.setup.get("voip.ignore.dc", null);
            if (request != null) {
                session.setDisconnectCause(request.getStringAttribute(nas.getVendorCode(), 30, null));
                if (((VoiceIpLogin)session.getLogin()).getUseDcFilterMode() != 1 && ignoreDC != null) {
                    StringTokenizer st = new StringTokenizer(ignoreDC, ";,");
                    while (st.hasMoreTokens()) {
                        String dc = st.nextToken().trim();
                        if (!dc.equals(String.valueOf(session.getDisconnectCause()))) continue;
                        session.addLogInfo("Setting session time = 0 because H323 disconnect cause = " + session.getDisconnectCause());
                        session.setSessionTime(0);
                        break;
                    }
                }
                session.checkAndCreateTables(con, this.setup);
                session.calculate(con);
                EventProcessor.getInstance().request((QueueEvent)new SessionCreatingEvent(this.moduleId, session));
                session.createSession(con);
                int cid = session.getContract().getId();
                VoiceIpLogin login = (VoiceIpLogin)session.getLogin();
                if (login.getBalanceRecalcMode() == 0) {
                    VoiceIpSessionUtils su = new VoiceIpSessionUtils(con, this.moduleId);
                    su.setContractAccountFromSession(session.getStartTime(), cid, session.getServiceId());
                    BalanceUtils bu = new BalanceUtils(con);
                    bu.setBalanceFromAccount(session.getContract(), session.getStartTime());
                    bu.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

