/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.radius;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.call.bean.CardCallUtils;
import bitel.billing.server.call.bean.Login;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.processor.voiceip.VoiceIpSessionRealtime;
import bitel.billing.server.tariff.voice.calc.ItemZoneCostCache;
import bitel.billing.server.tariff.voice.calc.ItemZoneTrafficCache;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.AlarmTask;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.network.radius.AbstractRadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.Digest5090RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginType;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginTypeManager;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLogin;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLoginManager;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpSession;
import ru.bitel.bgbilling.modules.voiceip.server.event.radius.RadiusAuthenticationEvent;
import ru.bitel.bgbilling.modules.voiceip.server.radius.VoiceIpNas;
import ru.bitel.bgbilling.modules.voiceip.server.radius.VoiceIpNasConnection;
import ru.bitel.bgbilling.modules.voiceip.server.radius.VoiceIpRadiusSessionParams;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class VoiceIpRadiusProcessor
extends AbstractRadiusProcessor<VoiceIpNasConnection, VoiceIpNas, VoiceIpRadiusSessionParams> {
    private static final Logger log = LogManager.getLogger();
    public static final RadiusPacket.RadiusPacketOption<Integer> CALL_TYPE = VoiceIpNas.CALL_TYPE;
    public static final RadiusPacket.RadiusPacketOption<Integer> FIND_MODE = VoiceIpNas.FIND_MODE;
    public static final RadiusPacket.RadiusPacketOption<Integer> SERVICE = VoiceIpNas.SERVICE;
    public static final RadiusPacket.RadiusPacketOption<Integer> OPERATOR = VoiceIpNas.OPERATOR;
    public static final int OUTGOING_CALL = 1;
    public static final int INCOMING_CALL = 2;
    private final Setup setup;
    private final ItemZoneTrafficCache itemZoneTrafficCache = new ItemZoneTrafficCache(log);
    private final ItemZoneCostCache itemZoneCostCache = new ItemZoneCostCache(log);
    private Map<Integer, List<String[]>> loginTypeAttributes = null;
    private volatile long zoneTrafficCacheTime = 300000L;
    private static final Pattern patAlias = Pattern.compile("\\$\\{ALIAS\\}");
    private static final Pattern patBalanceMode = Pattern.compile("\\$\\{BALANCE_MODE\\}");
    private static final Pattern patMinCost = Pattern.compile("\\$\\{MIN_COST\\}");

    public VoiceIpRadiusProcessor(Setup setup, int moduleId) throws BGException {
        super(setup, "voiceip", moduleId, (NasList)new NasList<VoiceIpNasConnection, VoiceIpNas>(){

            protected VoiceIpNas newNas(DefaultServerSetup setup, int moduleId, RadiusProcessor<VoiceIpNasConnection, VoiceIpNas, ?> processor, int id, VoiceIpNas oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, VoiceIpNasConnection> connections, String script, NasConnectionInspector inspector, Object ... params) {
                return new VoiceIpNas((Setup)setup, moduleId, (VoiceIpRadiusProcessor)processor, id, oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, script, inspector);
            }
        });
        this.setup = setup;
        this.init();
    }

    private void init() {
        AlarmSender.initSender((DefaultServerSetup)this.setup);
        AlarmSender.registerAlarmTask((AlarmTask)new DatabaseCheckTask());
        Connection con = null;
        try {
            con = this.setup.getDBConnectionFromPool();
            this.nasList.load((DefaultServerSetup)this.setup, (RadiusProcessor)this, con, this.moduleId);
            LoginTypeManager ltm = new LoginTypeManager(con, this.moduleId);
            this.loginTypeAttributes = ltm.getAttributesMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        this.zoneTrafficCacheTime = this.setup.getLong("radius.zoneTrafficCacheTime", 300L) * 1000L;
        this.setup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("reload".equals(e.getActionCommand())) {
                    VoiceIpRadiusProcessor.this.zoneTrafficCacheTime = VoiceIpRadiusProcessor.this.setup.getLong("radius.zoneTrafficCacheTime", 300L) * 1000L;
                }
            }
        });
    }

    private void setCallType(VoiceIpNas nas, RadiusPacket request) {
        ParameterMap _conf = nas.getConf();
        String inCall = request.getCode() == 1 ? _conf.get("auth.in", "voip/originate") : _conf.get("acct.in", "voip/originate");
        String outCall = request.getCode() == 1 ? _conf.get("auth.out", "voip/answer") : _conf.get("acct.out", "voip/answer");
        String[] outCallsArray = outCall.split(";");
        HashSet<String> outCalls = new HashSet<String>();
        for (int i = 0; i < outCallsArray.length; ++i) {
            outCalls.add(outCallsArray[i].trim());
        }
        String[] inCallsArray = inCall.split(";");
        HashSet<String> inCalls = new HashSet<String>();
        for (int i = 0; i < inCallsArray.length; ++i) {
            inCalls.add(inCallsArray[i].trim());
        }
        if (outCall.equals("all/all")) {
            request.setOption(CALL_TYPE, (Object)1);
        } else if (inCall.equals("all/all")) {
            request.setOption(CALL_TYPE, (Object)2);
        } else {
            RadiusAttribute.RadiusAttributeString callType = (RadiusAttribute.RadiusAttributeString)request.getAttribute(nas.getVendorCode(), 27);
            RadiusAttribute.RadiusAttributeString callOrigin = (RadiusAttribute.RadiusAttributeString)request.getAttribute(nas.getVendorCode(), 26);
            if (callType != null && callOrigin != null) {
                String callRef = ((String)callType.getValue()).toLowerCase() + "/" + ((String)callOrigin.getValue()).toLowerCase();
                if (outCalls.contains(callRef)) {
                    request.setOption(CALL_TYPE, (Object)1);
                } else if (inCalls.contains(callRef)) {
                    request.setOption(CALL_TYPE, (Object)2);
                }
            }
        }
    }

    private int getCallType(RadiusPacket request) {
        Integer callType = (Integer)request.getOption(CALL_TYPE);
        if (callType != null && (callType == 2 || callType == 1)) {
            return callType;
        }
        return -1;
    }

    protected void preprocessAccessRequest(VoiceIpNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        this.setCallType(nas, request);
        super.preprocessAccessRequest((Nas)nas, request, response, connectionSet);
        nas.removeRealm(request);
    }

    protected void preprocessAccountingRequest(VoiceIpNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        this.setCallType(nas, request);
        super.preprocessAccountingRequest((Nas)nas, request, response, connectionSet);
        nas.removeRealm(request);
    }

    protected RadiusSession<VoiceIpNas, VoiceIpRadiusSessionParams> newRadiusSession(Connection con, VoiceIpNas nas, RadiusPacket request, RadiusSession.State state) {
        RadiusAttribute.RadiusAttributeString userNameAttribute = (RadiusAttribute.RadiusAttributeString)request.getAttribute(-1, 1);
        if (userNameAttribute == null) {
            return null;
        }
        int callType = this.getCallType(request);
        String userName = (String)userNameAttribute.getValue();
        int pos = (userName = Utils.deleteAfterDog((String)userName)).indexOf(92);
        if (pos >= 0) {
            userName = userName.substring(pos + 1);
        }
        userNameAttribute = userNameAttribute.clone();
        if (request.getAttribute(-1, 79) != null) {
            return new EAPSession<VoiceIpNas, VoiceIpRadiusSessionParams>(userName, userNameAttribute, new VoiceIpRadiusSessionParams(callType)){

                public boolean checkPassword(Nas<?, ?, ?> nas, RadiusAttributeSet request, RadiusAttributeSet response, String openPassw, byte[] secret, byte[] authenticator) {
                    return this.login != null && !((VoiceIpLogin)((Object)this.login)).isAuthCheckPassword() || super.checkPassword(nas, request, response, openPassw, secret, authenticator);
                }
            };
        }
        if (request.getAttribute(-1, 108) != null) {
            return new Digest5090RadiusSession<VoiceIpNas, VoiceIpRadiusSessionParams>(state != null ? state.state : null, userName, userNameAttribute, new VoiceIpRadiusSessionParams(callType)){

                public boolean checkPassword(Nas<?, ?, ?> nas, RadiusAttributeSet request, RadiusAttributeSet response, String openPassw, byte[] secret, byte[] authenticator) {
                    return this.login != null && !((VoiceIpLogin)((Object)this.login)).isAuthCheckPassword() || super.checkPassword(nas, request, response, openPassw, secret, authenticator);
                }
            };
        }
        return new RadiusSession<VoiceIpNas, VoiceIpRadiusSessionParams>(state != null ? state.state : null, userName, userNameAttribute, new VoiceIpRadiusSessionParams(callType)){

            public boolean checkPassword(Nas<?, ?, ?> nas, RadiusAttributeSet request, RadiusAttributeSet response, String openPassw, byte[] secret, byte[] authenticator) {
                return this.login != null && !((VoiceIpLogin)((Object)this.login)).isAuthCheckPassword() || super.checkPassword(nas, request, response, openPassw, secret, authenticator);
            }
        };
    }

    protected Login getLogin(VoiceIpNas nas, RadiusPacket req, RadiusPacket resp, Connection con, String userName) {
        VoiceIpLogin result = null;
        try {
            Integer findMode = (Integer)req.getOption(FIND_MODE);
            if (findMode == null) {
                findMode = -1;
            }
            result = nas.getFindProcessor().findLogin(req, con, findMode, new Date());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (result != null && log.isDebugEnabled()) {
            log.debug("Found login type " + result.getType());
        }
        return result;
    }

    protected Login getLogin(Connection con, int cid, Card card) {
        Login result = null;
        try {
            int lid = new CardCallUtils(con, this.moduleId).createLogin(cid, card, 0);
            if (lid > 0) {
                result = new VoiceIpLoginManager(con, this.moduleId).getLoginById(lid);
                ((VoiceIpLogin)result).importTypeOptions(new LoginType());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected int authentication(RadiusListenerWorker<?> req, VoiceIpNas nas, RadiusSession<VoiceIpNas, VoiceIpRadiusSessionParams> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        Connection con = connectionSet.getConnection();
        int callType = ((VoiceIpRadiusSessionParams)session.sessionParams).callType;
        if (callType == 1) {
            log.debug("Process outgoing auth " + request.toString());
            return this.authenticationImpl(req, nas, session, request, response, connectionSet, log_record_id, false);
        }
        if (callType == 2 && nas.isAuthIncomeFull()) {
            log.debug("Process incoming auth as outgoing " + request.toString());
            return this.authenticationIncome(req, nas, session, request, response, connectionSet, log_record_id, con);
        }
        if (callType == 2) {
            String userName = session.userName;
            ContractManager contrM = new ContractManager(con);
            VoiceIpLogin login = (VoiceIpLogin)this.getLogin(nas, request, response, con, userName);
            if (login != null) {
                Contract contract = contrM.getContractById(login.getCid());
                int errorCode = this.authorization(req, nas, session, request, response, connectionSet, log_record_id, contrM, contract, (Object)login, userName);
                if (errorCode == 0) {
                    return 0;
                }
                return this.executeError(con, nas, request, response, contract != null ? contract.getId() : 0, login != null ? login.getId() : 0, errorCode, log_record_id);
            }
            return this.executeError(con, nas, request, response, 0, 0, 14, log_record_id);
        }
        return this.executeError(con, nas, request, response, 0, 0, 13, log_record_id);
    }

    private int authenticationIncome(RadiusListenerWorker<?> req, VoiceIpNas nas, RadiusSession<VoiceIpNas, VoiceIpRadiusSessionParams> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id, Connection con) {
        String userName = session.userName;
        boolean authOk = false;
        int errorCode = 0;
        ContractManager contrM = new ContractManager(con);
        VoiceIpLogin login = (VoiceIpLogin)this.getLogin(nas, request, response, con, userName);
        if (login != null) {
            Contract contract = contrM.getContractById(login.getCid());
            authOk = true;
            this.checkLoginAndContract(login, contract);
            if (authOk) {
                log.debug("Checking access allow...");
                if (!login.getStatus()) {
                    log.debug("Login access deny...");
                    errorCode = 26;
                    authOk = false;
                }
            }
            if (authOk) {
                log.debug("Checking contract status");
                if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, contract.getStatus())) {
                    log.debug("Contract not open...");
                    errorCode = 33;
                    authOk = false;
                }
            }
            if (authOk) {
                log.debug("Checking balance...");
                BalanceUtils bu = new BalanceUtils(con);
                BigDecimal summa = bu.getBalanceOut(new Date(), contract.getId());
                BigDecimal limit = contract.getBalanceLimit();
                bu.close();
                if (summa.compareTo(limit) < 0) {
                    errorCode = 4;
                    authOk = false;
                }
            }
            if (authOk) {
                errorCode = this.authorization(req, nas, session, request, response, connectionSet, log_record_id, contrM, contract, (Object)login, userName);
                boolean bl = authOk = errorCode == 0;
            }
            if (errorCode == 0) {
                return 0;
            }
            return this.executeError(con, nas, request, response, contract != null ? contract.getId() : 0, login != null ? login.getId() : 0, errorCode, log_record_id);
        }
        return this.executeError(con, nas, request, response, 0, 0, 14, log_record_id);
    }

    protected int authorization(RadiusListenerWorker<?> req, VoiceIpNas nas, RadiusSession<VoiceIpNas, VoiceIpRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id, ContractManager contrM, Contract contract, Object _login, String userName) {
        Connection con = connectionSet.getConnection();
        int errorCode = 0;
        contract.setTts(contrM.getTariffTreeSetForDay(contract.getId(), (Calendar)new GregorianCalendar(), this.module, this.moduleId, true));
        if (((VoiceIpRadiusSessionParams)radiusSession.sessionParams).callType == 1) {
            log.debug("Checking tariff...");
            if (contract.getTts().getTree(new GregorianCalendar().getTime()) == null) {
                log.debug("Tariff plan not found.");
                return 3;
            }
        }
        VoiceIpLogin login = (VoiceIpLogin)((Object)_login);
        VoiceIpSessionRealtime session = new VoiceIpSessionRealtime();
        session.setItemZoneTrafficCache(this.initZoneTraffics(login.getId(), con, new GregorianCalendar()));
        session.setItemZoneCostCache(this.initZoneCosts(login.getId(), con, new GregorianCalendar()));
        int sid = -1;
        session.setContract(contract);
        session.setLogin(login);
        session.setCallType(((VoiceIpRadiusSessionParams)radiusSession.sessionParams).callType);
        Integer requestServiceId = (Integer)request.getOption(SERVICE);
        log.debug("requestServiceId = {}", (Object)requestServiceId);
        if (requestServiceId != null && requestServiceId > 0) {
            sid = requestServiceId;
            if (log.isDebugEnabled()) {
                log.debug("Taking service from script setting=" + requestServiceId);
            }
        } else {
            sid = nas.getService(0, null, null);
        }
        this.setOperatorFromRequest(request, session);
        if (sid < 0) {
            errorCode = 7;
            session = null;
        }
        if (session != null) {
            if (log.isDebugEnabled()) {
                log.debug("session.getCallType() = {}", (Object)session.getCallType());
                log.debug("login.getInTariffType() = {}", (Object)login.getInTariffType());
                log.debug("login.getOutTariffType() = {}", (Object)login.getOutTariffType());
            }
            if (session.getCallType() == 2 && login.getInTariffType() == 0) {
                session = null;
            } else if (session.getCallType() == 1 && login.getOutTariffType() == 0) {
                session = null;
            }
            log.debug("session = {}", (Object)session);
        }
        if (session != null) {
            session.setServiceId(sid);
            Set<Integer> sidSet = session.getServices();
            if (!this.checkService(con, contract.getId(), sidSet)) {
                errorCode = 19;
                session = null;
            }
        }
        if (session != null) {
            session.setMid(this.moduleId);
            session.setRequestLogRecordId(log_record_id);
            session.setFromNumber(Utils.deleteBeforeSharp((String)request.getStringAttribute(-1, 31, null)));
            session.setToNumber(Utils.deleteBeforeSharp((String)request.getStringAttribute(-1, 30, null)));
            session.setStartTime(new GregorianCalendar());
            int callType = ((VoiceIpRadiusSessionParams)radiusSession.sessionParams).callType;
            if (callType == 1) {
                errorCode = this.processOutgoingCall(con, connectionSet.getSlaveConnection(), nas, request, response, session);
            } else if (callType == 2) {
                if (RadiusDictionary.checkAttribute((int)nas.getVendorCode(), (int)103, (int)2)) {
                    response.setStringAttribute(nas.getVendorCode(), 103, "0");
                }
                response.setCode((byte)2);
                session.checkRest(con, this.getMaxTime());
                String _H323_conf_id = nas.getConfigId(request);
                if (_H323_conf_id != null) {
                    VoiceIpNasConnection nasCon = new VoiceIpNasConnection(session, this.setup, this.moduleId, this.nasList, nas.getId());
                    nas.setConnection(nasCon, request, con, connectionSet.getSlaveConnection());
                }
            }
            if (errorCode == 0) {
                this.addLoginAttributes(response, con, session);
            }
        }
        return errorCode;
    }

    protected int executeError(Connection con, VoiceIpNas nas, RadiusPacket request, RadiusPacket response, int cid, int lid, int errorCode, int logRecordId) {
        if (RadiusDictionary.checkAttribute((int)nas.getVendorCode(), (int)103, (int)2)) {
            response.setStringAttribute(nas.getVendorCode(), 103, String.valueOf(errorCode));
        }
        if (errorCode == 4 && !nas.isNoCreditAmount()) {
            this.setCreditAmount(con, nas, response, cid);
        }
        return super.executeError(con, (Nas)nas, request, response, cid, lid, errorCode, logRecordId);
    }

    private int processOutgoingCall(Connection con, Connection conSlave, VoiceIpNas nas, RadiusPacket request, RadiusPacket response, VoiceIpSessionRealtime session) {
        int errorCode = 0;
        String opponent_station = session.getOpponentStation();
        Contract contract = session.getContract();
        if (!nas.isNoCreditAmount()) {
            this.setCreditAmount(con, nas, response, contract.getId());
        }
        if (opponent_station == null) {
            if (RadiusDictionary.checkAttribute((int)nas.getVendorCode(), (int)103, (int)2)) {
                response.setStringAttribute(nas.getVendorCode(), 103, "0");
            }
            response.setCode((byte)2);
        } else {
            int error = session.checkRest(con, this.getMaxTime());
            if (error != 0) {
                errorCode = error;
            } else {
                if (RadiusDictionary.checkAttribute((int)nas.getVendorCode(), (int)nas.getCreditTimeAttrType(), (int)2)) {
                    response.setStringAttribute(nas.getVendorCode(), nas.getCreditTimeAttrType(), String.valueOf(session.getMaxSessionTime()));
                }
                VoiceIpNasConnection nasCon = new VoiceIpNasConnection(session, this.setup, this.moduleId, this.nasList, nas.getId());
                String _H323_conf_id = nas.getConfigId(request);
                if (_H323_conf_id == null || nas.setConnection(nasCon, request, con, conSlave) != null) {
                    if (RadiusDictionary.checkAttribute((int)nas.getVendorCode(), (int)103, (int)2)) {
                        response.setStringAttribute(nas.getVendorCode(), 103, "0");
                    }
                } else {
                    errorCode = 12;
                }
            }
        }
        return errorCode;
    }

    private final int getMaxTime() {
        int maxTime = this.setup.getInt("voip.max.time", 1800);
        return maxTime;
    }

    protected LocalEvent newRadiusAuthenticationEvent(RadiusPacket request, RadiusPacket response, RadiusSession<VoiceIpNas, VoiceIpRadiusSessionParams> radiusSession, int logRecordId) {
        return new RadiusAuthenticationEvent(radiusSession, this.moduleId, logRecordId, request, response);
    }

    private ItemZoneTrafficCache initZoneTraffics(int loginId, Connection con, Calendar time) {
        log.debug("initZoneTraffics...");
        this.itemZoneTrafficCache.tryUpdate(con, this.moduleId, loginId, time, this.zoneTrafficCacheTime);
        return this.itemZoneTrafficCache;
    }

    private ItemZoneCostCache initZoneCosts(int loginId, Connection con, Calendar time) {
        log.debug("initCostTraffics...");
        this.itemZoneCostCache.tryUpdate(con, this.moduleId, loginId, time, this.zoneTrafficCacheTime);
        return this.itemZoneCostCache;
    }

    private void addLoginAttributes(RadiusPacket response, Connection con, VoiceIpSession session) {
        VoiceIpLoginManager vlu = new VoiceIpLoginManager(con, this.moduleId);
        VoiceIpLogin login = (VoiceIpLogin)session.getLogin();
        Map avp = vlu.loadAVPPairs(login);
        List pairs = (List)avp.get("default");
        if (pairs != null) {
            String[] pair2 = null;
            for (String[] pair2 : pairs) {
                RadiusAttribute ra = RadiusDictionary.newRadiusAttribute((String)pair2[0], (String)pair2[1]);
                if (ra == null) continue;
                response.addAttribute(ra);
            }
        }
        if (login.getType() == 0) {
            this.addDefaultLoginTypeAttributes(response, con, session);
        } else {
            this.addLoginTypeAttributes(response, con, session);
        }
    }

    private void addDefaultLoginTypeAttributes(RadiusPacket response, Connection con, VoiceIpSession session) {
        String attrs = this.setup.get("default.login.attributes", null);
        if (Utils.notBlankString((String)attrs)) {
            StringTokenizer st = new StringTokenizer(attrs, ";");
            while (st.hasMoreTokens()) {
                String attrAndValue = st.nextToken();
                int pos = attrAndValue.indexOf("=");
                if (pos <= 0) continue;
                String attr = attrAndValue.substring(0, pos);
                String value = attrAndValue.substring(pos + 1);
                this.addAttrWithMacro(response, con, attr, value, session);
            }
        }
    }

    private void addLoginTypeAttributes(RadiusPacket response, Connection con, VoiceIpSession session) {
        VoiceIpLogin login = (VoiceIpLogin)session.getLogin();
        List<String[]> attrsList = this.loginTypeAttributes.get(login.getType());
        if (attrsList != null) {
            for (String[] attrs : attrsList) {
                String name = attrs[0];
                String value = attrs[1];
                this.addAttrWithMacro(response, con, name, value, session);
            }
        }
    }

    private void addAttrWithMacro(RadiusPacket response, Connection con, String name, String value, VoiceIpSession session) {
        VoiceIpLogin login = (VoiceIpLogin)session.getLogin();
        Contract contract = session.getContract();
        try {
            RadiusAttribute ra;
            Matcher m = patAlias.matcher(value);
            if (m.find()) {
                String query = "SELECT login_alias FROM user_alias_" + this.moduleId + " WHERE login_id=? LIMIT 1";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, login.getId());
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    ps.close();
                    return;
                }
                value = m.replaceAll(rs.getString(1));
                rs.close();
                ps.close();
            }
            if ((m = patBalanceMode.matcher(value)).find()) {
                String mode = "";
                mode = contract.getBalanceMode() == 0 ? "0" : "1";
                value = m.replaceAll(mode);
            }
            if ((m = patMinCost.matcher(value)).find()) {
                int minCostPrecission = this.setup.getInt("min.cost.precision", 2);
                value = m.replaceAll(Utils.formatCost((float)session.getMinuteCost(), (int)minCostPrecission));
            }
            if ((ra = RadiusDictionary.newRadiusAttribute((String)name, (String)value)) != null) {
                response.addAttribute(ra);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VoiceIpNasConnection accounting(RadiusListenerWorker<VoiceIpNas> req, VoiceIpNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        Connection con = connectionSet.getConnection();
        VoiceIpNasConnection result = null;
        int acctStatusType = request.getIntAttribute(-1, 40, Integer.valueOf(0));
        if (acctStatusType == 2) {
            long now = System.currentTimeMillis();
            Integer callType = (Integer)request.getOption(CALL_TYPE);
            if (callType != null && (callType == 1 || callType == 2)) {
                log.debug("Process accounting, flag=" + callType + " " + request.toString());
                int maxTime = this.getMaxTime();
                boolean connectionExists = false;
                String _H323_conf_id = nas.getConfigId(request);
                Iterator iter = nas.connections().iterator();
                while (iter.hasNext()) {
                    VoiceIpNasConnection nasCon = (VoiceIpNasConnection)((Object)iter.next());
                    VoiceIpSessionRealtime session = (VoiceIpSessionRealtime)nasCon.getSession();
                    Calendar conStart = session.getStartTime();
                    if (conStart != null && (now - conStart.getTimeInMillis()) / 1000L > (long)(maxTime * 2)) {
                        iter.remove();
                        continue;
                    }
                    if (!session.getH323ID().equals(_H323_conf_id)) continue;
                    iter.remove();
                    VoiceIpNasConnection voiceIpNasConnection = nasCon;
                    synchronized (voiceIpNasConnection) {
                        if (nasCon.getStatus() == NasConnection.Status.stopped) {
                            log.debug("Find connection already stopped " + _H323_conf_id);
                            continue;
                        }
                        log.debug("Stopping saved connection " + _H323_conf_id);
                        this.setOperatorFromRequest(request, session);
                        int sessionTime = request.getIntAttribute(-1, 46, Integer.valueOf(0));
                        ((VoiceIpSessionRealtime)nasCon.getSession()).setSessionTime(sessionTime);
                        ((VoiceIpSessionRealtime)nasCon.getSession()).checkAndCreateTables(con, (DefaultServerSetup)this.setup);
                        nasCon.stopConnection(nas, request, con);
                    }
                    connectionExists = true;
                    RadiusUtils.addToLog((DefaultServerSetup)this.setup, (int)this.moduleId, (RadiusPacket)request, (Date)session.getStartTime().getTime(), (int)session.getRequestLogRecordId());
                    result = nasCon;
                }
                if (!connectionExists) {
                    String connectTimeString;
                    log.debug("Saved connection not found");
                    Calendar connectTime = null;
                    if (nas.getConf().get("radius.stop.useConnectTime", "0").equals("1") && (connectTimeString = request.getStringAttribute(nas.getVendorCode(), 28, null)) != null) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS z EEE MMM dd yyyy", Locale.US);
                        try {
                            connectTime = TimeUtils.convertDateToCalendar((Date)dateFormat.parse(connectTimeString));
                        }
                        catch (ParseException ex) {
                            log.error((Object)ex.getCause(), (Throwable)ex);
                        }
                    }
                    int logRecordId = RadiusUtils.insertToLog((DefaultServerSetup)this.setup, (int)this.moduleId, (RadiusPacket)request, (Date)(connectTime != null ? connectTime.getTime() : new Date()));
                    int requestServiceId = (Integer)request.getOption(SERVICE, (Object)0);
                    int sid = 0;
                    if (requestServiceId > 0) {
                        sid = requestServiceId;
                        if (log.isDebugEnabled()) {
                            log.debug("Taking service from script setting=" + requestServiceId);
                        }
                    } else {
                        sid = nas.getService(0, null, null);
                    }
                    if (sid > 0) {
                        VoiceIpLogin login = (VoiceIpLogin)this.getLogin(nas, request, response, con, (String)null);
                        if (login == null) {
                            log.debug("Login not found..");
                        } else if (login.isIgnoreAccount()) {
                            log.debug("Login ignore accounts..");
                        } else {
                            log.debug("Login found.");
                            ContractManager contrM = new ContractManager(con);
                            Contract contract = contrM.getContractById(login.getCid());
                            VoiceIpSessionRealtime session = new VoiceIpSessionRealtime();
                            session.setLogin(login);
                            session.setContract(contract);
                            session.setMid(this.moduleId);
                            session.setRequestLogRecordId(logRecordId);
                            session.setServiceId(sid);
                            session.setFromNumber(Utils.deleteBeforeSharp((String)request.getStringAttribute(-1, 31, null)));
                            session.setToNumber(Utils.deleteBeforeSharp((String)request.getStringAttribute(-1, 30, null)));
                            session.setCallType(this.getCallType(request));
                            session.setNasId(nas.getId());
                            session.setH323ID(nas.getConfigId(request));
                            this.setOperatorFromRequest(request, session);
                            GregorianCalendar cal = new GregorianCalendar();
                            int sessionTime = request.getIntAttribute(-1, 46, Integer.valueOf(0));
                            ((Calendar)cal).add(13, -sessionTime);
                            session.setStartTime(cal);
                            if (connectTime == null) {
                                GregorianCalendar timeCalendar = new GregorianCalendar();
                                ((Calendar)timeCalendar).add(13, -sessionTime);
                                session.setStartTime(timeCalendar);
                            } else {
                                session.setStartTime(connectTime);
                            }
                            session.setSessionTime(sessionTime);
                            session.setItemZoneTrafficCache(this.initZoneTraffics(login.getId(), con, session.getStartTime()));
                            session.setItemZoneCostCache(this.initZoneCosts(login.getId(), con, session.getStartTime()));
                            if (session.getOpponentStation() == null && session.needTarification()) {
                                log.debug("Tariff station not found!");
                            } else {
                                contract.setTts(contrM.getRealtimeTariffTreeSet(contract.getId(), session.getStartTime().getTime(), "voiceip", this.moduleId, true));
                                VoiceIpNasConnection nasCon = new VoiceIpNasConnection(session, this.setup, this.moduleId, this.nasList, nas.getId());
                                nasCon.stopConnection(nas, request, con);
                                result = nasCon;
                            }
                        }
                    }
                }
            } else if (nas.needLogError()) {
                log.error("Call type not recognized " + request.toString());
            }
        }
        response.setCode((byte)5);
        return result;
    }

    private void setOperatorFromRequest(RadiusPacket request, VoiceIpSessionRealtime session) {
        Integer operatorId = (Integer)request.getOption(OPERATOR);
        if (operatorId != null) {
            session.setOperatorId(operatorId);
        }
    }

    public String getStatus() {
        StringBuilder report = new StringBuilder();
        VersionInfo vi = VersionInfo.getVersionInfo((String)"voiceip");
        report.append("version ");
        report.append(vi.getVersionString());
        report.append("\n");
        report.append(TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy HH:mm:ss\t"));
        report.append("\nRequest accounts per minute: ");
        report.append(this.accountingStopCounter.getCount());
        report.append("\nRequest auths per minute accept: ");
        report.append(this.authenticationAcceptCounter.getCount());
        report.append("; reject: ");
        report.append(this.authenticationRejectCounter.getCount());
        report.append("\nIgnore per minute auth: ");
        report.append(this.authenticationIgnoreCount.getCount());
        report.append("\nWaiting connections: ");
        report.append(this.getConnectionList().size());
        this.addCommonStatusData(report);
        return report.toString();
    }

    public String executeCommand(String command, String params) {
        return "Unsupported command";
    }

    private void setCreditAmount(Connection con, VoiceIpNas nas, RadiusPacket response, int cid) {
        try (BalanceUtils bu = new BalanceUtils(con);){
            BigDecimal summa = bu.getBalance(new Date(), cid);
            summa = summa.add(this.setup.getBigDecimal("balance.summa.shift", BigDecimal.ZERO));
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            DecimalFormat df = new DecimalFormat(nas.getConf().get("balance.summa.format.pattern", "################.##"));
            df.setDecimalFormatSymbols(dfs);
            if (RadiusDictionary.checkAttribute((int)nas.getVendorCode(), (int)101, (int)2)) {
                response.setStringAttribute(nas.getVendorCode(), 101, df.format(summa));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

