/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelButtonGroup;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.assist.client.AssistPaymentEditor;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ServicePropertiesPanel
extends ServicePanel {
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGControlPanelButtonGroup statuses = new BGControlPanelButtonGroup(false);
    private BGTable table = new BGTable();
    private AssistPaymentEditor editor = new AssistPaymentEditor();
    private JLabel recurringLabel = new JLabel("-");
    private BGButton recurringDoButton = new BGButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0451\u0436 \u0441\u0435\u0439\u0447\u0430\u0441...");
    private BGButton recurringDeleteButton = new BGButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0451\u0436...");
    private String r_amount;

    public ServicePropertiesPanel() {
        this.setTabbedPanel();
        this.jbInit();
        this.table.setHeader(this.rb_name, this.moduleDoc, "contract_assist_payment");
        this.editor.setVisible(false);
    }

    public void init(int cid, int mid) {
        super.init(cid, mid);
        this.editor.init(this.module, mid);
    }

    private void jbInit() {
        this.setLayout(this.cardLayout1);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        filterPanel.add((Component)this.period, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441\u044b"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.statuses, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 10, new Insets(0, 10, 5, 5), 0, 0));
        filterPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 10, new Insets(0, 10, 5, 5), 0, 0));
        JPanel recurringPanel = new JPanel(new GridBagLayout());
        this.recurringDoButton.setEnabled(false);
        this.recurringDeleteButton.setEnabled(false);
        recurringPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436"));
        recurringPanel.add((Component)this.recurringLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        recurringPanel.add((Component)this.recurringDoButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        recurringPanel.add((Component)this.recurringDeleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        tablePanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        tablePanel.add((Component)((Object)this.editor), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        tablePanel.add((Component)recurringPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.statuses.addButton(AssistStatus.OK.getTitle(), AssistStatus.OK.toString(), true);
        this.statuses.addButton(AssistStatus.FAIL.getTitle(), AssistStatus.FAIL.toString(), true);
        this.statuses.addButton(AssistStatus.NEW.getTitle(), AssistStatus.NEW.toString(), true);
        Calendar now = Calendar.getInstance();
        this.period.setDateCalendar1(TimeUtils.getStartMonth((Calendar)now));
        this.period.setDateCalendar2(TimeUtils.getEndMonth((Calendar)now));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServicePropertiesPanel.this.editItem();
                }
            }
        });
        this.statuses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicePropertiesPanel.this.getPayments();
            }
        });
        this.period.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("date1".equals(evt.getPropertyName()) || "date2".equals(evt.getPropertyName())) {
                    ServicePropertiesPanel.this.getPayments();
                }
            }
        });
        this.add(tablePanel, "table");
        this.cardLayout1.show((Container)((Object)this), "table");
        this.editor.setActionSaved(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicePropertiesPanel.this.editor.setVisible(false);
                ServicePropertiesPanel.this.setData();
            }
        });
        this.editor.setActionCanceled(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicePropertiesPanel.this.editor.setVisible(false);
            }
        });
        JMenuItem mi = new JMenuItem("\u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicePropertiesPanel.this.doGetPaymentStatus();
            }
        });
        mi.setActionCommand("doGetPaymentStatus");
        this.table.getPopupMenu().add(mi);
        this.recurringDoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicePropertiesPanel.this.doRecurring();
            }
        });
        this.recurringDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicePropertiesPanel.this.deleteRecurring();
            }
        });
    }

    private void doGetPaymentStatus() {
        String rowid = ClientUtils.getRowId((BGTable)this.table);
        if (rowid != null) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("PayResult");
            req.setModuleId(this.getModuleId());
            req.setAttribute("ordernumber", rowid);
            req.setContractId(this.getContractId());
            Document doc = TransferManager.getDocument((Request)req);
            if (ClientUtils.checkStatus((Document)doc)) {
                String result = XMLUtils.selectText((Node)doc, (String)"/data/@result");
                AssistStatus resultStatus = AssistStatus.valueOf((String)result);
                String message = XMLUtils.selectText((Node)doc, (String)"/data/message/text()");
                String exception = XMLUtils.selectText((Node)doc, (String)"/data/exception/text()");
                StringBuilder sb = new StringBuilder();
                sb.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: ").append(result);
                if (resultStatus != null) {
                    sb.append(" (").append(resultStatus.getTitle()).append(")");
                }
                sb.append("\n\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: ").append(message);
                if (exception != null) {
                    sb.append("\nException: ").append(exception);
                }
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), sb.toString());
                this.getPayments();
            }
        }
    }

    public void setData() {
        this.getPayments();
    }

    public void getPayments() {
        if (this.getContractId() > -1 && this.getModuleId() > -1) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ContractPayList");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setPeriod(this.period.getPeriod());
            request.setAttribute("status", this.statuses.getSelectedCommand());
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.table.updateData(XMLUtils.selectNode((Node)doc, (String)"/data/table"));
            }
            request = new Request();
            request.setModule(this.module);
            request.setAction("RecurringList");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element recEl = XMLUtils.selectElement((Node)doc, (String)"/data/table/data/row");
                if (recEl != null) {
                    String r_date = XMLUtils.selectText((Node)recEl, (String)"@date");
                    String r_ordernumber = XMLUtils.selectText((Node)recEl, (String)"@ordernumber");
                    String r_billnumber = XMLUtils.selectText((Node)recEl, (String)"@billnumber");
                    this.r_amount = XMLUtils.selectText((Node)recEl, (String)"@amount");
                    String r_recurringMaxDate = XMLUtils.selectText((Node)recEl, (String)"@recurringMaxDate");
                    if (Utils.isBlankString((String)r_billnumber)) {
                        r_billnumber = "\u041d\u0415 \u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d";
                        this.recurringDoButton.setEnabled(false);
                        this.recurringDeleteButton.setEnabled(true);
                    } else {
                        this.recurringDoButton.setEnabled(true);
                        this.recurringDeleteButton.setEnabled(true);
                    }
                    this.recurringLabel.setText("billnumber: " + r_billnumber + ", \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d: " + r_date + ", \u0432 \u0437\u0430\u043a\u0430\u0437\u0435: " + r_ordernumber + " (\u0441\u0443\u043c\u043c\u0430 " + this.r_amount + "), \u0434\u043e \u0434\u0430\u0442\u044b: " + r_recurringMaxDate);
                } else {
                    this.recurringLabel.setText("-");
                    this.recurringDoButton.setEnabled(false);
                    this.recurringDeleteButton.setEnabled(false);
                }
            }
        }
    }

    public void editItem() {
        String rowid = ClientUtils.getRowId((BGTable)this.table);
        if (rowid != null) {
            this.editor.setData(rowid);
            this.editor.setVisible(true);
        }
    }

    private void doRecurring() {
        String sum = JOptionPane.showInputDialog("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430", (Object)this.r_amount);
        if (sum != null) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DoRecurring");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAttribute("sum", sum);
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            }
        }
    }

    private void deleteRecurring() {
        if (ClientUtils.confirmDelete((Object)"\u0440\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436")) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteRecurring");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u0443\u0434\u0430\u043b\u0451\u043d");
                this.setData();
            }
        }
    }
}

