/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.action;

import bitel.billing.server.ActionBase;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistStatus;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPayment;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionContractPayList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.mid > 0 && this.cid > 0) {
            int statusMask = AssistStatus.getMaskFromStatusList((String)this.getParameter("status"));
            Period period = this.getPeriod();
            AssistPaymentManager pm = new AssistPaymentManager(this.con, this.mid);
            List<AssistPayment> paymentList = pm.getPaymentList(this.cid, period.getDateFrom(), period.getDateTo(), statusMask);
            Element table = this.createElement(this.rootNode, "table");
            Element data = this.createElement(table, "data");
            for (AssistPayment payment : paymentList) {
                Element paymentEl = this.createElement(data, "row");
                paymentEl.setAttribute("id", String.valueOf(payment.getId()));
                paymentEl.setAttribute("cid", String.valueOf(payment.getCid()));
                paymentEl.setAttribute("card_text", payment.getCardText());
                paymentEl.setAttribute("cardholder", payment.getCardholder());
                paymentEl.setAttribute("name", payment.getName());
                paymentEl.setAttribute("total", Utils.formatCost((BigDecimal)payment.getTotal()));
                paymentEl.setAttribute("date", TimeUtils.format((Date)payment.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
                paymentEl.setAttribute("billnumber", payment.getBillnumber() > 0L ? String.valueOf(payment.getBillnumber()) : null);
                paymentEl.setAttribute("comment", payment.getComment());
                paymentEl.setAttribute("status_text", payment.getStatus() != null ? payment.getStatus().getTitle() : "<\u043e\u0448\u0438\u0431\u043a\u0430>");
                paymentEl.setAttribute("responsecode", payment.getResponseCode() != null ? payment.getResponseCode().toString() : "");
                paymentEl.setAttribute("recurringParentId", String.valueOf(payment.getRecurringParentId()));
            }
        } else {
            throw new BGIllegalArgumentException();
        }
    }
}

