/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistStatus;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPayment;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistUtils;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolResponseCode;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class AssistPaymentManager {
    private Connection con;
    private int mid;
    public static String DEFAULT_PAYMENT_COMMENT = "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433. ${contract} \u0447\u0435\u0440\u0435\u0437 Assist (\u041f\u043b\u0430\u0442\u0451\u0436 #${billnumber}) \u043e\u0442 ${date}";

    public AssistPaymentManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
    }

    public int addPayment(int cid, BigDecimal summ, int recurringParentId) throws BGException {
        int result = 0;
        try {
            String query = "INSERT INTO assist_payment_" + this.mid + " (cid, DATE, TOTAL, status, recurringParentId) VALUES (?, ?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, cid);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)new Date()));
            ps.setBigDecimal(3, summ);
            ps.setInt(4, AssistStatus.NEW.getCode());
            ps.setInt(5, recurringParentId);
            ps.executeUpdate();
            result = ServerUtils.lastInsertId((PreparedStatement)ps);
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<AssistPayment> getPaymentList(Period period, int status, String f_groups, String f_orderid, String f_contract, String f_cardname, String f_cardtext, String f_billnumber) throws SQLException {
        long grMask;
        ArrayList<AssistPayment> result = new ArrayList<AssistPayment>();
        StringBuffer query = new StringBuffer("SELECT assist.*, contract.title, contract.comment AS con_comment FROM assist_payment_" + this.mid + " AS assist LEFT JOIN contract ON contract.id=assist.cid WHERE (assist.status&?!=0)");
        if (period != null) {
            if (period.getDateFrom() != null) {
                query.append("AND(TO_DAYS(assist.DATE)>=TO_DAYS(?))");
            }
            if (period.getDateTo() != null) {
                query.append("AND(TO_DAYS(assist.DATE)<=TO_DAYS(?))");
            }
        }
        if ((grMask = Utils.enumToMask((String)f_groups)) > 0L) {
            query.append("AND(contract.gr&?>0)");
        }
        if (!Utils.isEmptyString((String)f_orderid)) {
            query.append("AND(assist.id LIKE ?)");
        }
        if (!Utils.isEmptyString((String)f_contract)) {
            query.append("AND(contract.title LIKE ?)");
        }
        if (!Utils.isEmptyString((String)f_cardname)) {
            query.append("AND(assist.CARDHOLDER LIKE ? OR assist.NAME LIKE ?)");
        }
        if (!Utils.isEmptyString((String)f_cardtext)) {
            query.append("AND(assist.CARDNUMBER LIKE ? OR assist.CARDTYPE LIKE ? OR assist.CARDSUBTYPE LIKE ?)");
        }
        if (!Utils.isEmptyString((String)f_billnumber)) {
            query.append("AND(assist.BILLNUMBER LIKE ?)");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int i = 1;
        ps.setInt(i++, status);
        if (period != null) {
            if (period.getDateFrom() != null) {
                ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
            }
            if (period.getDateTo() != null) {
                ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
            }
        }
        if (grMask > 0L) {
            ps.setLong(i++, grMask);
        }
        if (!Utils.isEmptyString((String)f_orderid)) {
            ps.setString(i++, "%" + f_orderid + "%");
        }
        if (!Utils.isEmptyString((String)f_contract)) {
            ps.setString(i++, "%" + f_contract + "%");
        }
        if (!Utils.isEmptyString((String)f_cardname)) {
            ps.setString(i++, "%" + f_cardname + "%");
            ps.setString(i++, "%" + f_cardname + "%");
        }
        if (!Utils.isEmptyString((String)f_cardtext)) {
            ps.setString(i++, "%" + f_cardtext + "%");
            ps.setString(i++, "%" + f_cardtext + "%");
            ps.setString(i++, "%" + f_cardtext + "%");
        }
        if (!Utils.isEmptyString((String)f_billnumber)) {
            ps.setString(i++, "%" + f_billnumber + "%");
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(AssistPaymentManager.getPaymentFromRS(rs, true));
        }
        rs.close();
        ps.close();
        return result;
    }

    public List<AssistPayment> getPaymentList(int cid, Date from, Date until, int status) throws BGException {
        ArrayList<AssistPayment> result = new ArrayList<AssistPayment>();
        try {
            StringBuffer query = new StringBuffer("SELECT * FROM assist_payment_" + this.mid + " WHERE (cid=?) AND (status&?!=0)");
            if (from != null) {
                query.append("AND(TO_DAYS(DATE)>=TO_DAYS(?))");
            }
            if (until != null) {
                query.append("AND(TO_DAYS(DATE)<=TO_DAYS(?))");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int i = 1;
            ps.setInt(i++, cid);
            ps.setInt(i++, status);
            if (from != null) {
                ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)from));
            }
            if (until != null) {
                ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)until));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(AssistPaymentManager.getPaymentFromRS(rs, false));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public AssistPayment getPayment(int cid, long id) throws BGException {
        AssistPayment result = null;
        try {
            String query = "SELECT assist.*, contract.title, contract.comment AS con_comment FROM assist_payment_" + this.mid + " as assist LEFT JOIN contract ON contract.id=assist.cid WHERE assist.id=" + id + " AND (assist.cid=" + cid + " OR " + cid + "=-1)";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                result = AssistPaymentManager.getPaymentFromRS(rs, true);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void updatePayment(AssistPayment payment) throws BGException {
        try {
            String query = "UPDATE assist_payment_" + this.mid + " SET cid=?, status=?, CARDHOLDER=?, COMMENT=?, EMAIL=?, NAME=?, IPADDRESS=?, CARDNUMBER=?, CARDTYPE=?, DATE=?, CARDSUBTYPE=?, TOTAL=?, BILLNUMBER=?, RESPONSE_CODE=?, recurringParentId=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, payment.getCid());
            ps.setInt(index++, payment.getStatus().getCode());
            ps.setString(index++, payment.getCardholder());
            ps.setString(index++, payment.getComment());
            ps.setString(index++, payment.getEmail());
            ps.setString(index++, payment.getName());
            ps.setString(index++, payment.getIpaddress());
            ps.setString(index++, payment.getCardnumber());
            ps.setString(index++, payment.getCardtype());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)payment.getDate()));
            ps.setString(index++, payment.getCardsubtype());
            ps.setBigDecimal(index++, payment.getTotal());
            ps.setLong(index++, payment.getBillnumber());
            ps.setString(index++, payment.getResponseCode() != null ? payment.getResponseCode().name() : null);
            ps.setInt(index++, payment.getRecurringParentId());
            ps.setInt(index++, payment.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void carryOutPayment(AssistPayment payment, Preferences moduleSetup) throws BGException {
        int paymentType = moduleSetup.getInt("assist.paymenttype", 0);
        String commentTemplate = moduleSetup.get("assist.payment_comment", DEFAULT_PAYMENT_COMMENT);
        if (payment != null && payment.getStatus() == AssistStatus.OK) {
            String comment = AssistUtils.getPaymentComment(this.con, commentTemplate, payment);
            Payment contractPayment = new Payment();
            contractPayment.setContractId(payment.getCid());
            contractPayment.setComment(comment);
            contractPayment.setSum(payment.getTotal());
            contractPayment.setDate(payment.getDate());
            contractPayment.setUserId(0);
            contractPayment.setTypeId(paymentType);
            try (PaymentDao paymentDao = new PaymentDao(this.con);){
                paymentDao.update((Object)contractPayment);
            }
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                Contract contract = (Contract)contractDao.get(payment.getCid());
                ServerUtils.commitConnection((Connection)this.con);
                try (BalanceUtils bu = new BalanceUtils(this.con);){
                    bu.updateBalance(payment.getDate(), contract);
                }
                ServerUtils.commitConnection((Connection)this.con);
                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, contractPayment));
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, contractPayment.getSum()));
            }
        }
    }

    public static AssistPayment getPaymentFromRS(ResultSet rs, boolean contractTitle) throws SQLException {
        AssistPayment payment = new AssistPayment();
        payment.setId(rs.getInt("id"));
        payment.setCid(rs.getInt("cid"));
        payment.setStatus((AssistStatus)Utils.getListItemEnumFromId(AssistStatus.class, (int)rs.getInt("status")));
        if (contractTitle) {
            payment.setContractTitle(rs.getString("title"));
            payment.setContractComment(rs.getString("con_comment"));
        }
        payment.setTotal(rs.getBigDecimal("TOTAL"));
        payment.setDate(rs.getTimestamp("DATE"));
        payment.setCardholder(rs.getString("CARDHOLDER"));
        payment.setComment(rs.getString("COMMENT"));
        payment.setEmail(rs.getString("EMAIL"));
        payment.setName(rs.getString("NAME"));
        payment.setIpaddress(rs.getString("IPADDRESS"));
        payment.setCardnumber(rs.getString("CARDNUMBER"));
        payment.setCardtype(rs.getString("CARDTYPE"));
        payment.setCardsubtype(rs.getString("CARDSUBTYPE"));
        payment.setBillnumber(rs.getLong("BILLNUMBER"));
        String RESPONSE_CODE = rs.getString("RESPONSE_CODE");
        payment.setResponseCode(RESPONSE_CODE != null ? AssistProtocolResponseCode.valueOf(RESPONSE_CODE) : null);
        payment.setRecurringParentId(rs.getInt("recurringParentId"));
        return payment;
    }

    public int getFirstYear(int cid) throws BGException {
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT MIN(DATE) FROM assist_payment_" + this.mid + " WHERE cid=" + cid);
            int result = (rs.next() && rs.getDate(1) != null ? TimeUtils.convertDateToCalendar((Date)rs.getDate(1)) : new GregorianCalendar()).get(1);
            rs.close();
            st.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public AssistPayment getLastRecurringForCid(int cid, int recurringParentId) throws BGException {
        AssistPayment result = null;
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(" SELECT * FROM assist_payment_" + this.mid + " WHERE cid=" + cid + " AND recurringParentId=" + recurringParentId + " AND (status=1 OR status=2) ORDER BY date DESC LIMIT 1");
            if (rs.next()) {
                result = AssistPaymentManager.getPaymentFromRS(rs, false);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

