/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.service;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.service.PaymentServiceProvider;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistStatus;
import ru.bitel.bgbilling.modules.assist.common.service.AssistService;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistShopMode;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.assist.common.service.AssistService")
public class AssistServiceImpl
extends AbstractService
implements AssistService,
PaymentServiceProvider {
    private static final String ACTION_TEST_URL = "https://test.paysecure.ru/pay/order.cfm";
    private static final String ACTION_URL = "https://payments.paysecure.ru/pay/order.cfm";

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        BigDecimal summ;
        if (contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (mode != null) {
            mode.value = "post";
        }
        if ((summ = amount).compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGIllegalArgumentException("amount.invalid");
        }
        String Merchant_ID = this.getModuleSetup().get("assist.Merchant_ID", null);
        String path = this.getModuleSetup().get("assist.path", null);
        String shopModeP = this.getModuleSetup().get("assist.ShopMode", "test");
        String actionUrl = this.getModuleSetup().get("assist.actionUrl", null);
        if (Utils.isBlankString((String)Merchant_ID) || Utils.isBlankString((String)path)) {
            throw new BGException("error assist config");
        }
        AssistShopMode shopMode = null;
        try {
            shopMode = AssistShopMode.valueOf(shopModeP);
        }
        catch (Exception e) {
            throw new BGException("error parameter assist.ShopMode");
        }
        BigDecimal RecurringMinAmount = this.getModuleSetup().getBigDecimal("assist.RecurringMinAmount", null);
        BigDecimal RecurringMaxAmount = this.getModuleSetup().getBigDecimal("assist.RecurringMaxAmount", null);
        int RecurringPeriod = this.getModuleSetup().getInt("assist.RecurringPeriod", -1);
        boolean RecurringAllowed = RecurringMinAmount != null && RecurringMaxAmount != null && RecurringPeriod != -1;
        AssistPaymentRecurringManager prm = new AssistPaymentRecurringManager(this.getConnection(), this.moduleId);
        AssistPaymentRecurring recurringAlreadyHas = prm.getRecurringForCid(contractId);
        if (recurringAlreadyHas != null) {
            RecurringAllowed = false;
        }
        AssistPaymentManager pm = new AssistPaymentManager(this.getConnection(), this.moduleId);
        int id = pm.addPayment(contractId, summ, 0);
        Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
        Object successUrl = (String)params.get("successUrl");
        Object failureUrl = (String)params.get("failureUrl");
        if (Utils.isBlankString((String)successUrl)) {
            successUrl = path + "&result=" + AssistStatus.OK;
        }
        if (Utils.isBlankString((String)failureUrl)) {
            failureUrl = path + "&result=" + AssistStatus.FAIL;
        }
        url.value = actionUrl != null ? actionUrl : (shopMode == AssistShopMode.test ? ACTION_TEST_URL : ACTION_URL);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("Merchant_ID", Merchant_ID);
        dataMap.put("OrderNumber", String.valueOf(id));
        dataMap.put("OrderAmount", summ.toPlainString());
        dataMap.put("OrderComment", AssistUtils.getPaymentDesc(this.getConnection(), this.getModuleSetup().get("assist.OrderComment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433. ${contract} (${contract_comment})"), contractId));
        dataMap.put("URL_RETURN_OK", successUrl);
        dataMap.put("URL_RETURN_NO", failureUrl);
        dataMap.put("Delay", this.getModuleSetup().get("assist.Delay", null));
        dataMap.put("CardPayment", this.getModuleSetup().get("assist.CardPayment", null));
        dataMap.put("WMPayment", this.getModuleSetup().get("assist.WMPayment", null));
        dataMap.put("YMPayment", this.getModuleSetup().get("assist.YMPayment", null));
        dataMap.put("QIWIPayment", this.getModuleSetup().get("assist.QIWIPayment", null));
        dataMap.put("QIWIMtsPayment", this.getModuleSetup().get("assist.QIWIMtsPayment", null));
        dataMap.put("QIWIMegafonPayment", this.getModuleSetup().get("assist.QIWIMegafonPayment", null));
        dataMap.put("QIWIBeelinePayment", this.getModuleSetup().get("assist.QIWIBeelinePayment", null));
        dataMap.put("AssistIDPayment", this.getModuleSetup().get("assist.AssistIDPayment", null));
        if (shopMode == AssistShopMode.battletest || shopMode == AssistShopMode.test) {
            dataMap.put("TestMode", "1");
        }
        dataMap.put("RecurringIndicator", "0");
        if (RecurringAllowed) {
            boolean recurringCheckbox = Utils.parseInt((String)((String)params.get("recurring")), (int)0) > 0;
            String RecurringMaxDate = Utils.maskNull((String)((String)params.get("recurringMaxDate")));
            Date dRecurringMaxDate = TimeUtils.parseDate((String)RecurringMaxDate, (String)"yyyy-MM-dd");
            if (dRecurringMaxDate == null) {
                dRecurringMaxDate = new Date(0L);
            }
            if (recurringCheckbox) {
                dataMap.put("RecurringIndicator", "1");
                dataMap.put("RecurringMinAmount", RecurringMinAmount.toPlainString());
                dataMap.put("RecurringMaxAmount", RecurringMaxAmount.toPlainString());
                dataMap.put("RecurringPeriod", String.valueOf(RecurringPeriod));
                dataMap.put("RecurringMaxDate", RecurringMaxDate);
                AssistPaymentRecurring pr = new AssistPaymentRecurring();
                pr.setCid(contractId);
                pr.setDate(new Date());
                pr.setAmount(summ);
                pr.setOrdernumber(id);
                pr.setRecurringMinAmount(RecurringMinAmount);
                pr.setRecurringMaxAmount(RecurringMaxAmount);
                pr.setRecurringPeriod(RecurringPeriod);
                pr.setRecurringMaxDate(dRecurringMaxDate);
                prm.add(pr);
            }
        }
        if (paramsHolder != null) {
            paramsHolder.value = new MapHolder(dataMap);
        }
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
    }

    public List<AssistPaymentRecurring> getRecurringList() throws BGException {
        return new AssistPaymentRecurringManager(this.getConnection(), this.moduleId).getRecurringList(-1);
    }
}

