/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistStatus;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPayment;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistUtils;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestPaymentResult;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransfer;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransferException;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.util.DebugUtils;

@WebServlet(name="AssistExecutor", urlPatterns={"/assistexecuter/*"})
public class ModuleExecuter
extends HttpServlet {
    protected Setup setup;
    private static final Logger logger = LogManager.getLogger();

    public void init() {
        this.setup = Setup.getSetup();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new IllegalAccessError("HTTP-GET-requests can not be!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int mid = Utils.parseInt((String)request.getParameter("mid"));
        if (mid <= 0) {
            ModuleExecuter.doReply(null, response, 1, 0);
            logger.error("parameter mid required!");
            return;
        }
        AssistProtocolRequestPaymentResult paymentRequest = null;
        try {
            paymentRequest = AssistProtocolTransfer.parseRequestSoapServlet((InputStream)request.getInputStream());
        }
        catch (AssistProtocolTransferException e) {
            ModuleExecuter.doReply(null, response, 1, 0);
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043e\u0442\u0432\u0435\u0442\u0430", (Throwable)e);
            return;
        }
        logger.debug("get request : " + DebugUtils.dumpObject((Object)paymentRequest));
        Connection con = null;
        try {
            con = this.setup.getDBConnectionFromPool();
            ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(mid));
            AssistPaymentManager amanager = new AssistPaymentManager(con, mid);
            AssistPaymentRecurringManager prmanager = new AssistPaymentRecurringManager(con, mid);
            int ordernumber = paymentRequest.getOrder().getOrdernumber();
            AssistPayment paymentDB = amanager.getPayment(-1, ordernumber);
            if (paymentDB == null) {
                logger.error("\u041e\u0448\u0438\u0431\u043a\u0430: \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (\u0437\u0430\u043a\u0430\u0437\u0430) #" + ordernumber + " \u043d\u0435\u0442 \u0432 \u0431\u0430\u0437\u0435");
                ModuleExecuter.doReply(null, response, 5, 107);
                return;
            }
            if (paymentRequest.getOperation().getResponsecode().isSuccessful()) {
                Object message;
                boolean needPayment;
                boolean bl = needPayment = paymentDB.getStatus() == AssistStatus.FAIL || paymentDB.getStatus() == AssistStatus.NEW;
                if (paymentDB.getStatus() == AssistStatus.FAIL) {
                    message = "Assist: \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u044b\u0439: " + paymentDB.getStatus() + "/" + (paymentDB.getResponseCode() != null ? paymentDB.getResponseCode().toString() : "?") + ", \u043d\u043e \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439: " + paymentRequest.getOperation().getResponsecode();
                    logger.warn((String)message);
                }
                AssistUtils.fillPayment(paymentDB, paymentRequest.getOrder(), paymentRequest.getOperation());
                paymentDB.setStatus(AssistStatus.OK);
                amanager.updatePayment(paymentDB);
                if (needPayment) {
                    amanager.carryOutPayment(paymentDB, (Preferences)moduleSetup);
                }
                message = needPayment ? "\u0412 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u0431\u044b\u043b \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d \u043f\u043b\u0430\u0442\u0451\u0436!\n" : "\u041f\u043b\u0430\u0442\u0451\u0436 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d \u041d\u0415 \u0431\u044b\u043b (\u043e\u043d \u0443\u0436\u0435 \u0431\u044b\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d)!\n";
                logger.info("\u0421\u0442\u0430\u0442\u0443\u0441: \u0443\u0441\u043f\u0435\u0448\u043d\u043e, " + (paymentDB.getRecurringParentId() > 0 ? "\u0410\u0412\u0422\u041e" : "") + "\u043f\u043b\u0430\u0442\u0451\u0436 #" + ordernumber + ", billnumber: " + paymentDB.getBillnumber() + ", \u043f\u043e\u0441\u0442\u0443\u043f\u0438\u0432\u0448\u0430\u044f \u0441\u0443\u043c\u043c\u0430: " + paymentDB.getTotal().toPlainString() + "; " + (String)message);
                if (prmanager.updateBillnumber(ordernumber, paymentDB.getCid(), paymentDB.getBillnumber())) {
                    logger.info("\u042d\u0442\u0438\u043c \u043f\u043b\u0430\u0442\u0435\u0436\u043e\u043c \u0431\u044b\u043b \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0451\u0436!");
                }
            } else if (paymentRequest.getOperation().getResponsecode().isUnsuccessful()) {
                if (paymentDB.getStatus() == AssistStatus.OK) {
                    String message = "Assist: \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439: " + paymentDB.getStatus() + ", \u043d\u043e \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0435\u0443\u0434\u0430\u0447\u0435\u043d: " + paymentRequest.getOperation().getResponsecode();
                    logger.error(message);
                } else {
                    AssistUtils.fillPayment(paymentDB, paymentRequest.getOrder(), paymentRequest.getOperation());
                    paymentDB.setStatus(AssistStatus.FAIL);
                    amanager.updatePayment(paymentDB);
                    logger.info("\u0421\u0442\u0430\u0442\u0443\u0441: \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e, " + (paymentDB.getRecurringParentId() > 0 ? "\u0410\u0412\u0422\u041e" : "") + "\u043f\u043b\u0430\u0442\u0451\u0436 #" + ordernumber + ". \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 (responsecode): " + paymentRequest.getOperation().getResponsecode() + ", \u0442\u043e\u043b\u043a\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0434\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 (recommendation): " + paymentRequest.getOperation().getRecommendation() + ", ");
                }
            } else if (paymentDB.getStatus() != AssistStatus.NEW) {
                String message = "Assist: \u041e\u0448\u0438\u0431\u043a\u0430! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d: " + paymentDB.getStatus() + ", \u043d\u043e \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u044b\u0439: " + paymentRequest.getOperation().getResponsecode();
                logger.warn(message);
            } else {
                AssistUtils.fillPayment(paymentDB, paymentRequest.getOrder(), paymentRequest.getOperation());
                amanager.updatePayment(paymentDB);
            }
            ModuleExecuter.doReply(paymentRequest, response, 0, 0);
        }
        catch (Exception e) {
            logger.error("error do post", (Throwable)e);
            ModuleExecuter.doReply(null, response, 1, 0);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public static void doReply(AssistProtocolRequestPaymentResult paymentRequest, HttpServletResponse response, int firstcode, int secondcode) throws IOException {
        PrintWriter out = response.getWriter();
        AssistProtocolTransfer.doReply(paymentRequest, out, firstcode, secondcode);
        out.flush();
        out.close();
        logger.debug("do reply firstcode=" + firstcode + ",secondcode=" + secondcode);
    }
}

