/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.assistant.client.admin.AssistantListCellRenderer;
import ru.bitel.bgbilling.plugins.assistant.client.admin.EditorPanel;
import ru.bitel.bgbilling.plugins.assistant.client.admin.ExportAssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.client.admin.ImportAssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.common.client.AbstractBGUPanel;

public class AssistantMastersTab
extends BGUPanel {
    private AssistantService assistantService = null;
    private DefaultListModel<AssistantActionItem> listModel = new DefaultListModel();
    protected JList<AssistantActionItem> actionList = new JList<AssistantActionItem>(this.listModel);
    private EditorPanel editorPanel = new EditorPanel(this);
    private List<AssistantActionItem> assistantActionList;
    private boolean dependedIsVisible = false;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", ""){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            AssistantActionItem currentItem = AssistantMastersTab.this.actionList.getSelectedValue();
            AssistantMastersTab.this.listModel = new DefaultListModel();
            AssistantMastersTab.this.assistantActionList = AssistantMastersTab.this.getAssistantService().assistantActions();
            Comparator<AssistantActionItem> comparator = Comparator.comparing(AssistantActionItem::getSort);
            AssistantMastersTab.this.assistantActionList.sort(comparator);
            AssistantMastersTab.this.assistantActionList.forEach(i -> AssistantMastersTab.this.listModel.addElement((AssistantActionItem)i));
            AssistantMastersTab.this.actionList.setModel(AssistantMastersTab.this.listModel);
            if (currentItem != null) {
                int currentItemId = currentItem.getId();
                ClientUtils.setListSelection(AssistantMastersTab.this.actionList, (int)currentItemId);
            }
        }
    };
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("new", ""){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            AssistantMastersTab.this.actionList.setEnabled(false);
            AssistantMastersTab.this.editorPanel.setAssistantAction(new AssistantAction(), AssistantMastersTab.this.getAssistantService().getInterfaceName(), AssistantMastersTab.this.getAssistantService().getSuperclassName());
            AssistantMastersTab.this.editorPanel.performAction("refresh");
            AssistantMastersTab.this.editorPanel.setVisible(true);
        }
    };
    AbstractBGUPanel.DefaultAction editAction = new AbstractBGUPanel.DefaultAction("edit", ""){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            AssistantActionItem assistantActionItem = AssistantMastersTab.this.actionList.getSelectedValue();
            if (assistantActionItem != null) {
                AssistantMastersTab.this.actionList.setEnabled(false);
                AssistantMastersTab.this.editorPanel.setAssistantAction(AssistantMastersTab.this.getAssistantService().getAssistantAction(assistantActionItem.getId()), AssistantMastersTab.this.getAssistantService().getInterfaceName(), AssistantMastersTab.this.getAssistantService().getSuperclassName());
                AssistantMastersTab.this.editorPanel.setVisible(true);
            }
        }
    };
    AbstractBGUPanel.DefaultAction deleteAction = new AbstractBGUPanel.DefaultAction("delete", ""){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            AssistantActionItem assistantActionItem = AssistantMastersTab.this.actionList.getSelectedValue();
            if (assistantActionItem != null && ClientUtils.confirmDelete((Object)assistantActionItem.getTitle())) {
                AssistantMastersTab.this.getAssistantService().deleteAssistantAction(assistantActionItem.getId());
                AssistantMastersTab.this.performAction("refresh");
            }
        }
    };

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.getLeftPanel(), (Component)this.getRightPanel(), 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getLeftPanel() {
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem addItem = new JMenuItem("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        addItem.addActionListener(e -> this.performAction("new"));
        JMenuItem editItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        editItem.addActionListener(e -> this.performAction("edit"));
        JMenuItem deleteItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        deleteItem.addActionListener(e -> this.performAction("delete"));
        JMenuItem hideDependent = new JMenuItem("\u0421\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435");
        hideDependent.addActionListener(e -> {
            DefaultListModel<AssistantActionItem> dependentListModel = new DefaultListModel<AssistantActionItem>();
            if (this.dependedIsVisible) {
                this.actionList.setModel(this.listModel);
                hideDependent.setText("\u0421\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435");
                this.dependedIsVisible = false;
            } else {
                for (AssistantActionItem actionItem : this.assistantActionList) {
                    if (actionItem.isDependent()) continue;
                    dependentListModel.addElement(actionItem);
                    this.actionList.setModel(dependentListModel);
                    hideDependent.setText("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435");
                }
                this.dependedIsVisible = true;
            }
        });
        JMenuItem importMaster = new JMenuItem("\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        importMaster.addActionListener(e -> new ImportAssistantMaster((ClientContext)this.getContext(), this));
        JMenuItem exportMaster = new JMenuItem("\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        exportMaster.addActionListener(e -> {
            try {
                new ExportAssistantMaster((ClientContext)this.getContext(), this.assistantActionList, this);
            }
            catch (IOException | BGException ex) {
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
        });
        popupMenu.add(addItem);
        popupMenu.add(editItem);
        popupMenu.add(deleteItem);
        popupMenu.add(exportMaster);
        popupMenu.add(importMaster);
        popupMenu.add(hideDependent);
        this.actionList.setSelectionMode(0);
        this.actionList.setCellRenderer(new AssistantListCellRenderer());
        this.actionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (AssistantMastersTab.this.actionList.isEnabled()) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                        AssistantActionItem assistantActionItem = AssistantMastersTab.this.actionList.getSelectedValue();
                        if (assistantActionItem != null) {
                            AssistantMastersTab.this.performAction("edit");
                        }
                    } else if (SwingUtilities.isRightMouseButton(mouseEvent) && AssistantMastersTab.this.actionList.getSelectedValue() != null) {
                        for (int x = 1; x < popupMenu.getComponents().length - 1; ++x) {
                            popupMenu.getComponent(x).setVisible(true);
                        }
                        popupMenu.show(AssistantMastersTab.this.actionList, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getButton() == 3) {
                        for (int x = 1; x < popupMenu.getComponents().length - 3; ++x) {
                            popupMenu.getComponent(x).setVisible(false);
                        }
                        popupMenu.show(AssistantMastersTab.this.actionList, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.actionList.setDragEnabled(true);
        this.actionList.setDropMode(DropMode.INSERT);
        this.actionList.setTransferHandler(new AssistantMasterTabTransferHandler());
        int gridy = 0;
        JPanel titleList = new JPanel(new GridBagLayout());
        JLabel helpLabel = new JLabel("(\u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0440\u044f\u0434\u043a\u0430, \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0430\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0438)");
        helpLabel.setFont(new Font("Monospaced", 0, 10));
        helpLabel.setForeground(Color.GRAY);
        titleList.add((Component)new JLabel("\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439"), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        titleList.add((Component)helpLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)titleList, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        leftPanel.add((Component)new JScrollPane(this.actionList), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return leftPanel;
    }

    private JPanel getRightPanel() {
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                AssistantMastersTab.this.actionList.setEnabled(true);
                AssistantAction assistantAction = AssistantMastersTab.this.editorPanel.getAssistantAction();
                if (assistantAction != null) {
                    try {
                        AssistantMastersTab.this.getAssistantService().updateAssistantAction(assistantAction);
                        AssistantMastersTab.this.performAction("refresh");
                    }
                    catch (BGException e1) {
                        ClientUtils.showErrorMessageDialog((Throwable)e1);
                    }
                }
            }
        });
        this.editorPanel.setVisible(false);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)this.editorPanel), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private AssistantService getAssistantService() {
        if (this.assistantService == null) {
            this.assistantService = (AssistantService)((ClientContext)this.getContext()).getPort(AssistantService.class);
        }
        return this.assistantService;
    }

    private void reorder(int nextIndex, TransferHandler.TransferSupport info) {
        int topPoint;
        int selectedIndex = ((JList)info.getComponent()).getSelectedIndex();
        int oldPosition = this.listModel.get(selectedIndex).getSort();
        if (nextIndex < selectedIndex) {
            topPoint = nextIndex;
            this.listModel.get(selectedIndex).setSort(this.listModel.get(topPoint).getSort());
            for (int x = topPoint; x < selectedIndex; ++x) {
                if (topPoint - selectedIndex >= 0) continue;
                AssistantActionItem first = this.listModel.get(x);
                AssistantActionItem second = this.listModel.get(x + 1);
                if (x == selectedIndex) continue;
                if (x + 1 == selectedIndex) {
                    first.setSort(oldPosition);
                    continue;
                }
                first.setSort(second.getSort());
            }
        } else {
            int endPosition = --nextIndex;
            topPoint = selectedIndex;
            this.listModel.get(selectedIndex).setSort(this.listModel.get(nextIndex).getSort());
            for (int x = endPosition; x > topPoint; --x) {
                AssistantActionItem first = this.listModel.get(x);
                AssistantActionItem second = this.listModel.get(x - 1);
                if (x == selectedIndex) continue;
                if (x - 1 == selectedIndex) {
                    first.setSort(oldPosition);
                    continue;
                }
                first.setSort(second.getSort());
            }
        }
        try {
            ArrayList<AssistantActionItem> updatedActionItems = new ArrayList<AssistantActionItem>();
            for (int x = 0; x < this.listModel.getSize(); ++x) {
                updatedActionItems.add(this.listModel.get(x));
            }
            this.getAssistantService().updateSortListAssistantAction(updatedActionItems);
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    class AssistantMasterTabTransferHandler
    extends TransferHandler {
        protected final DataFlavor dataFlavor = new DataFlavor(Object[].class, "Object Row Index");
        protected int[] indices;
        protected int nextIndex = -1;
        protected int addCount;

        AssistantMasterTabTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            Component pane = c.getRootPane().getGlassPane();
            pane.setCursor(DragSource.DefaultMoveDrop);
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            JList source = (JList)component;
            component.getRootPane().getGlassPane().setVisible(true);
            this.indices = source.getSelectedIndices();
            final AssistantActionItem[] transferedObjects = source.getSelectedValuesList().toArray(new AssistantActionItem[0]);
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{AssistantMasterTabTransferHandler.this.dataFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return Objects.equals(AssistantMasterTabTransferHandler.this.dataFlavor, flavor);
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (this.isDataFlavorSupported(flavor)) {
                        return transferedObjects;
                    }
                    throw new UnsupportedFlavorException(flavor);
                }
            };
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDrop() && support.isDataFlavorSupported(this.dataFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            TransferHandler.DropLocation infoDropLocation = info.getDropLocation();
            if (!this.canImport(info) || !(infoDropLocation instanceof JList.DropLocation)) {
                return false;
            }
            JList.DropLocation dropLocation = (JList.DropLocation)infoDropLocation;
            JList target = (JList)info.getComponent();
            DefaultListModel listModel = (DefaultListModel)target.getModel();
            int index = dropLocation.getIndex();
            int maxCount = listModel.getSize();
            if (index < 0 || index > maxCount) {
                index = maxCount;
            }
            this.nextIndex = index;
            AssistantMastersTab.this.reorder(this.nextIndex, info);
            try {
                AssistantActionItem[] values = (AssistantActionItem[])info.getTransferable().getTransferData(this.dataFlavor);
                for (int i = 0; i < values.length; ++i) {
                    int idx = index++;
                    listModel.add(idx, values[i]);
                    target.addSelectionInterval(idx, idx);
                }
                this.addCount = values.length;
                return true;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            source.getRootPane().getGlassPane().setVisible(false);
            this.cleanup(source, action == 2);
        }

        private void cleanup(JComponent c, boolean remove) {
            if (remove && Objects.nonNull(this.indices)) {
                if (this.addCount > 0) {
                    for (int i = 0; i < this.indices.length; ++i) {
                        if (this.indices[i] < this.nextIndex) continue;
                        int n = i;
                        this.indices[n] = this.indices[n] + this.addCount;
                    }
                }
                JList source = (JList)c;
                DefaultListModel model = (DefaultListModel)source.getModel();
                for (int i = this.indices.length - 1; i >= 0; --i) {
                    model.remove(this.indices[i]);
                }
            }
            this.indices = null;
            this.addCount = 0;
            this.nextIndex = -1;
        }
    }
}

