/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.service;

import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantButton;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantKeyValue;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantActionBase;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantDao;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantRequest;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantResponse;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantResponseStatus;
import ru.bitel.bgbilling.plugins.assistant.server.event.AssistantActionsListEvent;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService")
public class AssistantServiceImpl
extends AbstractService
implements AssistantService {
    private Logger log = LogManager.getLogger();

    public List<AssistantActionItem> assistantActions() throws BGException, BGMessageException {
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            List<AssistantActionItem> list = assistantDao.assistantAstions();
            return list;
        }
    }

    public List<AssistantActionItem> assistantActionsForUser(int contractId) throws BGException, BGMessageException {
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            List<AssistantActionItem> assistantActionItemsIn = assistantDao.assistantAstions(this.userId);
            AssistantActionsListEvent event = new AssistantActionsListEvent(contractId, assistantActionItemsIn);
            List<AssistantActionItem> assistantActionItemsOut = ((AssistantActionsListEvent)EventProcessor.getInstance().request((QueueEvent)event)).getAssistantActionItems();
            List<AssistantActionItem> list = assistantActionItemsOut != null ? assistantActionItemsOut : assistantActionItemsIn;
            return list;
        }
    }

    public AssistantAction getAssistantAction(int id) throws BGException, BGMessageException {
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            AssistantAction assistantAction = assistantDao.get(id);
            return assistantAction;
        }
    }

    public void updateAssistantAction(AssistantAction assistantAction) throws BGException, BGMessageException {
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            assistantDao.update(assistantAction);
        }
    }

    public AssistantAction getAssistantActionByActionId(String actionId) throws BGException, BGMessageException {
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            AssistantAction assistantAction = assistantDao.getByActionId(actionId);
            return assistantAction;
        }
    }

    public String getInterfaceName() {
        return ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction.class.getName();
    }

    public String getSuperclassName() {
        return AssistantActionBase.class.getName();
    }

    public String doShow(String actionId, String data) throws BGException, BGMessageException {
        Map<String, Object> fieldValues;
        AssistantAction assistantAction = null;
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            assistantAction = assistantDao.getByActionId(actionId);
        }
        AssistantResponse assistantResponse = new AssistantResponse();
        if (assistantAction != null) {
            String actionClassName = assistantAction.getActionClass();
            if (Utils.notBlankString((String)actionClassName)) {
                try {
                    AssistantRequest assistantRequest = new AssistantRequest(assistantAction, data);
                    ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction action = DynamicClassManager.getInstance().loadClass(actionClassName).asSubclass(ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (action instanceof AssistantActionBase) {
                        ((AssistantActionBase)action).setOutputStream(System.out);
                        ((AssistantActionBase)action).setErrorStream(System.err);
                    }
                    assistantResponse = action.showAction(assistantRequest);
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    throw new BGException((Throwable)e);
                }
                if (assistantResponse == null) {
                    throw new BGMessageException("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0432\u0435\u0440\u043d\u0443\u043b assistantResponse = null");
                }
            }
            if (assistantResponse.getNextActionId() == null) {
                assistantResponse.setNextActionId(this.getDefaultNextActionId(assistantAction.getConfig()));
            }
        } else {
            assistantResponse.setStatus(AssistantResponseStatus.ERROR);
            assistantResponse.setError("Action with actionId='" + actionId + "' not found.");
        }
        JSONObject resultJsonObject = new JSONObject();
        resultJsonObject.put("status", (Object)assistantResponse.getStatus().getCode());
        if (AssistantResponseStatus.OK.equals((Object)assistantResponse.getStatus()) && (fieldValues = assistantResponse.getFieldValues()) != null && !assistantResponse.getFieldValues().isEmpty()) {
            JSONObject fieldsJsonObject = new JSONObject();
            for (String key : fieldValues.keySet()) {
                Object fieldValue = fieldValues.get(key);
                if (fieldValue instanceof AssistantKeyValue[]) {
                    AssistantKeyValue[] assistantKeyValues = (AssistantKeyValue[])fieldValue;
                    JSONArray array = new JSONArray();
                    for (int index = 0; index < assistantKeyValues.length; ++index) {
                        JSONObject item = new JSONObject();
                        item.put("key", (Object)assistantKeyValues[index].getKey());
                        item.put("value", (Object)assistantKeyValues[index].getValue());
                        array.put((Object)item);
                    }
                    fieldsJsonObject.put(key, (Object)array);
                    continue;
                }
                if (fieldValue instanceof String) {
                    fieldsJsonObject.put(key, (Object)((String)fieldValue));
                    continue;
                }
                if (!(fieldValue instanceof JSONObject)) continue;
                fieldsJsonObject.put(key, (Object)((JSONObject)fieldValue));
            }
            resultJsonObject.put("fieldValues", (Object)fieldsJsonObject);
        }
        return resultJsonObject.toString();
    }

    public String doButton(String actionId, String data, String button) throws BGException, BGMessageException {
        AssistantAction assistantAction = null;
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            assistantAction = assistantDao.getByActionId(actionId);
        }
        AssistantResponse assistantResponse = new AssistantResponse();
        if (assistantAction != null) {
            String actionClassName = assistantAction.getActionClass();
            if (actionClassName != null) {
                try {
                    AssistantRequest assistantRequest = new AssistantRequest(assistantAction, data, AssistantButton.getAssistantButtonByCode((String)button));
                    ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction action = DynamicClassManager.getInstance().loadClass(actionClassName).asSubclass(ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (action instanceof AssistantActionBase) {
                        ((AssistantActionBase)action).setOutputStream(System.out);
                        ((AssistantActionBase)action).setErrorStream(System.err);
                    }
                    assistantResponse = action.doAction(assistantRequest);
                }
                catch (BGMessageException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    this.log.error((Object)ex);
                    throw new BGException((Throwable)ex);
                }
                if (assistantResponse == null) {
                    throw new BGMessageException("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0432\u0435\u0440\u043d\u0443\u043b assistantResponse = null");
                }
            }
            if (assistantResponse.getNextActionId() == null) {
                assistantResponse.setNextActionId(this.getDefaultNextActionId(assistantAction.getConfig()));
            }
        } else {
            assistantResponse.setStatus(AssistantResponseStatus.ERROR);
            assistantResponse.setError("Action with actionId='" + actionId + "' not found.");
        }
        JSONObject resultJsonObject = new JSONObject();
        Map<String, Object> fieldValues = assistantResponse.getFieldValues();
        if (fieldValues.size() > 0) {
            JSONObject fields = new JSONObject();
            fieldValues.forEach((arg_0, arg_1) -> ((JSONObject)fields).put(arg_0, arg_1));
            resultJsonObject.put("fields", (Object)fields);
        }
        resultJsonObject.put("status", (Object)assistantResponse.getStatus().getCode());
        if (AssistantResponseStatus.OK.equals((Object)assistantResponse.getStatus())) {
            if (assistantResponse.getNextActionId() != null) {
                resultJsonObject.put("nextActionId", (Object)assistantResponse.getNextActionId());
            }
        } else {
            resultJsonObject.put("error", (Object)assistantResponse.getError());
            resultJsonObject.put("errorTitle", (Object)assistantResponse.getErrorTitle());
        }
        return resultJsonObject.toString();
    }

    private String getDefaultNextActionId(String configData) {
        JSONObject config;
        JSONObject optionsJsonObject;
        String nextActionId = null;
        if (configData != null && (optionsJsonObject = (config = new JSONObject(configData)).optJSONObject("options")) != null && optionsJsonObject.has("nextActionId")) {
            nextActionId = optionsJsonObject.optString("nextActionId");
        }
        return nextActionId;
    }

    public void deleteAssistantAction(int assistantActionId) throws BGException, BGMessageException {
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            assistantDao.delete(assistantActionId);
        }
    }

    public void updateSortListAssistantAction(List<AssistantActionItem> assistantActions) throws BGException, BGMessageException {
        try (AssistantDao assistantDao = new AssistantDao(this.getConnection());){
            assistantDao.updateSortListAssistantAction(assistantActions);
        }
    }
}

