/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bvcom.server.servlet;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.Date;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.bvcom.common.bean.Transaction;
import ru.bitel.bgbilling.modules.bvcom.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.bvcom.common.service.BVComService;
import ru.bitel.bgbilling.modules.bvcom.server.bean.BVParams;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.util.DebugUtils;
import ru.bitel.common.worker.ThreadContext;

@WebServlet(name="BVComExecuter", urlPatterns={"/bvcomexecuter/*"})
public class ModuleExecuter
extends CommonExecutor {
    private static Logger log = LogManager.getLogger();
    private static final Pattern slashPattern = Pattern.compile("/");
    private BVParams params;
    private BVComService service;
    private int mid = -1;
    private String pathInfo = null;

    public void init() {
        log.info("Initialization of BVcomExecuter");
        this.setup = Setup.getSetup();
        System.getProperties().setProperty("networkaddress.cache.ttl", "3600");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043e\u0442 BVCom/Arius");
        }
        this.pathInfo = request.getPathInfo();
        if (this.pathInfo != null) {
            String[] inParams;
            if (log.isDebugEnabled()) {
                log.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 mid \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                log.debug("PathInfo: " + this.pathInfo);
            }
            if (Utils.parseInt((String)(inParams = slashPattern.split(this.pathInfo))[inParams.length - 1]) > 0) {
                this.mid = Utils.parseInt((String)inParams[inParams.length - 1]);
                if (log.isDebugEnabled()) {
                    log.debug("mid: " + this.mid);
                }
            } else {
                log.error("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d mid. PathInfo: " + this.pathInfo);
            }
        }
        ServerContext context = new ServerContext(this.setup, this.mid, -1);
        ThreadContext parentContext = ThreadContext.push((ThreadContext)context);
        try {
            this.params = new BVParams(Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid)));
            try {
                this.service = (BVComService)context.newService(BVComService.class, this.mid);
            }
            catch (BGException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            int protocolVersion = this.params.getProtocolVersion();
            switch (protocolVersion) {
                case 1: {
                    this.doProtocolv1(request, response, context.getConnection());
                    break;
                }
                case 2: {
                    this.doProtocolv2(request, response, context.getConnection());
                    break;
                }
                case 3: {
                    this.doProtocolv3(request, response, context.getConnection());
                }
            }
            context.commit();
        }
        catch (BGException e) {
            log.error(e.getMessage());
        }
        finally {
            ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
        }
    }

    protected void service(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doPost(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProtocolv1(HttpServletRequest request, HttpServletResponse response, Connection con) {
        block28: {
            if (log.isInfoEnabled()) {
                log.info("Process v1 protocol");
            }
            ServerUtils.addNoCache((HttpServletResponse)response);
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid));
            try {
                ServletOutputStream out = response.getOutputStream();
                log.info("Get request parameters...");
                String transactionNumber = request.getParameter("number");
                String transactionAmount = request.getParameter("amount");
                String transactionStatus = request.getParameter("status");
                String sign = request.getParameter("sign");
                log.info("incoming params: transactionNumber=" + transactionNumber + ", amount=" + transactionAmount + ", status=" + transactionStatus + ", sign=" + sign);
                if (Utils.isBlankString((String)transactionNumber) || Utils.isBlankString((String)transactionAmount) || Utils.isBlankString((String)transactionStatus) || Utils.isBlankString((String)sign)) {
                    log.error("Not all params defined");
                    out.write("Error: not defined param 'number', 'amount', 'status' or 'sign'".getBytes("ISO8859-1"));
                    break block28;
                }
                log.info("Checking sign...");
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.update(transactionNumber.getBytes("ISO8859-1"));
                digest.update(new String("|").getBytes("ISO8859-1"));
                digest.update(transactionAmount.getBytes("ISO8859-1"));
                digest.update(new String("|").getBytes("ISO8859-1"));
                digest.update(transactionStatus.getBytes("ISO8859-1"));
                digest.update(new String("|").getBytes("ISO8859-1"));
                digest.update(this.params.getKey().getBytes("ISO8859-1"));
                String signValue = Utils.bytesToHexString((byte[])digest.digest()).toLowerCase();
                if (!signValue.equals(sign)) {
                    log.error("Incorrect sign");
                    out.write("Error: incorrect sign".getBytes("ISO8859-1"));
                    break block28;
                }
                try (BalanceUtils bu = new BalanceUtils(con);){
                    int id = this.params.getTransactionFormat().parse(transactionNumber).intValue();
                    Transaction transaction = this.service.getTransaction(id);
                    if (transaction == null) {
                        log.error("Transaction not found " + id);
                        out.write("Error: transaction not found".getBytes("ISO8859-1"));
                    } else {
                        log.info("Sending answer to BVCom/Arius...");
                        if (transaction.getStatus().equals(TransactionStatus.CREATED.getCode())) {
                            transaction.setSum(Utils.parseBigDecimal((String)transactionAmount, (BigDecimal)BigDecimal.ZERO));
                            transaction.setTransactionDate(new Date());
                            if ("approved".equals(transactionStatus)) {
                                transaction.setStatus(TransactionStatus.APPROVED.getCode());
                                out.write("OK".getBytes());
                            } else if ("canceled".equals(transactionStatus)) {
                                transaction.setStatus(TransactionStatus.CANCELED.getCode());
                                out.write("OK".getBytes());
                            } else if ("declined".equals(transactionStatus)) {
                                transaction.setStatus(TransactionStatus.DECLINED.getCode());
                                out.write("OK".getBytes());
                            } else if ("error".equals(transactionStatus)) {
                                transaction.setStatus(TransactionStatus.ERROR.getCode());
                            } else {
                                transaction.setStatus(TransactionStatus.ERROR.getCode());
                                log.error("Incorrect status " + transactionStatus);
                                out.write("Error: incorrect status".getBytes("ISO8859-1"));
                            }
                            this.service.updateTransaction(transaction);
                            if (transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                                if (log.isInfoEnabled()) {
                                    log.info("Processing payment ( transaction " + transaction.getId() + ")");
                                }
                                Payment payment = new Payment();
                                payment.setContractId(transaction.getContractId());
                                payment.setSum(transaction.getSum());
                                payment.setDate(transaction.getTransactionDate());
                                payment.setTypeId(this.params.getPaymentTypeId());
                                payment.setComment(moduleSetup.get("bvcom.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 BVCom, \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f: {TRANSACTION_ID}").replace("{TRANSACTION_ID}", transactionNumber));
                                PaymentDao paymentDao = new PaymentDao(con);
                                paymentDao.update((Object)payment);
                                paymentDao.close();
                                ServerUtils.commitConnection((Connection)con);
                                bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                                EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
                                EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    out.write(("Error: " + e.getMessage()).getBytes("ISO8859-1"));
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void doProtocolv2(HttpServletRequest request, HttpServletResponse response, Connection con) {
        if (log.isDebugEnabled()) {
            log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0432\u0435\u0440\u0441\u0438\u0438 2");
        }
        ServerUtils.addNoCache((HttpServletResponse)response);
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid));
        try (BalanceUtils bu = new BalanceUtils(con);){
            ServletOutputStream out = response.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
            }
            String transactionStatus = request.getParameter("status");
            String transactionOrderId = request.getParameter("orderid");
            String transactionClientOrderId = request.getParameter("client_orderid");
            String transactionControl = request.getParameter("control");
            if (log.isDebugEnabled()) {
                log.debug(String.format("status = %s; orderid = %s; client_orderid = %s; control = %s", transactionStatus, transactionOrderId, transactionClientOrderId, transactionControl));
            }
            int transactionId = this.params.getTransactionFormat().parse(transactionClientOrderId).intValue();
            if (log.isDebugEnabled()) {
                log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
            }
            MessageDigest hash = MessageDigest.getInstance("SHA-1");
            hash.update(transactionStatus.getBytes());
            hash.update(transactionOrderId.getBytes());
            hash.update(transactionClientOrderId.getBytes());
            hash.update(this.params.getMerchantControl().getBytes());
            String hashValue = Utils.bytesToHexString((byte[])hash.digest()).toLowerCase();
            if (log.isDebugEnabled()) {
                log.debug("\u0421\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u044c: " + hashValue);
            }
            if (!hashValue.equals(transactionControl)) {
                if (log.isDebugEnabled()) {
                    log.error("Incorrect control value!");
                }
                out.write("Error: incorrect control value".getBytes());
            } else {
                Transaction transaction;
                if (log.isDebugEnabled()) {
                    log.debug("\u041f\u043e\u0434\u043f\u0438\u0441\u0438 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
                }
                if ((transaction = this.service.getTransaction(transactionId)) == null) {
                    if (log.isDebugEnabled()) {
                        log.error("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f " + transactionId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0411\u0414!");
                    }
                    out.write("Error: transaction not found".getBytes());
                } else if (transaction.getStatus().equals(TransactionStatus.CREATED.getCode())) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u0421\u043e\u0437\u0434\u0430\u043d. \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438");
                    }
                    transaction.setTransactionDate(new Date());
                    if ("approved".equals(transactionStatus)) {
                        transaction.setStatus(TransactionStatus.APPROVED.getCode());
                        out.write("OK".getBytes());
                    } else if ("declined".equals(transactionStatus)) {
                        transaction.setStatus(TransactionStatus.DECLINED.getCode());
                        out.write("OK".getBytes());
                    } else if ("error".equals(transactionStatus)) {
                        transaction.setStatus(TransactionStatus.ERROR.getCode());
                    } else if ("filtered".equals(transactionStatus)) {
                        transaction.setStatus(TransactionStatus.FILTERED.getCode());
                    } else {
                        transaction.setStatus(TransactionStatus.ERROR.getCode());
                        log.error("Incorrect status " + transactionStatus);
                        out.write("Error: incorrect status".getBytes());
                    }
                    this.service.updateTransaction(transaction);
                    if (transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                        if (log.isDebugEnabled()) {
                            log.debug("\u0421\u0442\u0430\u0442\u0443\u0441 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u041e\u0434\u043e\u0431\u0440\u0435\u043d. \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432 \u0411\u0414.");
                        }
                        Payment payment = new Payment();
                        payment.setContractId(transaction.getContractId());
                        payment.setSum(transaction.getSum());
                        payment.setDate(transaction.getTransactionDate());
                        payment.setTypeId(this.params.getPaymentTypeId());
                        payment.setComment(moduleSetup.get("bvcom.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 BVCom, \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f: {TRANSACTION_ID}").replace("{TRANSACTION_ID}", transactionClientOrderId));
                        PaymentDao paymentDao = new PaymentDao(con);
                        paymentDao.update((Object)payment);
                        paymentDao.close();
                        if (log.isDebugEnabled()) {
                            log.debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u043b\u0430\u0442\u0435\u0436 \u0441 \u043a\u043e\u0434\u043e\u043c " + payment.getId());
                        }
                        ServerUtils.commitConnection((Connection)con);
                        bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                        EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
                        EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("\u0421\u0442\u0430\u0442\u0443\u0441 \u041d\u0415 \u0421\u041e\u0417\u0414\u0410\u041d! \u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + DebugUtils.dumpObject((Object)transaction));
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430");
                }
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void doProtocolv3(HttpServletRequest request, HttpServletResponse response, Connection con) {
        if (log.isDebugEnabled()) {
            log.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0432\u0435\u0440\u0441\u0438\u0438 3");
        }
    }
}

