/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.action.web;

import bitel.billing.server.ActionBase;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Card;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class ActionCard
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.cid <= 0) {
            return;
        }
        long cardNumber = this.getLongParameter("cardNumber", 0L);
        String pass = this.getParameter("password", null);
        Element request = this.createElement(this.rootNode, "request");
        request.setAttribute("cardNumber", String.valueOf(cardNumber));
        if (this.cid > 0 && cardNumber > 0L) {
            if (Utils.isEmptyString((String)pass)) {
                throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u044c \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d!");
            }
            CardManager man = new CardManager(this.con, this.mid, this.userId);
            Card card = man.getCard(cardNumber);
            if (card == null) {
                throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
            }
            if (card.getContractId() != 0) {
                throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430!");
            }
            if (card.getDealerId() == 0 || TimeUtils.dateBefore((Calendar)card.getPassDate(), (Calendar)new GregorianCalendar())) {
                throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u0430!");
            }
            if (!card.getPassword().equals(pass)) {
                throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c!");
            }
            UserCard userCard = new UserCard();
            userCard.setContractId(this.cid);
            userCard.setNumber(card.getNumber());
            userCard.setDate1(new Date());
            userCard.setComment("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c");
            new UserCardManager(this.con, this.mid, -1).update((Id)userCard);
            card.setContractId(this.cid);
            man.updateCardContract(card, new GregorianCalendar());
        }
        this.buildUserCards();
    }

    protected void buildUserCards() throws BGException {
        try (UserCardManager man = new UserCardManager(this.con, this.mid, this.userId);){
            List<UserCard> userCardList = man.getList(this.cid);
            Element cards = this.createElement(this.rootNode, "cards");
            for (UserCard userCard : userCardList) {
                Element card = this.createElement(cards, "card");
                card.setAttribute("number", String.valueOf(userCard.getNumber()));
                card.setAttribute("period", TimeUtils.formatPeriod((Date)userCard.getDate1(), (Date)userCard.getDate2()));
                card.setAttribute("comment", userCard.getComment());
            }
        }
    }
}

