/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.cerbercrypt;

public class ByteSerializer {
    private byte[] data;

    public ByteSerializer(byte[] data) {
        this.data = data;
    }

    public void putBytesToBytes(byte[] value, int fromPos, int cnt) {
        System.arraycopy(value, 0, this.data, fromPos, cnt);
    }

    public void putBytesToBytesSwap(byte[] value, int fromPos, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            this.data[fromPos + i] = value[cnt - i - 1];
        }
    }

    public void putIntToBytes(int value, int fromPos, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            this.data[fromPos + cnt - i - 1] = (byte)(value & 0xFF);
            value >>>= 8;
        }
    }

    public void putIntToBytesSwap(int value, int fromPos, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            this.data[fromPos + i] = (byte)(value & 0xFF);
            value >>>= 8;
        }
    }

    public void putLongToBytes(long value, int fromPos, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            this.data[fromPos + cnt - i - 1] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
    }

    public static String maskToEnum(byte[] mask, int base) {
        StringBuilder result = new StringBuilder();
        for (int ibyte = mask.length - 1; ibyte >= 0; --ibyte) {
            int pattern = 1;
            for (int ibit = 0; ibit < 8; ++ibit) {
                if ((mask[ibyte] & pattern) == pattern) {
                    result.append(base + (mask.length - ibyte - 1) * 8 + ibit).append(',');
                }
                pattern = (byte)(pattern << 1);
            }
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }
}

