/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.xcrypt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;

public class ByteSerializer {
    private byte[] buffer = null;
    private int pos = 0;

    public ByteSerializer(int cap) {
        this.buffer = new byte[cap];
    }

    public void put(byte value, int fieldlen) {
        this.put((long)value & 0xFFL, fieldlen);
    }

    public void put(int value, int fieldlen) {
        this.put((long)value & 0xFFFFFFFFL, fieldlen);
    }

    public void put(long value, int fieldlen) {
        for (int i = 0; i < fieldlen; ++i) {
            this.buffer[this.pos + fieldlen - i - 1] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
        this.pos += fieldlen;
    }

    public byte[] getBuffer() {
        if (this.pos < this.buffer.length) {
            byte[] buffernew = new byte[this.pos];
            System.arraycopy(this.buffer, 0, buffernew, 0, buffernew.length);
            this.buffer = buffernew;
        }
        return this.buffer;
    }

    public void putDTF(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        this.put(cal.get(1), 2);
        this.put(cal.get(2) + 1 - 1, 1);
        this.put(cal.get(5) - 1, 1);
        this.put(cal.get(11), 1);
        this.put(cal.get(12), 1);
        this.put(cal.get(13), 1);
    }

    public void putDTF32(LocalDate value) {
        if (value != null) {
            this.put(value.getYear(), 2);
            this.put(value.getMonthValue(), 1);
            this.put(value.getDayOfMonth(), 1);
        } else {
            this.put(0, 4);
        }
    }

    public void put(byte[] value) {
        System.arraycopy(value, 0, this.buffer, this.pos, value.length);
        this.pos += value.length;
    }

    public void put(String value, Charset charset) {
        this.put(value.getBytes(charset));
    }

    public static int getStrBytesLen(String value, Charset charset) {
        return value.getBytes(charset).length;
    }

    public void putascii(String value, int fieldlen) {
        byte[] bytes = new byte[fieldlen];
        byte[] val = value != null ? value.getBytes(StandardCharsets.US_ASCII) : new byte[]{};
        System.arraycopy(val, 0, bytes, 0, Math.min(fieldlen, val.length));
        this.put(bytes);
    }
}

