/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.chronopay.server.bean;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.chronopay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.chronopay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractIdDao<Transaction> {
    public Map<String, String> fields = new HashMap<String, String>();
    private static Logger logger = LogManager.getLogger();

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "chronopay_transaction");
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.create_date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.create_date<?");
                }
            }
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                query.append(" AND pt.result=?");
            }
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND c.id=").append(contractId);
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = null;
                ps = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title" + query.toString() + this.getSQLOrder(sort, this.fields) + (page != null ? page.sqlLimit() : ""));
                int index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                HashSet<String> columnNames = new HashSet<String>();
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int columnIndex = 1; columnIndex <= resultSetMetaData.getColumnCount(); ++columnIndex) {
                    columnNames.add(resultSetMetaData.getColumnName(columnIndex));
                }
                while (rs.next()) {
                    list.add(this.getFromRS(rs, columnNames));
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement("SELECT SUM(pt.sum), COUNT(*) " + query.toString());
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal summa;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((summa = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(summa);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, Collections.emptySet());
    }

    protected Transaction getFromRS(ResultSet rs, Set<String> columnNames) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("contract_id"));
        if (columnNames.contains("contract_title")) {
            transaction.setContractTitle(rs.getString("contract_title"));
        }
        transaction.setPaymentId(rs.getInt("payment_id"));
        transaction.setCreateDate((Date)rs.getTimestamp("create_date"));
        transaction.setTransactionDate((Date)rs.getTimestamp("transaction_date"));
        transaction.setTransactionId(rs.getString("transaction_id"));
        transaction.setStatus(rs.getString("result"));
        transaction.setParameters(rs.getString("params"));
        transaction.setSum(rs.getBigDecimal("sum"));
        return transaction;
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            try {
                String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, result=?, params=?, sum=?";
                int id = transaction.getId();
                StringBuilder query = new StringBuilder(id > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, result=?, params=?, sum=?").append(id > 0 ? " WHERE id=?" : "");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getTransactionId());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                if (id > 0) {
                    ps.setInt(index++, id);
                }
                ps.executeUpdate();
                if (id < 1) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void doCheckRequest(int contractId) throws BGException {
        Page page = new Page(1, 25);
        String[] sort = new String[]{"createDate:1"};
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        SearchResult searchResult = new SearchResult(null, page, sort);
        this.searchTransaction((SearchResult<Transaction>)searchResult, contractId, null, TransactionStatus.CREATED.getCode());
        for (Transaction transaction : searchResult.getList()) {
            StringBuilder requestParam;
            String transactionId = transaction.getTransactionId();
            if (transactionId == null) continue;
            try {
                requestParam = new StringBuilder("command=c").append("&trans_id=").append(URLEncoder.encode(transactionId, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new BGException((Throwable)e);
            }
            String responseParam = TransactionManager.doRequest(requestParam.toString(), (ParameterMap)moduleSetup);
            if (responseParam == null) continue;
            if (responseParam.startsWith("error: ")) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                transaction.setTransactionDate(new Date());
                transaction.setPaymentId(-1);
                transaction.setParameters(transaction.getParameters() + "\n\n" + responseParam);
                this.update(transaction);
                continue;
            }
            for (String line : responseParam.split("\n")) {
                if (!line.startsWith("RESULT:")) continue;
                String result = line.substring(7).trim();
                if ("OK".equals(result)) {
                    transaction.setStatus(TransactionStatus.OK.getCode());
                    transaction.setTransactionDate(new Date());
                    Payment payment = new Payment();
                    payment.setContractId(transaction.getContractId());
                    payment.setSum(transaction.getSum());
                    payment.setDate(transaction.getTransactionDate());
                    payment.setTypeId(moduleSetup.getInt("chronopay.payment.type.id", 0));
                    payment.setComment("\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u041c\u0422\u0421\u0411\u0430\u043d\u043a");
                    try (PaymentDao paymentDao = new PaymentDao(this.con);){
                        paymentDao.update((Object)payment);
                    }
                    BalanceUtils balanceUtils = new BalanceUtils(this.con);
                    balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                    balanceUtils.close();
                    transaction.setPaymentId(payment.getId());
                    transaction.setParameters(transaction.getParameters() + "\n\n" + responseParam);
                    this.update(transaction);
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                    continue;
                }
                if ("PENDING".equals(result) || "CREATED".equals(result)) continue;
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                transaction.setTransactionDate(new Date());
                transaction.setPaymentId(-1);
                transaction.setParameters(transaction.getParameters() + "\n\n" + responseParam);
                this.update(transaction);
            }
        }
    }

    public static String doRequest(String requestParam, ParameterMap moduleSetup) throws BGException {
        StringBuilder result = null;
        try {
            URL url = new URL(moduleSetup.get("", "https://payments.chronopay.ru/ecomm/MerchantHandler"));
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream writer = connection.getOutputStream();
            writer.write(requestParam.getBytes("utf-8"));
            writer.flush();
            writer.close();
            if (connection.getResponseCode() == 200) {
                result = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    result.append(line).append("\n");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u041e\u0442\u0432\u0435\u0442 Payment Gate: " + result);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a \u0448\u043b\u044e\u0437\u0443. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438: " + ex.getMessage(), (Throwable)ex);
        }
        return result == null ? null : result.toString();
    }
}

