/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client.directory;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class RegisterSubjectsEditor
extends BGPanel {
    private static final String MODULE_ADMIN_REGISTER = "ru.bitel.bgbilling.plugins.crm";
    private String editID = null;
    private BGTable table = new BGTable();
    private JPanel editor_P = new JPanel();
    private JTextField subject_TF = new JTextField();
    private JCheckBox autoClose_ChB = new JCheckBox();
    private JComboBox subjectGroup_CB = new JComboBox();
    private BGPluginClient plugin = null;

    public RegisterSubjectsEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.plugin = BGPluginManagerClient.getManager().getPlugin(MODULE_ADMIN_REGISTER);
        this.editor_P.setVisible(false);
        this.table.setHeader(this.plugin.getResourceBundle(), this.plugin.getTable("register_subject"), "register_subject");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RegisterSubjectsEditor.this.editItem();
                }
            }
        });
        this.autoClose_ChB.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.editor_P.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editor_P.setLayout(new GridBagLayout());
        this.subject_TF.setMinimumSize(new Dimension(4, 24));
        this.subject_TF.setPreferredSize(new Dimension(63, 24));
        BGButtonPanelOkCancel bGControlPanel_051 = new BGButtonPanelOkCancel();
        this.autoClose_ChB.setText("\u0410\u0432\u0442\u043e\u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435");
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editor_P, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editor_P.add((Component)this.subject_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editor_P.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor_P.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor_P.add((Component)bGControlPanel_051, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.editor_P.add((Component)this.subjectGroup_CB, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editor_P.add((Component)this.autoClose_ChB, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        bGControlPanel_051.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String command = actionEvent.getActionCommand();
                if (command != null) {
                    RegisterSubjectsEditor.this.stopEdit(command);
                }
            }
        });
    }

    public void setData() {
        Request req = new Request();
        req.setModule(MODULE_ADMIN_REGISTER);
        req.setAction("RegisterSubjectInfo");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.selectNode((Node)doc, (String)"//table"));
        }
    }

    private void startEdit() {
        Request req = new Request();
        req.setModule(MODULE_ADMIN_REGISTER);
        req.setAction("GetRegisterSubject");
        req.setAttribute("id", this.editID);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element subject = XMLUtils.selectElement((Node)doc, (String)"//subject");
            Element list = XMLUtils.selectElement((Node)doc, (String)"//list");
            this.subjectGroup_CB.setModel(ClientUtils.buildComboBox((Node)list, (String)subject.getAttribute("gid")));
            this.subject_TF.setText(subject.getAttribute("title"));
            this.autoClose_ChB.setSelected(subject.getAttribute("auto_close").equals("1"));
            this.editor_P.setVisible(true);
        }
    }

    public void deleteItem() {
        String id = ClientUtils.getRowId((BGTable)this.table);
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request req = new Request();
            req.setModule(MODULE_ADMIN_REGISTER);
            req.setAction("DeleteRegisterSubject");
            req.setAttribute("id", id);
            if (ClientUtils.checkStatus((Document)this.getDocument(req))) {
                this.setData();
            }
        }
    }

    public void editItem() {
        this.editID = ClientUtils.getRowId((BGTable)this.table);
        if (this.editID != null) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.editID = "new";
        this.startEdit();
    }

    private void stopEdit(String command) {
        if (command.equals("ok")) {
            Request req = new Request();
            req.setModule(MODULE_ADMIN_REGISTER);
            req.setAction("UpdateRegisterSubject");
            req.setAttribute("id", this.editID);
            ComboBoxItem groupItem = (ComboBoxItem)this.subjectGroup_CB.getSelectedItem();
            String subjectTitle = this.subject_TF.getText();
            if (groupItem != null && subjectTitle.length() > 0) {
                req.setAttribute("gid", groupItem.getObject());
                req.setAttribute("title", subjectTitle);
                req.setAttribute("ac", this.autoClose_ChB.isSelected() ? "1" : "0");
                if (ClientUtils.checkStatus((Document)this.getDocument(req))) {
                    this.editor_P.setVisible(false);
                }
            }
            this.setData();
        } else {
            this.editor_P.setVisible(false);
        }
    }
}

