<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:exslt="http://exslt.org/common"    
    xmlns:sql="bitel.billing.server.util.exslt.SQLQuery"
	version="1.0">
			
	<xalan:component prefix="sql" functions="select">
   			 <xalan:script lang="javaclass" src="xalan://bitel.billing.server.util.exslt.SQLQuery"/>
  	</xalan:component>  	

<xsl:output method="html" encoding="UTF-8" indent="yes"/>
<xsl:template match="/data">  	
  	<!-- Код параметра адрес в договоре -->
  	<xsl:variable name="address_pid" select="'19'"/>
  	<xsl:variable name="fio_pid" select="'4'"/>
  	<xsl:variable name="phone_pid" select="'6'"/>
  	<xsl:variable name="rpid" select="/data/problem/@id"/>
  	
  	<!-- находим первый звонок и берем оттуда договор  -->
  	<xsl:variable name="query" 
				  select="concat('SELECT cid FROM register_call where rpid = ', $rpid, ' limit 0, 1')"/>				   
		<xsl:variable name="cidRow" select="sql:select( $query )"/>
		
		<xsl:variable name="cid" >
			<xsl:variable name="_cid" select="$cidRow/row/@cid"/>
			<xsl:choose>
			<xsl:when test="$_cid != ''">
				<xsl:value-of select="$_cid"/>		
			</xsl:when>
			<xsl:otherwise>-100</xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		
	  
		<xsl:variable name="queryAddress" 
				  select="concat('SELECT  param.flat as flat, quarter.title as quarterTitle,',
				   'street.title as streetTitle, ',
				   'house.house as house ',
				  'FROM contract_parameter_type_2 AS param ',								   
				   'LEFT JOIN address_house AS house ON param.hid=house.id ',
				   'LEFT JOIN address_quarter AS quarter ON quarter.id=house.quarterid ',				   
				   'LEFT JOIN address_street AS street ON street.id=house.streetid ',
				   'WHERE param.cid=', $cid, ' AND param.pid = ', $address_pid)"/>
				   
        				  		 
		<xsl:variable name="address" select="sql:select( $queryAddress )"/>
		  		  		 	
		<xsl:variable name="queryFIO" 
				  select="concat('SELECT  param.val FROM contract_parameter_type_1 AS param ',				   
				   'WHERE param.cid=', $cid, ' AND param.pid = ', $fio_pid)"/>
				           				  		 
		<xsl:variable name="fio" select="sql:select( $queryFIO )"/>
		
		<xsl:variable name="queryContract" select="concat('SELECT title, date1 FROM contract WHERE id=', $cid)"/>
		<xsl:variable name="contract" select="sql:select( $queryContract )"/>

		<xsl:variable name="queryPhone" select="concat('SELECT  param.val FROM contract_parameter_type_1 AS param WHERE param.cid=', $cid, ' AND param.pid =', $phone_pid)"/>
		<xsl:variable name="phone" select="sql:select( $queryPhone )"/>
		
		<xsl:variable name="queryProblem" select="concat('SELECT status_dt, comment FROM register_problem WHERE id=', $rpid)"/>
		<xsl:variable name="problem" select="sql:select( $queryProblem )"/>
<html>
<head>
<style media="print">
	body { font-family: monospace; font-size: 1em; }
</style>
</head>

<body>	

<xsl:call-template name="order">
	<xsl:with-param name="address" select="$address"/>
	<xsl:with-param name="fio" select="$fio"/>
	<xsl:with-param name="contract" select="$contract"/>
	<xsl:with-param name="phone" select="$phone"/>
	<xsl:with-param name="problem" select="$problem"/>
</xsl:call-template>

<xsl:call-template name="order">
	<xsl:with-param name="address" select="$address"/>
	<xsl:with-param name="fio" select="$fio"/>
	<xsl:with-param name="contract" select="$contract"/>
	<xsl:with-param name="phone" select="$phone"/>
	<xsl:with-param name="problem" select="$problem"/>
</xsl:call-template>

Отметки об исполнении:	_________________________________________________

_________________________________________________________________________



Руководитель __________________________	__________________/ _____________	



Работы выполнил:				______________/__________________________								

</body>
</html>
</xsl:template>

<xsl:template name="order">
<xsl:param name="address"/>
<xsl:param name="fio"/>
<xsl:param name="contract"/>
<xsl:param name="phone"/>
<xsl:param name="problem"/>
<pre>
          Наряд-заказ №  от 

на выполнение работ бригадой _____________________ по адресу: 
Квартал: <xsl:value-of select="$address/row/@quarterTitle"/> 
Улица: <xsl:value-of select="$address/row/@streetTitle"/>
Дом: <xsl:value-of select="$address/row/@house"/>			
Квартира: <xsl:value-of select="$address/row/@flat"/>		
		
ФИО/Название клиента:	<xsl:value-of select="$fio/row/@val"/>
Договор:	<xsl:value-of select="$contract/row/@title"/> от <xsl:value-of select="$contract/row/@date1"/>  
Телефон:	<xsl:value-of select="$phone/row/@val"/>

Дата выполнения работ: <xsl:value-of select="$problem/row/@status_dt"/>		

Комментарий:   <xsl:value-of select="$problem/row/@comment"/>

</pre>

</xsl:template>


</xsl:stylesheet>
