/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.action;

import bitel.billing.server.call.action.web.ActionShowSessions;
import bitel.billing.server.call.bean.NAS;
import bitel.billing.server.call.bean.NasManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.IpNet;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTaskManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionCreateDetailBase
extends ActionShowSessions {
    protected boolean createDetail() throws SQLException, BGException {
        int sessionId = this.getIntParameter("session_id", -1);
        Calendar month = TimeUtils.parseCalendar((String)this.getParameter("session_start"), (String)"dd.MM.yyyy HH:mm:ss");
        String mail = this.getParameter("mail");
        if (month == null) {
            month = this.getPeriodByYearsAndDays().getDateFromCalendar();
        }
        if (month == null || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (sessionId <= 0) {
            throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0441\u0441\u0438\u044e.");
        }
        if (!Utils.checkEmail((String)mail)) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 E-Mail!");
        }
        String sessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)month.getTime(), (int)this.mid);
        if (!ServerUtils.tableExists((Connection)this.con, (String)sessionTableName)) {
            throw new BGMessageException("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 " + sessionTableName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
        }
        String query = null;
        PreparedStatement ps = null;
        DetailCreateTaskManager taskManager = null;
        DetailCreateTask task = new DetailCreateTask();
        task.setModule(1);
        task.setEmail(mail);
        query = "SELECT login_name, session_stop, ipaddr, nas_id, session_start FROM " + sessionTableName + " WHERE id=?";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, sessionId);
        int nasId = 0;
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u0441\u0441\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + sessionId);
        }
        task.setDialupLogin(rs.getString(1));
        task.setSessionStart(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(5)));
        task.setSessionEnd(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(2)));
        task.setDialupSessionIp(rs.getLong(3));
        nasId = rs.getInt(4);
        NasManager nu = new NasManager(this.con, this.mid);
        NAS nas = nu.getNasById(nasId);
        if (nas == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d NAS, \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0432\u0443\u044e\u0449\u0438\u0439 \u0434\u0430\u043d\u043d\u043e\u0439 \u0441\u0435\u0441\u0441\u0438\u0438");
        }
        nu.setNasConfig(nas);
        task.setSourceId(nas.getConfig().getInt("ipn.source.id", 0));
        if (task.getSourceId() <= 0) {
            throw new BGMessageException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043c\u043e\u0434\u0443\u043b\u044f IPN \u043d\u0435 \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d NAS \u0443 \u0432 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 ipn.source.id \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438!");
        }
        int ipnMid = nas.getConfig().getInt("ipn.module.id", 0);
        if (ipnMid <= 0) {
            throw new BGMessageException("\u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f IPN \u043d\u0435 \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d NAS \u0443 \u0432 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 ipn.module.id \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438!");
        }
        taskManager = new DetailCreateTaskManager(this.con, ipnMid);
        String sessionNetTableName = ServerUtils.getModuleMonthTableName((String)"log_session_net", (Date)month.getTime(), (int)this.mid);
        if (ServerUtils.tableExists((Connection)this.con, (String)sessionNetTableName)) {
            ArrayList<IpNet> netList = new ArrayList<IpNet>();
            query = "SELECT net, mask FROM " + sessionNetTableName + " WHERE session_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, sessionId);
            rs = ps.executeQuery();
            while (rs.next()) {
                IpNet net = new IpNet();
                net.net = rs.getLong(1);
                net.mask = rs.getLong(2);
                netList.add(net);
            }
            ps.close();
            task.setDialupNetList(netList);
        }
        taskManager.addTask(task);
        return true;
    }
}

