/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.calc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class SessionUpdater {
    private DefaultServerSetup setup;
    private String sessionAccountTableName;
    private String logSessionTableName;
    private Logger log = LogManager.getLogger((String)"scheduler");
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private AtomicInteger taskCount = new AtomicInteger();

    public SessionUpdater(DefaultServerSetup setup, String sessionAccountTableName, String logSessionTableName) {
        this.setup = setup;
        this.sessionAccountTableName = sessionAccountTableName;
        this.logSessionTableName = logSessionTableName;
    }

    public void updateSessionData(int sessionId, int cid, Map<Integer, Double> accountMap) {
        this.pool.execute(new SessionAccountInserter(sessionId, cid, accountMap));
        this.taskCount.incrementAndGet();
    }

    public void waitUpdater() throws InterruptedException {
        while (this.taskCount.get() != 0) {
            Thread.sleep(1000L);
        }
    }

    private class SessionAccountInserter
    implements Runnable {
        private int sessionId;
        private int cid;
        private Map<Integer, Double> accountMap;

        public SessionAccountInserter(int sessionId, int cid, Map<Integer, Double> accountMap) {
            this.sessionId = sessionId;
            this.cid = cid;
            this.accountMap = accountMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection con = SessionUpdater.this.setup.getDBConnectionFromPool();
            try {
                String query = "DELETE FROM " + SessionUpdater.this.sessionAccountTableName + " WHERE session_id=?";
                PreparedStatement psDeleteSessionAccount = con.prepareStatement(query);
                query = "INSERT INTO " + SessionUpdater.this.sessionAccountTableName + " (cid, session_id, sid, summa) VALUES (?, ?, ?, ?)";
                PreparedStatement psInsertSessionAccount = con.prepareStatement(query);
                query = "UPDATE " + SessionUpdater.this.logSessionTableName + " SET session_cost=? WHERE id=?";
                PreparedStatement psUpdateSessionCost = con.prepareStatement(query);
                psDeleteSessionAccount.setInt(1, this.sessionId);
                psDeleteSessionAccount.executeUpdate();
                psDeleteSessionAccount.close();
                psInsertSessionAccount.setInt(1, this.cid);
                psInsertSessionAccount.setInt(2, this.sessionId);
                float sessionCost = 0.0f;
                for (Map.Entry<Integer, Double> entry : this.accountMap.entrySet()) {
                    if (entry.getValue() == 0.0) continue;
                    psInsertSessionAccount.setInt(3, entry.getKey());
                    psInsertSessionAccount.setDouble(4, entry.getValue());
                    psInsertSessionAccount.executeUpdate();
                    sessionCost = (float)((double)sessionCost + entry.getValue());
                }
                psInsertSessionAccount.close();
                psUpdateSessionCost.setFloat(1, sessionCost);
                psUpdateSessionCost.setInt(2, this.sessionId);
                psUpdateSessionCost.executeUpdate();
                psUpdateSessionCost.close();
            }
            catch (Exception e) {
                SessionUpdater.this.log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
                SessionUpdater.this.taskCount.decrementAndGet();
            }
        }
    }
}

