/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.common.bean;

import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Contractable;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.ScheduleTime;

public class Subscription
extends Id
implements Contractable {
    private int contractId;
    private String contractTitle;
    private String comment;
    private Dispatch dispatch;
    private List<Contact> contacts = new ArrayList<Contact>();
    private Preferences prefs;
    private ScheduleTime repeatTime;
    boolean active;
    private Period subscriptionPeriod;
    private boolean update = false;

    public Dispatch getDispatch() {
        return this.dispatch;
    }

    public void setDispatch(Dispatch dispatch) {
        this.dispatch = dispatch;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public void addContact(Contact contact) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<Contact>();
        }
        this.contacts.add(contact);
    }

    public void setPreferences(Preferences prefs) {
        this.prefs = prefs;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public ScheduleTime getRepeatTime() {
        return this.repeatTime;
    }

    public void setRepeatTime(ScheduleTime recieveTime) {
        this.repeatTime = recieveTime;
    }

    public ScheduleTime getTotalRepeatTime() {
        ScheduleTime dispatchTime = this.dispatch.getRepeatTime();
        ScheduleTime totalTime = new ScheduleTime(this.repeatTime);
        totalTime.setHour(dispatchTime.getHour());
        totalTime.setMin(dispatchTime.getMin());
        return totalTime;
    }

    public String getHumanReadableRepeatTime() {
        return ScheduleTime.toHumanReadable((ScheduleTime)this.repeatTime);
    }

    public String getRepeatTimeDaysOfWeek() {
        return Utils.unpackValues((long)this.repeatTime.getDayOfWeek(), (int)1);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Period getSubscriptionPeriod() {
        return this.subscriptionPeriod;
    }

    public void setSubscriptionPeriod(Period subscriptionPeriod) {
        this.subscriptionPeriod = subscriptionPeriod;
    }

    public String getContactHash(Contact contact) {
        return Utils.getDigest((String)(String.valueOf(this.getId()) + String.valueOf(contact.getId())), (String)"UTF-8");
    }

    public String getContractTitle() {
        return this.contractTitle;
    }

    public void setContractTitle(String contractTitle) {
        this.contractTitle = contractTitle;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }
}

