/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.sender;

import bitel.billing.server.util.MailMsg;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class EmailSender
implements Sender {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public void send(Contact contact, String title, String messageBody, List<DataSource> messageFiles) throws BGException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void send(Contact contact, String title, String messageBody, List<DataSource> messageFiles, Subscription subscription) throws BGException {
        try {
            Preferences setup = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch").getSetup();
            title = setup.get("message.title.prefix", "") + (String)title;
            MimeMultipart multipart = new MimeMultipart();
            for (DataSource file : messageFiles) {
                MimeBodyPart filePart = new MimeBodyPart();
                filePart.setDataHandler(new DataHandler(file));
                try {
                    filePart.setFileName(MimeUtility.encodeText((String)file.getName(), (String)"utf-8", (String)"B"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new BGException((Throwable)e);
                }
                multipart.addBodyPart((BodyPart)filePart);
            }
            if (Utils.notBlankString((String)messageBody)) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText(messageBody, "utf-8");
                mimeBodyPart.setHeader("Content-Type", "text/" + setup.get("message.text.type", "html") + "; charset=utf-8;");
                multipart.addBodyPart((BodyPart)mimeBodyPart, 0);
            }
            if (contact != null) {
                new MailMsg((Preferences)Setup.getSetup()).sendMessage(contact.getValueForSend(), (String)title, (Multipart)multipart);
                if (logger.isDebugEnabled()) {
                    logger.debug("\t\t\tEmail-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443 " + contact.getValueForSend() + " \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                }
            } else {
                logger.warn("\t\t\t\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442! \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c email-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            }
        }
        catch (MessagingException e) {
            throw new BGException((Throwable)e);
        }
    }
}

