/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.utils;

import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactTypeDao;

public final class DispatchUtils
extends AbstractService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Contact> getContactsFromContractParameters(int contractId, Dispatch dispatch, Connection con) throws BGException {
        ArrayList<Contact> contacts = new ArrayList();
        int contactTypeId = dispatch.getContactTypeId();
        int typeId = DispatchUtils.getContactTypeIdOfContact(dispatch, con);
        try (ContactTypeDao contactTypeDao = new ContactTypeDao(con);
             ContractParameterManager parameterManager = new ContractParameterManager(con);){
            ContractEmailParamValue emailParamValue;
            ContactType contactType = contactTypeDao.get(contactTypeId);
            ContractParameterPref paramPref = parameterManager.getParamPref(contactType.getPid());
            if (typeId == ContractParameterPrefType.TYPE_EMAIL.getId() && (emailParamValue = parameterManager.getEmailParam(contractId, paramPref.getId())) != null) {
                contacts = DispatchUtils.createContactForSend(emailParamValue.getEmail(), contractId, contactTypeId, typeId);
                ArrayList<Contact> arrayList = contacts;
                return arrayList;
            }
            if (typeId != ContractParameterPrefType.TYPE_PHONE.getId()) return contacts;
            PhoneParamValue phoneParamValue = parameterManager.getPhoneParam(contractId, paramPref.getId());
            if (phoneParamValue == null) return contacts;
            ArrayList<Contact> arrayList = contacts = DispatchUtils.createContactForSend(phoneParamValue.getPhones(), contractId, contactTypeId, typeId);
            return arrayList;
        }
        catch (BGException e) {
            throw new BGException((Throwable)e);
        }
    }

    public static int getContactTypeIdOfContact(Dispatch dispatch, Connection con) throws BGException {
        int n;
        ContractParameterManager parameterManager = new ContractParameterManager(con);
        try {
            int typeId = -1;
            int pid = DispatchUtils.getContactTypePid(dispatch, con);
            if (pid > 0) {
                ContractParameterPref paramPref = parameterManager.getParamPref(pid);
                typeId = paramPref.getType().getId();
            }
            n = typeId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    parameterManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException e) {
                throw new BGException((Throwable)e);
            }
        }
        parameterManager.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getContactTypePid(Dispatch dispatch, Connection con) throws BGException {
        try (ContactTypeDao contactTypeDao = new ContactTypeDao(con);){
            ContactType contactType = contactTypeDao.get(dispatch.getContactTypeId());
            if (contactType == null) return 0;
            int n = contactType.getPid();
            return n;
        }
        catch (BGException e) {
            throw new BGException((Throwable)e);
        }
    }

    private static List<Contact> createContactForSend(String contactsFromParameters, int contractId, int contactTypeId, int typeId) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        if (contactsFromParameters != null) {
            List<String> contactParametersForSend = DispatchUtils.getCurrectContacts(contactsFromParameters, typeId);
            for (String value : contactParametersForSend) {
                Contact contact = new Contact();
                contact.setValue(value);
                contact.setDefaultValue(value);
                contact.setContractId(contractId);
                contact.setContactTypeId(contactTypeId);
                contact.setId(-1);
                contacts.add(contact);
            }
        }
        return contacts;
    }

    private static List<String> getCurrectContacts(String value, int typeId) {
        String val;
        Matcher matcher;
        ArrayList<String> contacts = new ArrayList<String>();
        Pattern pattern = null;
        if (typeId == ContractParameterPrefType.TYPE_EMAIL.getId()) {
            pattern = Pattern.compile("[-a-z0-9~!$%^&*_=+}{\\'?]+(\\.[-a-z0-9~!$%^&*_=+}{\\'?]+)*@([a-z0-9_][-a-z0-9_]*(\\.[-a-z0-9_]+)*\\.(aero|arpa|biz|com|coop|edu|gov|info|int|mil|museum|name|net|org|pro|travel|mobi|[a-z][a-z])|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))(:[0-9]{1,5})?", 2);
            matcher = pattern.matcher(value);
            while (matcher.find()) {
                val = matcher.group().trim();
                contacts.add(val);
            }
        }
        if (typeId == ContractParameterPrefType.TYPE_PHONE.getId()) {
            pattern = Pattern.compile("\\d\\s(\\d+|\\W\\d+\\W+\\d+)(\\d|\\s\\d+\\W\\d+\\W\\d+)");
            matcher = pattern.matcher(value);
            while (matcher.find()) {
                val = matcher.group().trim().replaceAll("\\D", "");
                if (val.isEmpty() || val.length() <= 10) continue;
                contacts.add(val);
            }
        }
        return contacts;
    }
}

