/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.contract;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.ListItem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.dispatch.client.common.DispatchMessageStatisticPanel;
import ru.bitel.bgbilling.plugins.dispatch.client.common.SchedulePane;
import ru.bitel.bgbilling.plugins.dispatch.client.contract.ContractDispatchConditionsPanel;
import ru.bitel.bgbilling.plugins.dispatch.client.contract.DaysOfWeekSchedulePane;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.ScheduleTime;
import ru.bitel.common.util.Matcher;

public class ContractDispatchPanel
extends BGUPanel {
    private BGUTable table;
    private BGTableModel<Subscription> model;
    private BGEditor editor;
    private DispatchForm subscribeForm = new DispatchForm();
    private ContractDispatchConditionsPanel conditionPanel = new ContractDispatchConditionsPanel();
    private DispatchMessageStatisticPanel statisticPanel = new DispatchMessageStatisticPanel();
    private JPanel mainPanel;
    private CardLayout switchLayout = new CardLayout();

    protected void jbInit() {
        this.model = new BGTableModel<Subscription>("dispatch_subscribe"){

            protected void initColumns() {
                this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430", 100, 100, 100, "active", true);
                this.addColumn("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430", "", true);
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 200, 250, "subscriptionPeriod");
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", true);
            }

            public Object getValue(Subscription val, int column) throws BGException {
                Object value = null;
                switch (column) {
                    case 1: {
                        value = val.getDispatch().getTitle();
                        break;
                    }
                    default: {
                        value = super.getValue((Object)val, column);
                    }
                }
                return value;
            }
        };
        this.table = new BGUTable(this.model);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractDispatchPanel.this.performAction("edit");
                }
            }
        });
        this.editor = new BGEditor();
        this.editor.addForm((JComponent)((Object)this.subscribeForm));
        Dimension size = new Dimension(300, 200);
        this.editor.setMinimumSize(size);
        this.editor.setPreferredSize(size);
        this.mainPanel = new JPanel(this.switchLayout);
        this.mainPanel.add((Component)new JScrollPane((Component)this.table), "table");
        this.mainPanel.add((Component)((Object)this.conditionPanel), "condition");
        this.mainPanel.add((Component)((Object)this.statisticPanel), "statistic");
        this.setLayout(new GridBagLayout());
        this.add(this.mainPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.setVisible(false);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                ContractDispatchPanel.this.subscribeForm.schedulePane.setVisible(false);
                ContractDispatchPanel.this.subscribeForm.schedulePane.setTime(this.getDefaultPersonalTime());
                ContractDispatchPanel.this.model.setData(((DispatchService)((ClientContext)ContractDispatchPanel.this.getContext()).getPort(DispatchService.class)).getSubscriptions(0, ((ClientContext)ContractDispatchPanel.this.getContext()).getContractId()));
            }

            private ScheduleTime getDefaultPersonalTime() {
                int DEFAULT_HOURS = 21;
                boolean DEFAULT_MINUTES = false;
                int packedHours = (int)Utils.packValues((Collection)Utils.toList((String)String.valueOf(21)), (int)0);
                int packedMinutes = (int)Utils.packValues((Collection)Utils.toList((String)String.valueOf(0)), (int)0);
                ScheduleTime time = new ScheduleTime(0, 0, packedHours, 0, (long)packedMinutes);
                return time;
            }
        };
        new AbstractBGUPanel.MenuAction("dispatch_subscribe.show_stat", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                Subscription selectedRow = (Subscription)ContractDispatchPanel.this.model.getSelectedRow();
                if (selectedRow != null) {
                    ContractDispatchPanel.this.switchLayout.show(ContractDispatchPanel.this.mainPanel, "statistic");
                    ContractDispatchPanel.this.statisticPanel.setDispatch(selectedRow.getDispatch());
                    ContractDispatchPanel.this.statisticPanel.setContractId(selectedRow.getContractId());
                    ContractDispatchPanel.this.statisticPanel.performAction("refresh");
                }
            }
        };
    }

    public class DispatchForm
    extends BGUPanel {
        private Subscription current = null;
        private List<Contact> contactList = new ArrayList<Contact>();
        private BGUComboBox<Dispatch> dispatchBox = new BGUComboBox();
        private JCheckBox activeCheckBox = new JCheckBox("\u0430\u043a\u0442\u0438\u0432\u043d\u0430");
        private SchedulePane schedulePane = new DaysOfWeekSchedulePane();
        private BGTextArea commentArea = new BGTextArea();
        private JToggleButton conditionButton = new JToggleButton("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u044f =>");
        private BGControlPanelListSelect subscribedContacts = new BGControlPanelListSelect();
        private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();

        protected void jbInit() {
            this.dispatchBox.setContentFilter((Matcher)new Matcher<Dispatch>(){

                public boolean matched(Dispatch singleObject) {
                    return !DispatchForm.this.dispatchBox.isEnabled() || !ContractDispatchPanel.this.model.getRows().contains(singleObject);
                }
            });
            this.dispatchBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Dispatch dispatch = (Dispatch)DispatchForm.this.dispatchBox.getSelectedItem();
                    boolean selected = dispatch.getId() > 0;
                    DispatchForm.this.activeCheckBox.setEnabled(selected);
                    DispatchForm.this.subscribedContacts.setEnabled(selected);
                    DispatchForm.this.commentArea.setEnabled(selected);
                    DispatchForm.this.conditionButton.setEnabled(dispatch.isPersonal());
                    ContractDispatchPanel.this.subscribeForm.getActionMap().get("ok").setEnabled(selected);
                    if (selected) {
                        if (DispatchForm.this.dispatchBox.isEnabled()) {
                            ContractDispatchPanel.this.conditionPanel.loadFromDispatch(dispatch);
                        }
                        if (!dispatch.isPersonal()) {
                            ContractDispatchPanel.this.conditionPanel.clear();
                        }
                        DispatchForm.this.schedulePane.setVisible(dispatch.isPersonal());
                        DispatchForm.this.subscribedContacts.setEnabled(!dispatch.isWoContactType());
                        DispatchForm.this.subscribedContactsRefreshFilter(DispatchForm.this.current.getContacts());
                    } else {
                        DispatchForm.this.subscribedContacts.getList().setModel(new DefaultListModel());
                    }
                }
            });
            this.conditionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Dispatch dispatch = (Dispatch)DispatchForm.this.dispatchBox.getSelectedItem();
                    if (DispatchForm.this.conditionButton.isSelected()) {
                        if (!dispatch.isPersonal()) {
                            JOptionPane.showMessageDialog(null, "\u042d\u0442\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435!", 2);
                        }
                        ContractDispatchPanel.this.switchLayout.show(ContractDispatchPanel.this.mainPanel, "condition");
                    } else {
                        ContractDispatchPanel.this.switchLayout.show(ContractDispatchPanel.this.mainPanel, "table");
                    }
                }
            });
            this.activeCheckBox.setSelected(true);
            this.schedulePane.setBorder((Border)new BGTitleBorder("\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438"));
            JPanel contactPanel = new JPanel(new GridBagLayout());
            contactPanel.setBorder((Border)new BGTitleBorder("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b"));
            contactPanel.add((Component)this.subscribedContacts, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            JPanel commentPanel = new JPanel(new GridBagLayout());
            commentPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
            commentPanel.setMinimumSize(new Dimension(100, 100));
            commentPanel.setPreferredSize(new Dimension(100, 150));
            commentPanel.add((Component)new JScrollPane((Component)this.commentArea), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            JPanel dispatchPanel = new JPanel(new GridBagLayout());
            dispatchPanel.setBorder((Border)new BGTitleBorder("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430"));
            dispatchPanel.add((Component)this.dispatchBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add(dispatchPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
            this.add(this.activeCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
            this.add(BGSwingUtilites.wrapBorder((JPanel)this.periodPanel, (String)"\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
            this.add(this.schedulePane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
            this.add(contactPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            this.add(commentPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            this.add(this.conditionButton, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        }

        public void subscribedContactsRefreshFilter(List<Contact> selected) {
            DefaultListModel<ListItem> contactListModel = new DefaultListModel<ListItem>();
            Dispatch selectedDispatch = (Dispatch)this.dispatchBox.getSelectedItem();
            int contactTypeId = selectedDispatch.getContactTypeId();
            try {
                this.contactList = ((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).getContacts(((ClientContext)this.getContext()).getContractId(), selectedDispatch);
            }
            catch (BGException e) {
                super.processException((Throwable)e);
            }
            for (Contact contact : this.contactList) {
                if (contact.getContactTypeId() != contactTypeId) continue;
                ListItem listItem = new ListItem(contact.toString());
                if (contact.getId() == -1) {
                    listItem.setSelected(true);
                    this.subscribedContacts.setEnabled(false);
                } else {
                    listItem.setSelected(selected.contains(contact));
                }
                listItem.setAttribute("id", (Object)contact.getId());
                contactListModel.addElement(listItem);
            }
            if (this.contactList != null && this.contactList.size() > 0 && this.contactList.get(0).getId() == -1) {
                contactListModel.add(0, new ListItem("--\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430--", true).setAttribute("id", (Object)-1));
            }
            this.subscribedContacts.getList().setModel(contactListModel);
        }

        private void fillFromCurrent(boolean editMode) throws BGException {
            Dispatch dispatch;
            if (this.current != null && (dispatch = this.current.getDispatch()) != null) {
                this.dispatchBox.setSelectedItem((Object)dispatch);
                this.dispatchBox.setEnabled(!editMode);
                if (dispatch.isPersonal() && editMode) {
                    ContractDispatchPanel.this.conditionPanel.loadFromDispatch(dispatch);
                    ContractDispatchPanel.this.conditionPanel.setPreferences(this.current.getPreferences());
                }
                this.activeCheckBox.setSelected(this.current.isActive());
                this.schedulePane.setTime(this.current.getRepeatTime());
                this.commentArea.setText(this.current.getComment());
                this.periodPanel.setPeriod(this.current.getSubscriptionPeriod());
            }
        }

        private void getCurrentAndCheck() throws BGMessageException {
            this.current = (Subscription)ContractDispatchPanel.this.model.getSelectedRow();
            if (this.current == null) {
                throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            }
        }

        public void setData() {
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchForm.this.performActionOpen();
                    DispatchForm.this.dispatchBox.setEnabled(true);
                    DispatchForm.this.current = new Subscription();
                    DispatchForm.this.current.setActive(true);
                    DispatchForm.this.activeCheckBox.setSelected(true);
                    DispatchForm.this.subscribedContacts.getList().setModel(new DefaultListModel());
                    DispatchForm.this.commentArea.setText("");
                    DispatchForm.this.periodPanel.setDateFrom(new Date());
                    DispatchForm.this.periodPanel.setDateTo(null);
                    DispatchForm.this.fillFromCurrent(false);
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchForm.this.performActionOpen();
                    DispatchForm.this.getCurrentAndCheck();
                    DispatchForm.this.fillFromCurrent(true);
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchForm.this.getCurrentAndCheck();
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                        ((DispatchService)((ClientContext)DispatchForm.this.getContext()).getPort(DispatchService.class)).deleteSubscription(DispatchForm.this.current.getId());
                        ContractDispatchPanel.this.performAction("refresh");
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u041e\u041a"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    Dispatch selectedDispatch = (Dispatch)DispatchForm.this.dispatchBox.getSelectedItem();
                    if (selectedDispatch.getId() <= 0) {
                        throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443!");
                    }
                    Period period = DispatchForm.this.periodPanel.getPeriod();
                    if (period.getDateTo() != null && period.getDateFrom() != null && TimeUtils.dateBefore((Date)period.getDateTo(), (Date)period.getDateFrom())) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e, \u0447\u0442\u043e\u0431\u044b \u0434\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0431\u044b\u043b\u0430 \u043f\u043e\u0441\u043b\u0435 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f!");
                        return;
                    }
                    boolean flag = true;
                    ArrayList<Contact> list = new ArrayList<Contact>();
                    for (int id : DispatchForm.this.subscribedContacts.getSelectedIds()) {
                        for (Contact contact : DispatchForm.this.contactList) {
                            if (contact.getId() >= 0) {
                                if (contact.getId() != id) continue;
                                list.add(contact);
                                continue;
                            }
                            flag = false;
                        }
                    }
                    if (flag && list.isEmpty() && !selectedDispatch.isWoContactType()) {
                        throw new BGMessageException("\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u044b.");
                    }
                    DispatchForm.this.current.setDispatch(selectedDispatch);
                    DispatchForm.this.current.setActive(DispatchForm.this.activeCheckBox.isSelected());
                    DispatchForm.this.current.setContacts(list);
                    DispatchForm.this.current.setContractId(((ClientContext)DispatchForm.this.getContext()).getContractId());
                    DispatchForm.this.current.setComment(DispatchForm.this.commentArea.getText());
                    DispatchForm.this.current.setPreferences(ContractDispatchPanel.this.conditionPanel.getPreferences());
                    DispatchForm.this.current.setSubscriptionPeriod(period);
                    if (selectedDispatch.isPersonal()) {
                        DispatchForm.this.current.setRepeatTime(DispatchForm.this.schedulePane.getTime());
                    }
                    ((DispatchService)((ClientContext)DispatchForm.this.getContext()).getPort(DispatchService.class)).updateSubscriptions(DispatchForm.this.current);
                    ContractDispatchPanel.this.performAction("refresh");
                    DispatchForm.this.performActionClose();
                }
            };
            new AbstractBGUPanel.DefaultAction("close", "\u041e\u0442\u043c\u0435\u043d\u0430"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    DispatchForm.this.conditionButton.setSelected(false);
                    ContractDispatchPanel.this.switchLayout.show(ContractDispatchPanel.this.mainPanel, "table");
                    ContractDispatchPanel.this.editor.setVisible(false);
                }
            };
        }

        public void updateDispatchBox(List<Dispatch> dispatches) {
            this.dispatchBox.setData(dispatches);
            if (this.current != null) {
                this.dispatchBox.setSelectedItem((Object)this.current.getDispatch());
            }
        }

        public void performActionOpen() {
            try {
                Dispatch dispatch = new Dispatch();
                dispatch.setId(-1);
                dispatch.setTitle("-- \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443 --");
                List dispatches = ((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).getDispatchList();
                dispatches.add(0, dispatch);
                this.dispatchBox.setData(dispatches);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            super.performActionOpen();
        }
    }
}

