/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.bgbilling.modules.drweb.common.service.DrWebService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class SPPClientPanel
extends BGUPanel {
    private AgentAVDTableModel model = new AgentAVDTableModel();
    private JPanel editPanel;
    private BGTextField description = new BGTextField();
    private BGTextField agentUUID = new BGTextField();
    private BGTextField agentStatusText = new BGTextField();
    private BGTextField agentNextStatusText = new BGTextField();
    private BGUComboBox<IdTitle> tariffs = new BGUComboBox();
    private BGComboBox<IdTitle> blockCombo = new BGComboBox();
    JPanel deletePanel = new JPanel();
    private AgentAVD editAgent = null;
    private JPanel blockPanel = new JPanel();
    private JPanel tariffPanel = new JPanel();
    private JPanel activePanel = new JPanel();
    private JRadioButton blockButton = new JRadioButton();
    private JRadioButton tariffButton = new JRadioButton();
    private JRadioButton activeButton = new JRadioButton();
    private JRadioButton deleteButton = new JRadioButton();
    private BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SPPClientPanel.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getEditPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                SPPClientPanel.this.setData();
                try {
                    SPPClientPanel.this.tariffs.setData(((DrWebService)((ClientContext)SPPClientPanel.this.getContext()).getWebService(DrWebService.class, ((ClientContext)SPPClientPanel.this.getContext()).getModuleId())).tariffAVDList(0, false));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                AgentAVD agentAVD = (AgentAVD)SPPClientPanel.this.model.getSelectedRow();
                if (agentAVD != null) {
                    SPPClientPanel.this.startEditAgent(agentAVD);
                }
            }
        };
    }

    public void setData() {
        try {
            this.model.setData(((DrWebService)((ClientContext)this.getContext()).getWebService(DrWebService.class, ((ClientContext)this.getContext()).getModuleId())).agentAVDList(((ClientContext)this.getContext()).getContractId()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void startEditAgent(AgentAVD agent) {
        this.editAgent = agent;
        this.description.setText(agent.getName());
        this.agentUUID.setText(agent.getAgentUUID());
        this.agentStatusText.setText(agent.getStatusString());
        this.agentNextStatusText.setText(agent.getNextStatusString());
        if (agent.getStatus() == 3) {
            this.tariffPanel.setVisible(false);
            this.blockPanel.setVisible(false);
            this.deletePanel.setVisible(false);
            this.activePanel.setVisible(false);
        } else {
            this.tariffPanel.setVisible(true);
            this.blockPanel.setVisible(true);
            this.deletePanel.setVisible(true);
            this.activePanel.setVisible(true);
        }
        this.clearEditPanel();
        this.tariffs.setSelectedIndex(0);
        this.blockCombo.setSelectedIndex(0);
        this.editPanel.setVisible(true);
    }

    private void stopEditAgent(boolean save) {
        if (save) {
            try {
                DrWebService drWebService = (DrWebService)((ClientContext)this.getContext()).getWebService(DrWebService.class, ((ClientContext)this.getContext()).getModuleId());
                if (this.blockButton.isSelected()) {
                    drWebService.agentAVDBlock(this.editAgent.getId(), ((IdTitle)this.blockCombo.getSelectedItem()).getId());
                } else if (this.tariffButton.isSelected()) {
                    drWebService.agentAVDChangeTariff(this.editAgent.getId(), ((IdTitle)this.tariffs.getSelectedItem()).getId());
                } else if (this.activeButton.isSelected()) {
                    drWebService.agentAVDActive(this.editAgent.getId());
                } else if (this.deleteButton.isSelected()) {
                    drWebService.agentAVDDelete(this.editAgent.getId());
                }
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        this.editPanel.setVisible(false);
        this.editAgent = null;
    }

    private JPanel getEditPanel() {
        if (this.editPanel != null) {
            return this.editPanel;
        }
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new GridBagLayout());
        this.editPanel.setVisible(false);
        this.editPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String actionCommand = actionEvent.getActionCommand();
                if (BGButtonPanelOkCancel.OK.getActionCommand().equals(actionCommand)) {
                    SPPClientPanel.this.stopEditAgent(true);
                } else if (BGButtonPanelOkCancel.CANCEL.getActionCommand().equals(actionCommand)) {
                    SPPClientPanel.this.stopEditAgent(false);
                }
            }
        });
        this.agentStatusText.setEditable(false);
        this.agentNextStatusText.setEditable(false);
        this.agentUUID.setEditable(false);
        this.description.setEditable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.blockButton);
        group.add(this.tariffButton);
        group.add(this.activeButton);
        group.add(this.deleteButton);
        this.clearEditPanel();
        this.tariffButton.setText("\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444 \u043d\u0430");
        this.tariffPanel.setLayout(new GridBagLayout());
        this.tariffPanel.add((Component)this.tariffButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tariffPanel.add((Component)this.tariffs, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.blockPanel.setLayout(new GridBagLayout());
        DefaultComboBoxModel<IdTitle> model = new DefaultComboBoxModel<IdTitle>();
        IdTitle comboBoxItem = new IdTitle(1, "1 \u043c\u0435\u0441\u044f\u0446");
        model.addElement(comboBoxItem);
        comboBoxItem = new IdTitle(2, "2 \u043c\u0435\u0441\u044f\u0446\u0430");
        model.addElement(comboBoxItem);
        comboBoxItem = new IdTitle(3, "3 \u043c\u0435\u0441\u044f\u0446\u0430");
        model.addElement(comboBoxItem);
        this.blockCombo.setModel(model);
        this.blockButton.setText("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0430");
        this.blockPanel.add((Component)this.blockButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.blockPanel.add((Component)this.blockCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.deletePanel.setLayout(new GridBagLayout());
        this.deleteButton.setText("\u041f\u0440\u0435\u043a\u0440\u0430\u0442\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443");
        this.deletePanel.add((Component)this.deleteButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.activeButton.setText("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443");
        this.activePanel.setLayout(new GridBagLayout());
        this.activePanel.add((Component)this.activeButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.agentStatusText.setMinimumSize(new Dimension(150, (int)this.agentStatusText.getMinimumSize().getHeight()));
        this.agentStatusText.setPreferredSize(new Dimension(150, (int)this.agentStatusText.getMinimumSize().getHeight()));
        this.editPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.description, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.editPanel.add((Component)new JLabel("UUID"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.agentUUID, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.editPanel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.agentStatusText, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.editPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.editPanel.add((Component)this.agentNextStatusText, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.editPanel.add((Component)this.blockPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.tariffPanel, new GridBagConstraints(2, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.editPanel.add((Component)this.activePanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.editPanel.add((Component)this.deletePanel, new GridBagConstraints(2, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.editPanel.add((Component)this.okCancelPanel, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        return this.editPanel;
    }

    private void clearEditPanel() {
        this.blockButton.setSelected(false);
        this.tariffButton.setSelected(false);
        this.activeButton.setSelected(false);
        this.deleteButton.setSelected(false);
    }

    class AgentAVDTableModel
    extends BGTableModel<AgentAVD> {
        public AgentAVDTableModel() {
            super(AgentAVDTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, 200, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("UUID", -1, 300, 300, "agentUUID", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0430\u0440\u0438\u0444", 200, 200, 200, "tariffTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 150, 150, 150, "statusString", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, -1, -1, "nextStatusString", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

