/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternPluginTabPanel;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskParamService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.DirectoryItem;

public class PatternPluginTabPanelItemFactory
implements PatternPluginTabPanel.PatternPluginTabPanelItemFactory {
    public Collection<PatternPluginTabPanel.PatternPluginTabPanelItem> getPatternPluginTabPanelItems(int pid, String pluginTitle) {
        return Collections.singleton(new HelpDeskPanel(pid, pluginTitle));
    }

    private class HelpDeskPanel
    extends PatternPluginTabPanel.PatternPluginTabPanelItem {
        String title;
        private BGComboBox<DirectoryItem> groupBgComboBox;
        private BGComboBox<DirectoryItem> modeComboBox;
        Vector<DirectoryItem> groupVector;

        public HelpDeskPanel(int pid, String title) {
            super((LayoutManager)new GridBagLayout());
            this.title = null;
            this.groupBgComboBox = new BGComboBox();
            this.modeComboBox = new BGComboBox();
            this.groupVector = new Vector();
            this.title = "\u0420\u0435\u0436\u0438\u043c \u0438 \u0413\u0440\u0443\u043f\u043f\u0430";
            this.pid = pid;
            JPanel modePanel = new JPanel(new GridBagLayout());
            modePanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0436\u0438\u043c "));
            modePanel.add((Component)this.modeComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            JPanel groupPanel = new JPanel(new GridBagLayout());
            groupPanel.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u0430 "));
            groupPanel.add((Component)this.groupBgComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)modePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)groupPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add(panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        protected void init() {
            Request requestGroup = new Request();
            requestGroup.setModule("ru.bitel.bgbilling.plugins.helpdesk");
            requestGroup.setAction("GetHelpDeskLinksTab");
            this.setDocumentGroup(this.getDocument(requestGroup));
            if (this.groupBgComboBox.getModel().getSize() > 0) {
                this.groupBgComboBox.setSelectedIndex(0);
            }
            try {
                ClientContext clientContext = new ClientContext(null, -1, -1, "ru.bitel.bgbilling.plugins.helpdesk.client.contract.setup");
                DefaultComboBoxModel<DirectoryItem> model = new DefaultComboBoxModel<DirectoryItem>();
                for (DirectoryItem item : ((HelpdeskParamService)clientContext.getPort(HelpdeskParamService.class)).getModeList()) {
                    model.addElement(item);
                }
                this.modeComboBox.setModel(model);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void setData(Element element) {
            Element helpDesk;
            DirectoryItem noSelect = new DirectoryItem();
            noSelect.setId("0");
            noSelect.setTitle("\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
            this.groupVector.remove(noSelect);
            int modeListSize = this.modeComboBox.getModel().getSize();
            if (modeListSize > 0 && ((DirectoryItem)this.modeComboBox.getModel().getElementAt(modeListSize - 1)).getId().equals("0")) {
                this.modeComboBox.removeItemAt(modeListSize - 1);
            }
            if ((helpDesk = XMLUtils.selectElement((Node)element, (String)"//helpDesk")) != null) {
                String selectGroupId = helpDesk.getAttribute("selectGroupId");
                if (!selectGroupId.isEmpty()) {
                    int selectIndex = -1;
                    for (DirectoryItem item : this.groupVector) {
                        if (!item.getId().equals(selectGroupId)) continue;
                        selectIndex = this.groupVector.indexOf(item);
                        break;
                    }
                    if (selectIndex != -1) {
                        this.groupBgComboBox.setSelectedIndex(selectIndex);
                    } else {
                        this.setNoSelectItem(this.groupBgComboBox);
                    }
                } else {
                    this.setNoSelectItem(this.groupBgComboBox);
                }
                String medeId = helpDesk.getAttribute("mode");
                if (!medeId.equals("")) {
                    this.modeComboBox.setSelectedId(medeId);
                } else {
                    this.setNoSelectItem(this.modeComboBox);
                }
            } else {
                this.setNoSelectItem(this.groupBgComboBox);
                this.setNoSelectItem(this.modeComboBox);
            }
        }

        protected void reset() {
        }

        protected void serialise(Element element) {
            String modeId;
            Element helpDesk = XMLUtils.createElement((Element)element, (String)"helpDesk");
            DirectoryItem item = (DirectoryItem)this.groupBgComboBox.getSelectedItem();
            if (item != null && !item.getId().equals("0")) {
                helpDesk.setAttribute("selectGroupId", item.getId());
            }
            if (!(modeId = ((DirectoryItem)this.modeComboBox.getSelectedItem()).getId()).equals("0")) {
                helpDesk.setAttribute("mode", modeId);
            }
        }

        public String getTitle() {
            return this.title;
        }

        public void setDocumentGroup(Document doc) {
            if (ClientUtils.checkStatus((Document)doc)) {
                for (Element row : XMLUtils.selectElements((Node)doc, (String)"//table/dataGroup/*")) {
                    this.groupVector.add(new DirectoryItem(row.getAttribute("id"), row.getAttribute("title")));
                }
                this.groupBgComboBox.setModel(new DefaultComboBoxModel<DirectoryItem>(this.groupVector));
            }
        }

        private void setNoSelectItem(BGComboBox<DirectoryItem> bgComboBox) {
            DirectoryItem noSelectItem = new DirectoryItem("0", "\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
            bgComboBox.addItem((Object)noSelectItem);
            bgComboBox.setSelectedItem((Object)noSelectItem);
        }
    }
}

