/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.service;

import java.sql.SQLException;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskDirectoryService;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.HelpDeskDirectoryManager;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskDirectoryService")
public class HelpdeskDirectoryServiceImpl
extends AbstractService
implements HelpdeskDirectoryService {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");

    public SearchResult<IdTitle> getGroupList(boolean groupForDirectory, int contractId, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        HelpDeskDirectoryManager groupManager = new HelpDeskDirectoryManager(this.getConnection(), this.plugin);
        groupManager.getGroupList((SearchResult<IdTitle>)searchResult);
        if (!groupForDirectory && contractId > 0) {
            int selectGroupId = -2;
            try {
                if (groupManager.hasContractGroup(contractId)) {
                    selectGroupId = groupManager.getContractGroupId(contractId);
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            searchResult.setAttribute("selectGroupId", String.valueOf(selectGroupId));
        }
        return searchResult;
    }

    public void updateGroup(IdTitle idTitle) throws BGException {
        try {
            new HelpDeskDirectoryManager(this.getConnection(), this.plugin).updateGroupTitle(idTitle);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateCategory(IdTitle idTitle) throws BGException {
        try {
            new HelpDeskDirectoryManager(this.getConnection(), this.plugin).updateCategoryTitle(idTitle);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateSubCategory(IdTitle idTitle) throws BGException {
        try {
            new HelpDeskDirectoryManager(this.getConnection(), this.plugin).updateSubCategoryTitle(idTitle);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

